/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.hdkj.visitor.element;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.GetValueBO;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.extend.util.ExtendCustomVueUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HkCustomComponentVoidVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/hkelement/hdkj/hkCustomComponent/custom_component.ftl");
        this.renderImport(lcdpComponent, ctx);
        this.renderProps(lcdpComponent, ctx);
        this.renderAttr(lcdpComponent, ctx);
        this.renderEvent(lcdpComponent, ctx);
    }

    private void renderImport(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        String path = "";
        String componentName = "";
        Map props = lcdpComponent.getProps();
        String type = (String)props.get("type");
        String fileId = (String)props.get("fileId");
        Map<String, String> name = null;
        if (ToolUtil.isNotEmpty((Object)type) && ToolUtil.isNotEmpty((Object)fileId)) {
            if ("WebPage".equals(type)) {
                path = FileUtil.posixPath((String[])new String[]{this.fileMappingService.getFormatPath(fileId)});
                name = this.getComponentNameFromPath(path);
                componentName = name.get("importName");
                ctx.addImports("import " + componentName + " from '#/views" + path + "'");
            } else {
                String customPath = ExtendCustomVueUtil.getCustomVuePathById((String)fileId);
                path = customPath.replace("@", "").replace(".vue", "");
                name = this.getComponentNameFromPath(path);
                componentName = name.get("importName");
                ctx.addImports("import " + componentName + " from '" + customPath + "'");
            }
            ctx.addComponent(componentName);
            lcdpComponent.addRenderParam("componentName", (Object)name.get("componentName"));
        }
    }

    private void renderProps(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        ArrayList propsParam = new ArrayList();
        Map props = lcdpComponent.getProps();
        List propsConfig = (List)props.get("propsConfig");
        for (int i = 0; i < propsConfig.size(); ++i) {
            GetValueBO getValueBO = (GetValueBO)JSON.parseObject((String)((Map)propsConfig.get(i)).toString(), GetValueBO.class);
            String propName = String.join((CharSequence)"", getValueBO.getCurrentData());
            ComponentData componentData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)getValueBO.getComponentGetData());
            String renderValue = ToolUtil.isNotEmpty((Object)componentData) ? componentData.getRenderValue() : "''";
            HashMap<String, String> renderParam = new HashMap<String, String>();
            renderParam.put(propName, renderValue);
            HashMap<String, HashMap<String, String>> params = new HashMap<String, HashMap<String, String>>();
            params.put("params", renderParam);
            String computeName = lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)propName);
            ctx.addComputed(computeName, RenderUtil.renderTemplate((String)"/template/hkelement/hdkj/hkCustomComponent/custom_component_props.ftl", params));
            HashMap<String, String> prop = new HashMap<String, String>();
            prop.put("propName", propName);
            prop.put("propValue", computeName);
            propsParam.add(prop);
        }
        lcdpComponent.addRenderParam("propsList", propsParam);
    }

    private void renderAttr(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx);
    }

    private void renderEvent(LcdpComponent lcdpComponent, Ctx ctx) {
        List eventConfigs = lcdpComponent.getEvents();
        ArrayList events = new ArrayList();
        for (int i = 0; i < eventConfigs.size(); ++i) {
            HashMap<String, String> event = new HashMap<String, String>();
            EventConfig eventConfig = (EventConfig)eventConfigs.get(i);
            event.put("eventName", eventConfig.getTrigger());
            event.put("methodName", lcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)eventConfig.getTrigger()));
            events.add(event);
        }
        lcdpComponent.addRenderParam("eventsList", events);
        List triggers = lcdpComponent.getTrigger();
        if (ToolUtil.isNotEmpty((Object)triggers)) {
            triggers.clear();
        }
    }

    private Map<String, String> getComponentNameFromPath(String path) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] str = path.split("/");
        StringBuilder componentName = new StringBuilder("");
        StringBuilder importName = new StringBuilder("");
        for (int i = 0; i < str.length; ++i) {
            if ("".equals(importName.toString())) {
                componentName.append(str[i].toLowerCase());
            } else {
                componentName.append("-" + str[i].toLowerCase());
            }
            importName.append(ToolUtil.firstLetterToUpper((String)str[i].toLowerCase()));
        }
        result.put("componentName", componentName.toString());
        result.put("importName", importName.toString());
        return result;
    }
}

