/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.external.facade.theme.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.CaseFormat;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.service.Element;
import com.jxdinfo.hussar.formdesign.common.util.ColorUtil;
import com.jxdinfo.hussar.formdesign.common.util.DynDataUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.StyleGenerateUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.BoxShadow;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ComponentStyleSettings;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.DefaultStyle;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseConfig;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseFont;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemePadding;
import com.jxdinfo.hussar.formdesign.external.facade.theme.service.IHussarThemeCodeGenerateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@EnableAspectJAutoProxy(proxyTargetClass=true, exposeProxy=true)
public class HussarThemeCodeGenerateServiceImpl
implements IHussarThemeCodeGenerateService {
    @Resource
    private FormDesignProperties speedCodeProperties;
    @Resource
    private DefaultStyleCacheService defaultStyleCacheService;
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private FormDesignProperties formDesignProperties;
    private ThemeBaseConfig themeBaseConfig = new ThemeBaseConfig();
    private Logger logger = LoggerFactory.getLogger(HussarThemeCodeGenerateServiceImpl.class);

    @Autowired
    public HussarThemeCodeGenerateServiceImpl() {
    }

    public String getCommonCssJsonByScssVars(String componentLibrary, Map<String, List<ComponentStyleSettings>> scssVarsValue, ThemeBaseConfig themeBaseConfig, Map<String, String> themeVars) throws LcdpException {
        this.themeBaseConfig = themeBaseConfig;
        Map<String, Set<String>> styleMap = this.dealComponentCommonStyles(componentLibrary, scssVarsValue, themeVars);
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)styleMap.get("sortCommonStyleList")) + String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)styleMap.get("propsStyleList"));
    }

    public void writeWebScss(StyleScheme scheme) {
        List themeBaseFonts = scheme.getThemeBase().getWebPage().getFont();
        HashSet<String> fontContent = new HashSet<String>();
        this.traverseFont(themeBaseFonts, fontContent);
        PathStrategyService pathStrategyService = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
        String filePath = FileUtil.systemPath((String[])new String[]{pathStrategyService.vuePathService().getFrontProjectPath(), "\\src\\assets\\theme\\themeMixin.scss"});
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(String.join((CharSequence)"\n", fontContent), filePath);
    }

    public void traverseFont(List<ThemeBaseFont> themeBaseFonts, Set<String> fontContent) {
        for (ThemeBaseFont themeBaseFont : themeBaseFonts) {
            Map fonts = themeBaseFont.getFonts();
            if (fonts != null) {
                for (Map.Entry entry : fonts.entrySet()) {
                    String prop = (String)entry.getKey();
                    Object value = entry.getValue();
                    ArrayList<String> fontProps = new ArrayList<String>();
                    String title = null;
                    for (Map.Entry propEntry : ((Map)value).entrySet()) {
                        Map values;
                        String styleDecl;
                        String key = (String)propEntry.getKey();
                        Object propValue = propEntry.getValue();
                        if ("sort".equals(key)) continue;
                        if ("color".equals(key)) {
                            if (!DynDataUtil.isObjectType(value)) {
                                styleDecl = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, key) + ":" + propValue + ";";
                                fontProps.add(styleDecl);
                                continue;
                            }
                            values = (Map)propValue;
                            if (((Boolean)values.get("useRelated")).booleanValue()) {
                                Map color = (Map)values.get("related");
                                String styleDecl2 = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, key) + ":var(--c-" + color.get("color") + ");";
                                fontProps.add(styleDecl2);
                                continue;
                            }
                            String styleDecl3 = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, key) + ":" + values.get("color") + ";";
                            fontProps.add(styleDecl3);
                            continue;
                        }
                        if ("config".equals(key)) {
                            values = (Map)propValue;
                            title = (String)values.get("title");
                        }
                        if (!DynDataUtil.isBasicType(propValue)) continue;
                        styleDecl = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, key) + ":" + propValue + ";";
                        fontProps.add(styleDecl);
                    }
                    if (fontProps.isEmpty()) continue;
                    fontContent.add("// " + title + "\n@mixin font-" + prop + "\t{\n\t" + String.join((CharSequence)"\n\t", fontProps) + "\n}");
                }
            }
            if (!ToolUtil.isNotEmpty((Object)themeBaseFont.getFontsGroup())) continue;
            this.traverseFont(themeBaseFont.getFontsGroup(), fontContent);
        }
    }

    private Map<String, Set<String>> dealComponentCommonStyles(String componentLibrary, Map<String, List<ComponentStyleSettings>> scssVars, Map<String, String> themeVars) throws LcdpException {
        HashSet<String> commonStyleList = new HashSet<String>();
        HashSet<String> propsStyleList = new HashSet<String>();
        this.componentCommonStyle(componentLibrary, scssVars);
        for (Map.Entry<String, List<ComponentStyleSettings>> entry : scssVars.entrySet()) {
            String componentName = entry.getKey();
            DefaultStyle cachedDefaultStyle = Optional.ofNullable(this.defaultStyleCacheService.get(componentName)).orElse(null);
            if (cachedDefaultStyle == null) continue;
            Map interactionsVars = Optional.ofNullable(cachedDefaultStyle).map(DefaultStyle::getInteractionsVars).orElse(null);
            List<ComponentStyleSettings> componentStyleSettingsList = entry.getValue();
            if (componentStyleSettingsList == null) continue;
            for (ComponentStyleSettings componentStyleSettings : componentStyleSettingsList) {
                if (componentStyleSettings == null) continue;
                this.startFrom(commonStyleList, propsStyleList, componentStyleSettings, new StyleParams(componentName, "", componentStyleSettings.getName(), interactionsVars, null, null, cachedDefaultStyle, themeVars));
            }
        }
        TreeSet sortCommonStyleList = new TreeSet(Comparator.reverseOrder());
        sortCommonStyleList.addAll(commonStyleList);
        HashMap<String, Set<String>> setMap = new HashMap<String, Set<String>>();
        setMap.put("sortCommonStyleList", sortCommonStyleList);
        setMap.put("propsStyleList", propsStyleList);
        return setMap;
    }

    private void startFrom(Set<String> commonStyleList, Set<String> propsStyleList, ComponentStyleSettings componentStyleSettings, StyleParams params) throws LcdpException {
        block6: {
            DefaultStyle componentStyles;
            String settingsName;
            String componentName;
            DefaultStyle cachedDefaultStyle;
            Map<String, Object> interactionsVars;
            Map<String, String> themeVars;
            block5: {
                themeVars = params.getThemeVars();
                interactionsVars = params.getInteractionsVars();
                cachedDefaultStyle = params.getDefaultStyle();
                componentName = params.getComponentName();
                settingsName = componentStyleSettings.getName();
                componentStyles = componentStyleSettings.getStyleVars();
                this.complementComponentStyle(componentStyles, cachedDefaultStyle);
                this.genPropsStyle(propsStyleList, componentName, componentStyles.getProps(), interactionsVars, themeVars, cachedDefaultStyle, settingsName, "normal");
                if (!this.existThemeBase(componentStyles.getProps(), cachedDefaultStyle)) break block5;
                commonStyleList.addAll(this.single(new StyleParams(componentName, "normal", settingsName, interactionsVars, componentStyles, componentStyles, cachedDefaultStyle, themeVars)));
                if (componentStyles.getInteractions() == null) break block6;
                for (Map.Entry interactionEntry : componentStyles.getInteractions().entrySet()) {
                    if (!((DefaultStyle)interactionEntry.getValue()).getIsOpen().booleanValue()) continue;
                    if (((DefaultStyle)interactionEntry.getValue()).getProps() != null) {
                        this.genPropsStyle(propsStyleList, componentName, ((DefaultStyle)interactionEntry.getValue()).getProps(), interactionsVars, themeVars, cachedDefaultStyle, settingsName, (String)interactionEntry.getKey());
                        if (ToolUtil.isNotEmpty(((DefaultStyle)interactionEntry.getValue()).getProps().get("themeBase"))) {
                            commonStyleList.addAll(this.single(new StyleParams(componentName, (String)interactionEntry.getKey(), settingsName, interactionsVars, (DefaultStyle)interactionEntry.getValue(), componentStyles, cachedDefaultStyle, themeVars)));
                            continue;
                        }
                        this.dealCommonInteractionStyle(commonStyleList, componentName, (DefaultStyle)interactionEntry.getValue(), settingsName, (String)interactionEntry.getKey(), interactionsVars, themeVars, cachedDefaultStyle);
                        continue;
                    }
                    this.dealCommonInteractionStyle(commonStyleList, componentName, (DefaultStyle)interactionEntry.getValue(), settingsName, (String)interactionEntry.getKey(), interactionsVars, themeVars, cachedDefaultStyle);
                }
                break block6;
            }
            this.dealCommonInteractionStyle(commonStyleList, componentName, componentStyles, settingsName, "normal", interactionsVars, themeVars, cachedDefaultStyle);
            if (componentStyles.getInteractions() != null) {
                for (Map.Entry interaction : componentStyles.getInteractions().entrySet()) {
                    if (!((DefaultStyle)interaction.getValue()).getIsOpen().booleanValue()) continue;
                    this.dealCommonInteractionStyle(commonStyleList, componentName, (DefaultStyle)interaction.getValue(), settingsName, (String)interaction.getKey(), interactionsVars, themeVars, cachedDefaultStyle);
                }
            }
        }
    }

    private Set<String> single(StyleParams params) throws LcdpException {
        String componentName = params.getComponentName();
        DefaultStyle currentComponentStyle = params.getCurrentComponentStyle();
        HashSet<String> commonStyleList = new HashSet<String>();
        DefaultStyle defaultStyle = params.getDefaultStyle();
        Map scssVarProps = currentComponentStyle.getProps();
        Map scssThemeBase = Optional.ofNullable(scssVarProps.get("themeBase")).flatMap(DynDataUtil::asObject).orElseGet(HashMap::new);
        Map defaultThemeBase = Optional.ofNullable(defaultStyle.getProps().get("themeBase")).flatMap(DynDataUtil::asObject).orElseGet(HashMap::new);
        for (Map.Entry scssEntry : scssThemeBase.entrySet()) {
            Object themeBaseKey = scssEntry.getKey();
            Object themeBaseValue = scssEntry.getValue();
            if (!DynDataUtil.isBasicType(themeBaseKey) || !DynDataUtil.isBasicType(themeBaseValue)) continue;
            String key = themeBaseKey.toString();
            String value = themeBaseValue.toString();
            Object matchDefault = defaultThemeBase.get(key);
            if (!DynDataUtil.isObjectType(matchDefault)) {
                throw new LcdpException(LcdpExceptionEnum.ERROR, "\u7ec4\u4ef6\u9ed8\u8ba4\u503c\u57fa\u7840\u6837\u5f0f\u914d\u7f6e\u9519\u8bef\uff1a" + componentName + "." + key);
            }
            Map defaultConfig = (Map)JSON.parseObject((String)JSON.toJSONString(matchDefault), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            if (ObjectUtil.equal((Object)"custom", (Object)value)) {
                this.renderGroups(commonStyleList, defaultConfig, params);
                this.renderMultiSpacing(commonStyleList, defaultConfig, params, key);
                continue;
            }
            this.renderThemeBase(commonStyleList, defaultConfig, params, value, false);
        }
        if (currentComponentStyle.getStyles() != null) {
            this.renderGroupsStyle(commonStyleList, currentComponentStyle.getStyles(), params);
        }
        if (currentComponentStyle.getInnerStyles() != null) {
            this.renderGroupsInStyle(commonStyleList, currentComponentStyle.getInnerStyles(), params);
        }
        return commonStyleList;
    }

    private void renderThemeBase(Set<String> commonStyleList, Map<String, Object> defaultConfig, StyleParams params, String findKey, boolean isDefault) throws LcdpException {
        DefaultStyle currentComponentStyle = params.getCurrentComponentStyle();
        String componentName = params.getComponentName();
        String scene = params.getScene();
        String settingsName = params.getSettingsName();
        Map<String, Object> interactionsVars = params.getInteractionsVars();
        Map styles = currentComponentStyle.getStyles();
        Map innerStyles = currentComponentStyle.getInnerStyles();
        this.dealStyleExchange(componentName, styles, innerStyles, currentComponentStyle);
        String findType = Optional.ofNullable(defaultConfig.get("type")).flatMap(DynDataUtil::asString).orElseGet(String::new);
        Optional baseCssOpt = this.themeBaseConfig.find(findType, findKey);
        if (!baseCssOpt.isPresent()) {
            findKey = Optional.ofNullable(defaultConfig.get("value")).flatMap(DynDataUtil::asString).orElseGet(String::new);
            if (ObjectUtil.equal((Object)"custom", (Object)findKey)) {
                this.renderGroups(commonStyleList, defaultConfig, params);
            } else {
                if (isDefault) {
                    return;
                }
                this.renderThemeBase(commonStyleList, defaultConfig, params, findKey, true);
            }
            return;
        }
        HashMap stylesForRender = new HashMap();
        for (Map.Entry baseEntry : ((Map)baseCssOpt.get()).entrySet()) {
            String key = (String)baseEntry.getKey();
            Object value = baseEntry.getValue();
            if ("lineHeight".equals(key) && JSON.parseObject((String)defaultConfig.get("groups").toString()).get((Object)"lineHeight") == null) continue;
            if ("color".equals(key)) {
                if (!DynDataUtil.isObjectType(value)) {
                    stylesForRender.put(key, value);
                    continue;
                }
                Map values = (Map)value;
                if (((Boolean)values.get("useRelated")).booleanValue()) {
                    stylesForRender.put(key, value);
                    continue;
                }
                Object colorValue = values.get("color");
                stylesForRender.put(key, colorValue);
                continue;
            }
            if ("boxShadow".equals(key)) {
                stylesForRender.put(key, this.renderBoxShadow(key, value, params.getThemeVars(), params.getDefaultStyle(), params.getScene()));
                continue;
            }
            if ("config".equals(key) || "sort".equals(key)) continue;
            stylesForRender.put(key, value);
        }
        Object groupsObj = defaultConfig.get("groups");
        if (DynDataUtil.isObjectType((Object)groupsObj)) {
            Map defaultGroups = (Map)JSON.parseObject((String)JSON.toJSONString((Object)groupsObj), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            HashMap<String, Object> styleForRender = new HashMap<String, Object>();
            HashMap<String, Object> innerStyleForRender = new HashMap<String, Object>();
            for (Map.Entry groupsEntry : defaultGroups.entrySet()) {
                Object matched;
                String matchKey = (String)groupsEntry.getKey();
                Object groupsCssConfig = groupsEntry.getValue();
                if (!DynDataUtil.isObjectType(groupsCssConfig)) continue;
                Map cssConfig = (Map)JSON.parseObject((String)JSON.toJSONString(groupsCssConfig), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                Object siteObj = cssConfig.get("site");
                Object mapObj = cssConfig.get("map");
                Object valueObj = cssConfig.get("value");
                String sites = ObjectUtil.isEmpty(siteObj) ? String.valueOf(defaultConfig.get("site")) : String.valueOf(siteObj);
                String cssKey = ObjectUtil.isEmpty(mapObj) ? matchKey : String.valueOf(cssConfig.get("map"));
                String type = String.valueOf(defaultConfig.get("type"));
                if (ToolUtil.isEmpty((Object)currentComponentStyle.getInnerStyles())) {
                    currentComponentStyle.setInnerStyles(new HashMap());
                }
                if (ToolUtil.isEmpty((Object)currentComponentStyle.getStyles())) {
                    currentComponentStyle.setStyles(new HashMap());
                }
                if (cssKey.equals("textAlign") || cssKey.equals("lineHeight") || cssKey.equals("vertical")) {
                    if (ToolUtil.isEmpty(currentComponentStyle.getInnerStyles().get(matchKey)) && ToolUtil.isEmpty(currentComponentStyle.getStyles().get(matchKey))) {
                        if (cssKey.equals("lineHeight")) continue;
                        if (ObjectUtil.equal((Object)"styles", (Object)sites)) {
                            styleForRender.put(matchKey, this.normalizeStyleValue(valueObj));
                            continue;
                        }
                        if (!ObjectUtil.equal((Object)"innerStyles", (Object)sites)) continue;
                        innerStyleForRender.put(matchKey, this.normalizeStyleValue(valueObj));
                        continue;
                    }
                    if (ObjectUtil.equal((Object)"styles", (Object)sites)) {
                        matched = currentComponentStyle.getStyles().get(matchKey);
                        styleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                        if (!ObjectUtil.isNotEmpty(matched)) continue;
                        currentComponentStyle.getStyles().remove(matchKey);
                        continue;
                    }
                    if (!ObjectUtil.equal((Object)"innerStyles", (Object)sites)) continue;
                    matched = currentComponentStyle.getInnerStyles().get(matchKey);
                    innerStyleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                    if (!ObjectUtil.isNotEmpty(matched)) continue;
                    currentComponentStyle.getInnerStyles().remove(matchKey);
                    continue;
                }
                if (ObjectUtil.equal((Object)"styles", (Object)sites)) {
                    matched = stylesForRender.get(cssKey);
                    if ("shadow".equals(type)) {
                        styleForRender.put(matchKey, this.renderBoxShadow(matchKey, matched, params.getThemeVars(), params.getDefaultStyle(), params.getScene()));
                    } else {
                        styleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                    }
                    if (!ObjectUtil.isNotEmpty(matched)) continue;
                    currentComponentStyle.getStyles().remove(matchKey);
                    continue;
                }
                if (!ObjectUtil.equal((Object)"innerStyles", (Object)sites)) continue;
                matched = stylesForRender.get(cssKey);
                if ("shadow".equals(type)) {
                    innerStyleForRender.put(matchKey, this.renderBoxShadow(matchKey, matched, params.getThemeVars(), params.getDefaultStyle(), params.getScene()));
                } else {
                    innerStyleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                }
                if (!ObjectUtil.isNotEmpty(matched)) continue;
                currentComponentStyle.getInnerStyles().remove(matchKey);
            }
            this.renderGroupsStyle(commonStyleList, styleForRender, new StyleParams(componentName, scene, settingsName, interactionsVars, currentComponentStyle, params.getComponentStyle(), params.getDefaultStyle(), params.getThemeVars()));
            this.renderGroupsInStyle(commonStyleList, innerStyleForRender, new StyleParams(componentName, scene, settingsName, interactionsVars, currentComponentStyle, params.getComponentStyle(), params.getDefaultStyle(), params.getThemeVars()));
        }
    }

    private String renderBoxShadow(String prop, Object value, Map<String, String> themeVars, DefaultStyle defaultStyle, String scene) throws LcdpException {
        StringBuilder shadowStyle = new StringBuilder();
        String shadowColor = "";
        if (DynDataUtil.isBasicType((Object)value)) {
            return String.valueOf(value);
        }
        List boxShadows = (List)value;
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll((Collection)boxShadows);
        for (BoxShadow boxShadow : jsonArray.toJavaList(BoxShadow.class)) {
            if (!boxShadow.isChecked()) continue;
            if (DynDataUtil.isObjectType((Object)boxShadow.getColor())) {
                Optional useRelated = DynDataUtil.subscript((Object)boxShadow.getColor(), (String)"useRelated").flatMap(DynDataUtil::asBoolean);
                Optional color = DynDataUtil.subscript((Object)boxShadow.getColor(), (String)"color").flatMap(DynDataUtil::asString);
                Optional relatedColor = DynDataUtil.subscript((Object)boxShadow.getColor(), (Object[])new Object[]{"related", "color"}).flatMap(DynDataUtil::asString);
                if (useRelated.orElse(false).booleanValue()) {
                    if (!relatedColor.isPresent()) {
                        throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, "\u5f15\u7528\u5bf9\u8c61\u7f3a\u5931 related.color");
                    }
                    shadowColor = this.resolveGradientColorValue(prop, (String)relatedColor.get(), themeVars, defaultStyle, scene, defaultStyle.getInteractionsVars());
                } else {
                    shadowColor = color.orElse("");
                }
                shadowStyle.append(StringUtils.join((Object[])new String[]{shadowColor, " ", boxShadow.getShadow(), " ", boxShadow.getType(), ","}));
                continue;
            }
            shadowStyle.append(StringUtils.join((Object[])new Object[]{boxShadow.getColor(), " ", boxShadow.getShadow(), " ", boxShadow.getType(), ","}));
        }
        if (!"".equals(shadowStyle.toString())) {
            return shadowStyle.substring(0, shadowStyle.length() - 1);
        }
        return "none";
    }

    private String renderPadding(Object value, Object defaultObj) {
        if (DynDataUtil.isBasicType((Object)value)) {
            return String.valueOf(value);
        }
        StringBuilder paddingStyle = new StringBuilder();
        JSONArray jsonArray = new JSONArray();
        jsonArray.addAll((Collection)((List)value));
        List paddings = jsonArray.toJavaList(ThemePadding.class);
        JSONArray defaultJsonArray = new JSONArray();
        defaultJsonArray.addAll((Collection)((List)defaultObj));
        List defaultPaddings = defaultJsonArray.toJavaList(ThemePadding.class);
        for (int i = 0; i < paddings.size(); ++i) {
            ThemePadding themePadding = (ThemePadding)paddings.get(i);
            boolean isExsit = this.renderPaddingValue(themePadding, paddingStyle);
            if (isExsit) continue;
            this.renderPaddingValue((ThemePadding)defaultPaddings.get(i), paddingStyle);
        }
        if (!"".equals(paddingStyle.toString())) {
            return paddingStyle.substring(0, paddingStyle.length() - 1);
        }
        return "";
    }

    private boolean renderPaddingValue(ThemePadding themePadding, StringBuilder paddingStyle) {
        if ("custom".equals(themePadding.getTemplate())) {
            paddingStyle.append(StringUtils.join((Object[])new String[]{themePadding.getValue(), " "}));
            return true;
        }
        Optional baseCssOpt = this.themeBaseConfig.find(themePadding.getType(), themePadding.getTemplate());
        if (!baseCssOpt.isPresent()) {
            return false;
        }
        for (Map.Entry baseEntry : ((Map)baseCssOpt.get()).entrySet()) {
            String key = (String)baseEntry.getKey();
            Object spaceValue = baseEntry.getValue();
            if (!"space".equals(key)) continue;
            paddingStyle.append(StringUtils.join((Object[])new String[]{String.valueOf(spaceValue), " "}));
        }
        return true;
    }

    private void renderGroups(Set<String> commonStyleList, Map<String, Object> defaultConfig, StyleParams params) throws LcdpException {
        DefaultStyle currentComponentStyle = params.getCurrentComponentStyle();
        String componentName = params.getComponentName();
        String scene = params.getScene();
        String settingsName = params.getSettingsName();
        Map<String, Object> interactionsVars = params.getInteractionsVars();
        Map styles = currentComponentStyle.getStyles();
        Map innerStyles = currentComponentStyle.getInnerStyles();
        this.dealStyleExchange(componentName, styles, innerStyles, currentComponentStyle);
        Object groupsObj = defaultConfig.get("groups");
        if (DynDataUtil.isObjectType((Object)groupsObj)) {
            Map defaultGroups = (Map)JSON.parseObject((String)JSON.toJSONString((Object)groupsObj), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            HashMap<String, Object> styleForRender = new HashMap<String, Object>();
            HashMap<String, Object> innerStyleForRender = new HashMap<String, Object>();
            for (Map.Entry groupsEntry : defaultGroups.entrySet()) {
                String matchKey = (String)groupsEntry.getKey();
                Object groupsCssConfig = groupsEntry.getValue();
                if (!DynDataUtil.isObjectType(groupsCssConfig)) continue;
                Map cssConfig = (Map)JSON.parseObject((String)JSON.toJSONString(groupsCssConfig), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                Object siteObj = cssConfig.get("site");
                Object valueObj = cssConfig.get("value");
                String site = ObjectUtil.isEmpty(siteObj) ? String.valueOf(defaultConfig.get("site")) : String.valueOf(siteObj);
                String type = String.valueOf(defaultConfig.get("type"));
                Object matched = null;
                if (ObjectUtil.equal((Object)"styles", (Object)site)) {
                    if (currentComponentStyle.getStyles() != null) {
                        matched = currentComponentStyle.getStyles().get(matchKey);
                    }
                    if ("shadow".equals(type)) {
                        if (matched != null) {
                            styleForRender.put(matchKey, this.renderBoxShadow(matchKey, matched, params.getThemeVars(), params.getDefaultStyle(), params.getScene()));
                        } else {
                            styleForRender.put(matchKey, this.renderBoxShadow(matchKey, valueObj, params.getThemeVars(), params.getDefaultStyle(), params.getScene()));
                        }
                    } else {
                        styleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                    }
                    if (!ObjectUtil.isNotEmpty(matched)) continue;
                    currentComponentStyle.getStyles().remove(matchKey);
                    continue;
                }
                if (!ObjectUtil.equal((Object)"innerStyles", (Object)site)) continue;
                if (currentComponentStyle.getInnerStyles() != null) {
                    matched = currentComponentStyle.getInnerStyles().get(matchKey);
                }
                if ("shadow".equals(type)) {
                    if (matched != null) {
                        innerStyleForRender.put(matchKey, this.renderBoxShadow(matchKey, matched, params.getThemeVars(), params.getDefaultStyle(), params.getScene()));
                    } else {
                        innerStyleForRender.put(matchKey, this.renderBoxShadow(matchKey, valueObj, params.getThemeVars(), params.getDefaultStyle(), params.getScene()));
                    }
                } else {
                    innerStyleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                }
                if (!ObjectUtil.isNotEmpty(matched) || currentComponentStyle.getInnerStyles() == null) continue;
                currentComponentStyle.getInnerStyles().remove(matchKey);
            }
            this.renderGroupsStyle(commonStyleList, styleForRender, new StyleParams(componentName, scene, settingsName, interactionsVars, currentComponentStyle, params.getComponentStyle(), params.getDefaultStyle(), params.getThemeVars()));
            this.renderGroupsInStyle(commonStyleList, innerStyleForRender, new StyleParams(componentName, scene, settingsName, interactionsVars, currentComponentStyle, params.getComponentStyle(), params.getDefaultStyle(), params.getThemeVars()));
        }
    }

    private void renderMultiSpacing(Set<String> commonStyleList, Map<String, Object> defaultConfig, StyleParams params, String key) throws LcdpException {
        DefaultStyle currentComponentStyle = params.getCurrentComponentStyle();
        String componentName = params.getComponentName();
        String scene = params.getScene();
        String settingsName = params.getSettingsName();
        Map<String, Object> interactionsVars = params.getInteractionsVars();
        Map styles = currentComponentStyle.getStyles();
        Map innerStyles = currentComponentStyle.getInnerStyles();
        this.dealStyleExchange(componentName, styles, innerStyles, currentComponentStyle);
        Object defaultObj = defaultConfig.get("default");
        if (DynDataUtil.isArrayType((Object)defaultObj)) {
            HashMap<String, Object> styleForRender = new HashMap<String, Object>();
            HashMap<String, Object> innerStyleForRender = new HashMap<String, Object>();
            Object matched = null;
            if (ObjectUtil.equal((Object)"styles", (Object)String.valueOf(defaultConfig.get("site")))) {
                if (currentComponentStyle.getStyles() != null) {
                    matched = currentComponentStyle.getStyles().get(key);
                }
                styleForRender.put(key, this.renderPadding(ObjectUtil.isEmpty(matched) ? defaultObj : matched, defaultObj));
                if (ObjectUtil.isNotEmpty(matched)) {
                    currentComponentStyle.getStyles().remove(key);
                }
            } else if (ObjectUtil.equal((Object)"innerStyles", (Object)String.valueOf(defaultConfig.get("site")))) {
                if (currentComponentStyle.getInnerStyles() != null) {
                    matched = currentComponentStyle.getInnerStyles().get(key);
                }
                innerStyleForRender.put(key, this.renderPadding(ObjectUtil.isEmpty(matched) ? defaultObj : matched, defaultObj));
                if (ObjectUtil.isNotEmpty(matched)) {
                    currentComponentStyle.getInnerStyles().remove(key);
                }
            }
            this.renderGroupsStyle(commonStyleList, styleForRender, new StyleParams(componentName, scene, settingsName, interactionsVars, currentComponentStyle, params.getComponentStyle(), params.getDefaultStyle(), params.getThemeVars()));
            this.renderGroupsInStyle(commonStyleList, innerStyleForRender, new StyleParams(componentName, scene, settingsName, interactionsVars, currentComponentStyle, params.getComponentStyle(), params.getDefaultStyle(), params.getThemeVars()));
        }
    }

    private Object normalizeStyleValue(Object value) {
        if (DynDataUtil.isBasicType((Object)value)) {
            return DynDataUtil.asString((Object)value).orElse(null);
        }
        return value;
    }

    private boolean existThemeBase(Map<String, Object> scssVarProps, DefaultStyle defaultStyle) {
        return ToolUtil.isNotEmpty(scssVarProps) && ToolUtil.isNotEmpty((Object)scssVarProps.get("themeBase")) && ToolUtil.isNotEmpty((Object)defaultStyle.getProps()) && ToolUtil.isNotEmpty(defaultStyle.getProps().get("themeBase"));
    }

    private ClassPreview classNamePre(String componentName, String settingsName, String scene) {
        String commonStylePrefix;
        String className = StyleFactory.get((String)componentName);
        String clazz = ClazzFactory.get((String)componentName);
        if (null != clazz) {
            LcdpComponent currentComponentTempInstance;
            try {
                currentComponentTempInstance = (LcdpComponent)SpringUtil.getBean(Class.forName(clazz));
            }
            catch (ClassNotFoundException e) {
                currentComponentTempInstance = (LcdpComponent)SpringUtil.getPluginUtil().getBean(Element.class, clazz);
            }
            if (HussarUtils.isNotEmpty((Object)currentComponentTempInstance)) {
                commonStylePrefix = currentComponentTempInstance.getCommonStyleClassPrefix();
            } else {
                if (this.speedCodeProperties.isDeveloperMode()) {
                    this.logger.debug("\u627e\u4e0d\u5230\uff1a" + componentName + "\u5bf9\u5e94\u7684\u7c7b");
                }
                commonStylePrefix = ".lcdp_axe";
            }
        } else {
            if (this.speedCodeProperties.isDeveloperMode()) {
                this.logger.debug("\u627e\u4e0d\u5230\uff1a" + componentName + "\u5bf9\u5e94\u7684\u7c7b");
            }
            commonStylePrefix = ".lcdp_axe";
        }
        String settingsClassName = ToolUtil.isNotEmpty((Object)settingsName) ? "." + settingsName : "";
        String interactiveStyleAdditionClass = StyleGenerateUtil.removeDeepSelectors((String)InteractiveClassFactory.getComponentSceneClass((String)componentName, (String)scene));
        String sceneStyleClassName = "";
        if (null != className && !"".equals(className)) {
            if (!className.startsWith(".")) {
                className = "." + className;
            }
            className = className + settingsClassName;
            className = className + interactiveStyleAdditionClass;
            sceneStyleClassName = ToolUtil.isNotEmpty((Object)commonStylePrefix) ? ".jxd_additional" + commonStylePrefix + " " + className : className;
        }
        return new ClassPreview(clazz, sceneStyleClassName, interactiveStyleAdditionClass);
    }

    private void renderGroupsStyle(Set<String> commonStyleList, Map<String, Object> stylesWait, StyleParams params) throws LcdpException {
        DefaultStyle currentComponentStyle = params.getCurrentComponentStyle();
        String componentName = params.getComponentName();
        String scene = params.getScene();
        String settingsName = params.getSettingsName();
        Map<String, Object> interactionsVars = params.getInteractionsVars();
        Map<String, String> themeVars = params.getThemeVars();
        DefaultStyle componentStyle = params.getDefaultStyle();
        ClassPreview classPreview = this.classNamePre(componentName, settingsName, scene);
        if (stylesWait != null && classPreview.getInteractiveStyleAdditionClass() != null) {
            this.genCommonSceneStyle(commonStyleList, currentComponentStyle, classPreview.getSceneStyleClassName(), classPreview.getClazz(), stylesWait, scene, interactionsVars, themeVars, componentStyle, componentName);
        }
    }

    private void renderGroupsInStyle(Set<String> commonStyleList, Map<String, Object> stylesWait, StyleParams params) {
        String componentName = params.getComponentName();
        String scene = params.getScene();
        String settingsName = params.getSettingsName();
        Map<String, Object> interactionsVars = params.getInteractionsVars();
        Map<String, String> themeVars = params.getThemeVars();
        DefaultStyle componentStyle = params.getDefaultStyle();
        ClassPreview classPreview = this.classNamePre(componentName, settingsName, scene);
        if (stylesWait != null && classPreview.getInteractiveStyleAdditionClass() != null) {
            this.genCommonInnerStyle(commonStyleList, componentName, stylesWait, classPreview.getSceneStyleClassName(), classPreview.getClazz(), scene, interactionsVars, themeVars, componentStyle, settingsName);
        }
    }

    private void dealCommonInteractionStyle(Set<String> commonStyleList, String componentName, DefaultStyle componentStyle, String settingsName, String scene, Map<String, Object> interactionsVars, Map<String, String> themeVars, DefaultStyle componentDefaultStyle) throws LcdpException {
        Map styles = componentStyle.getStyles();
        Map innerStyles = componentStyle.getInnerStyles();
        this.dealStyleExchange(componentName, styles, innerStyles, componentStyle);
        ClassPreview classPreview = this.classNamePre(componentName, settingsName, scene);
        Map defaultStyles = Optional.ofNullable(componentStyle.getStyles()).orElse(null);
        if (null != classPreview.getInteractiveStyleAdditionClass() && defaultStyles != null) {
            this.genCommonSceneStyle(commonStyleList, componentStyle, classPreview.getSceneStyleClassName(), classPreview.getClazz(), defaultStyles, scene, interactionsVars, themeVars, componentDefaultStyle, componentName);
        }
        this.genCommonInnerStyle(commonStyleList, componentName, componentStyle.getInnerStyles(), classPreview.getSceneStyleClassName(), classPreview.getClazz(), scene, interactionsVars, themeVars, componentDefaultStyle, settingsName);
    }

    private void genCommonSceneStyle(Set<String> commonStyleList, DefaultStyle componentStyles, String className, String clazz, Map<String, Object> defaultStyles, String scene, Map<String, Object> interactionsVars, Map<String, String> themeVars, DefaultStyle componentDefaultStyle, String componentName) throws LcdpException {
        boolean isConfigWidth;
        ArrayList<String> lines = new ArrayList<String>();
        boolean containsAnyStyle = false;
        boolean isConfigHeight = componentStyles.getHeight() != null;
        boolean bl = isConfigWidth = componentStyles.getWidth() != null;
        if (isConfigHeight) {
            lines.add("height: " + this.addPx(componentStyles.getHeight()) + ";");
            containsAnyStyle = true;
        }
        if (isConfigWidth) {
            lines.add("width: " + this.addPx(componentStyles.getWidth()) + ";");
            containsAnyStyle = true;
        }
        if (clazz != null) {
            LcdpComponent lcdpComponent;
            block12: {
                lcdpComponent = null;
                try {
                    lcdpComponent = (LcdpComponent)Class.forName(clazz).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    LcdpComponent component = (LcdpComponent)SpringUtil.getPluginUtil().getBean(Element.class, clazz);
                    if (!HussarUtils.isNotEmpty((Object)component)) break block12;
                    try {
                        lcdpComponent = (LcdpComponent)component.getClass().newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            if (HussarUtils.isNotEmpty((Object)lcdpComponent)) {
                Map styleTemplate = lcdpComponent.outerStyleTemplate();
                Map<String, Object> mergeStyles = this.mergeBackGroundColorAndImage(defaultStyles, themeVars, interactionsVars, scene, componentDefaultStyle, componentName);
                for (Map.Entry<String, Object> entry : mergeStyles.entrySet()) {
                    boolean hasValue;
                    String prop = entry.getKey();
                    Object value = entry.getValue();
                    String propTemplate = null;
                    if (styleTemplate != null) {
                        propTemplate = StyleGenerateUtil.removeDeepSelectors((String)((String)styleTemplate.get(prop)));
                    }
                    boolean hasStyleTemplate = null != propTemplate;
                    boolean bl2 = hasValue = value != null && !"".equals(value);
                    if (hasStyleTemplate && hasValue) {
                        String resolvedValue = this.resolveStyle(prop, value, componentDefaultStyle, interactionsVars, scene, themeVars, false, componentName);
                        if (resolvedValue == null) continue;
                        String propStyle = StyleGenerateUtil.backgroundReplace((String)propTemplate).replace("${prefix}", className.trim()).replace("${val}", resolvedValue);
                        commonStyleList.add(propStyle);
                        continue;
                    }
                    String resolvedValue = this.resolveStyle(prop, value, componentDefaultStyle, interactionsVars, scene, themeVars, false, componentName);
                    if (resolvedValue == null) continue;
                    String styleBody = StyleGenerateUtil.backgroundReplace((String)(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, prop) + ":")) + resolvedValue + ";";
                    lines.add(styleBody);
                    containsAnyStyle = true;
                }
            }
        }
        lines.sort(Collections.reverseOrder());
        if (containsAnyStyle) {
            commonStyleList.add(className + "{" + String.join((CharSequence)"", lines) + "}");
        }
    }

    private void genPropsStyle(Set<String> commonStyleList, String componentName, Map<String, Object> props, Map<String, Object> interactionsVars, Map<String, String> themeVars, DefaultStyle componentDefaultStyle, String settingsName, String scene) {
        block20: {
            if (null != props) {
                LcdpComponent lcdpComponent = null;
                try {
                    ClassPreview classPreview = this.classNamePre(componentName, settingsName, scene);
                    if (null != classPreview.clazz) {
                        block19: {
                            try {
                                lcdpComponent = (LcdpComponent)Class.forName(classPreview.clazz).newInstance();
                            }
                            catch (ClassNotFoundException e) {
                                LcdpComponent component = (LcdpComponent)SpringUtil.getPluginUtil().getBean(Element.class, classPreview.clazz);
                                if (!HussarUtils.isNotEmpty((Object)component)) break block19;
                                lcdpComponent = (LcdpComponent)component.getClass().newInstance();
                            }
                        }
                        if (HussarUtils.isNotEmpty((Object)lcdpComponent)) {
                            Map propsTemplate = lcdpComponent.propsTemplate();
                            if (propsTemplate == null) break block20;
                            for (Map.Entry<String, Object> style : props.entrySet()) {
                                boolean hasValue;
                                String prop = style.getKey();
                                Object value = style.getValue();
                                String propTemplate = StyleGenerateUtil.removeDeepSelectors((String)((String)propsTemplate.get(prop)));
                                if (ToolUtil.isNotEmpty((Object)propTemplate) && propTemplate.equals("dynamicStyleTemplate")) {
                                    Class<?> componentClass;
                                    block21: {
                                        componentClass = null;
                                        try {
                                            componentClass = Class.forName(ClazzFactory.get((String)componentName));
                                        }
                                        catch (ClassNotFoundException e) {
                                            LcdpComponent component = (LcdpComponent)SpringUtil.getPluginUtil().getBean(componentName, "", "");
                                            if (!HussarUtils.isNotEmpty((Object)component)) break block21;
                                            componentClass = component.getClass();
                                        }
                                    }
                                    if (HussarUtils.isNotEmpty(componentClass)) {
                                        try {
                                            Function invoke = (Function)componentClass.getMethod("dynamicStyleTemplate", String.class).invoke((Object)"dynamicStyleTemplate", prop);
                                            if (ToolUtil.isNotEmpty((Object)value)) {
                                                propTemplate = (String)invoke.apply(value);
                                            }
                                        }
                                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                                            this.logger.error("\u6e32\u67d3\u6837\u5f0f\u5f02\u5e38", (Throwable)e);
                                        }
                                    }
                                }
                                boolean hasStyleTemplate = null != propTemplate;
                                boolean bl = hasValue = value != null && !"".equals(value);
                                if (hasStyleTemplate && hasValue) {
                                    String resolvedValue = DynDataUtil.isBasicType((Object)value) ? String.valueOf(value) : "";
                                    String propStyle = propTemplate.replace("${prefix}", classPreview.sceneStyleClassName.trim()).replace("${val}", resolvedValue);
                                    commonStyleList.add(propStyle);
                                    continue;
                                }
                                if (!hasStyleTemplate && this.speedCodeProperties.isDeveloperMode()) {
                                    this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684'" + prop + "'\u6837\u5f0f\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6837\u5f0f\u6a21\u677f");
                                }
                                if (hasValue || !this.speedCodeProperties.isDeveloperMode()) continue;
                                this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684'" + prop + "'\u6837\u5f0f\u65f6\u627e\u4e0d\u5230'\u503c'");
                            }
                            break block20;
                        }
                        if (this.speedCodeProperties.isDeveloperMode()) {
                            this.logger.info("\u627e\u4e0d\u5230\uff1a" + componentName + "\u5bf9\u5e94\u7684\u7c7b");
                        }
                        break block20;
                    }
                    if (this.speedCodeProperties.isDeveloperMode()) {
                        this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684innerStyle\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684propsTemplate");
                    }
                }
                catch (IllegalAccessException | InstantiationException | NullPointerException e) {
                    this.logger.error("\u6e32\u67d3\u6837\u5f0f\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void genCommonInnerStyle(Set<String> commonStyleList, String componentName, Map<String, Object> innerStyleDefault, String className, String clazz, String scene, Map<String, Object> interactionsVars, Map<String, String> themeVars, DefaultStyle componentDefaultStyle, String settingName) {
        block27: {
            if (null != innerStyleDefault) {
                if (null != clazz) {
                    LcdpComponent lcdpComponent = null;
                    try {
                        block24: {
                            try {
                                lcdpComponent = (LcdpComponent)Class.forName(clazz).newInstance();
                            }
                            catch (ClassNotFoundException e) {
                                LcdpComponent component = (LcdpComponent)SpringUtil.getPluginUtil().getBean(Element.class, clazz);
                                if (!HussarUtils.isNotEmpty((Object)component)) break block24;
                                lcdpComponent = (LcdpComponent)component.getClass().newInstance();
                            }
                        }
                        if (HussarUtils.isNotEmpty((Object)lcdpComponent)) {
                            Map styleTemplate = lcdpComponent.styleTemplate();
                            if (styleTemplate != null) {
                                Map<String, Object> mergeStyles = this.mergeBackGroundColorAndImage(innerStyleDefault, themeVars, interactionsVars, scene, componentDefaultStyle, componentName);
                                for (Map.Entry<String, Object> entry : mergeStyles.entrySet()) {
                                    boolean hasValue;
                                    String prop = entry.getKey();
                                    Object value = entry.getValue();
                                    String propTemplate = StyleGenerateUtil.removeDeepSelectors((String)((String)styleTemplate.get(prop)));
                                    if (ToolUtil.isNotEmpty((Object)propTemplate) && propTemplate.equals("dynamicStyleTemplate")) {
                                        Class<?> componentClass;
                                        block25: {
                                            componentClass = null;
                                            try {
                                                componentClass = Class.forName(ClazzFactory.get((String)componentName));
                                            }
                                            catch (ClassNotFoundException e) {
                                                LcdpComponent component = (LcdpComponent)SpringUtil.getPluginUtil().getBean(componentName, "", "");
                                                if (!HussarUtils.isNotEmpty((Object)component)) break block25;
                                                componentClass = component.getClass();
                                            }
                                        }
                                        if (HussarUtils.isNotEmpty(componentClass)) {
                                            try {
                                                Function invoke = (Function)componentClass.getMethod("dynamicStyleTemplate", String.class).invoke((Object)"dynamicStyleTemplate", prop);
                                                if (ToolUtil.isNotEmpty((Object)value)) {
                                                    propTemplate = (String)invoke.apply(value);
                                                }
                                            }
                                            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                                                this.logger.error("\u6e32\u67d3\u6837\u5f0f\u5f02\u5e38", (Throwable)e);
                                            }
                                        } else if (this.speedCodeProperties.isDeveloperMode()) {
                                            this.logger.info("\u627e\u4e0d\u5230\uff1a" + componentName + "\u5bf9\u5e94\u7684\u7c7b");
                                        }
                                    }
                                    boolean hasStyleTemplate = null != propTemplate;
                                    boolean bl = hasValue = value != null && !"".equals(value);
                                    if (hasStyleTemplate && hasValue) {
                                        String resolvedValue = this.resolveStyle(prop, value, componentDefaultStyle, interactionsVars, scene, themeVars, false, componentName);
                                        if (resolvedValue == null) continue;
                                        String propStyle = StyleGenerateUtil.backgroundReplace((String)propTemplate).replace("${prefix}", className.trim()).replace("${val}", resolvedValue);
                                        propStyle = settingName != null ? propStyle.replace("${prefix2}", settingName) : propStyle.replace("${prefix2}", "");
                                        commonStyleList.add(propStyle);
                                        continue;
                                    }
                                    if (!hasStyleTemplate && this.speedCodeProperties.isDeveloperMode()) {
                                        this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684'" + prop + "'\u6837\u5f0f\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6837\u5f0f\u6a21\u677f");
                                    }
                                    if (hasValue || !this.speedCodeProperties.isDeveloperMode()) continue;
                                    this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684'" + prop + "'\u6837\u5f0f\u65f6\u627e\u4e0d\u5230'\u503c'");
                                }
                                break block27;
                            }
                            if (this.speedCodeProperties.isDeveloperMode()) {
                                this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684innerStyle\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684styleTemplate");
                            }
                            break block27;
                        }
                        if (this.speedCodeProperties.isDeveloperMode()) {
                            this.logger.info("\u627e\u4e0d\u5230\uff1a" + componentName + "\u5bf9\u5e94\u7684\u7c7b");
                        }
                    }
                    catch (LcdpException | IllegalAccessException | InstantiationException e) {
                        this.logger.error("\u6e32\u67d3\u6837\u5f0f\u5f02\u5e38", e);
                    }
                } else if (this.speedCodeProperties.isDeveloperMode()) {
                    this.logger.info("\u627e\u4e0d\u5230\uff1a" + componentName + "\u5bf9\u5e94\u7684\u7c7b");
                }
            }
        }
    }

    private Map<String, Object> mergeBackGroundColorAndImage(Map<String, Object> defaultStyles, Map<String, String> themeVars, Map<String, Object> interactionsVars, String scene, DefaultStyle componentDefaultStyle, String componentName) throws LcdpException {
        boolean isExist;
        String prefix;
        Object value;
        String key;
        HashMap<String, Object> bgMap = new HashMap<String, Object>();
        HashMap<String, String> colorMap = new HashMap<String, String>();
        HashMap<String, Object> imageMap = new HashMap<String, Object>();
        HashMap<String, Object> finalMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : defaultStyles.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.contains("background") || key.contains("bg") || key.contains("Background") || key.contains("Bg")) {
                bgMap.put(key, value);
                continue;
            }
            finalMap.put(key, value);
        }
        for (Map.Entry<String, Object> entry : bgMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (key.contains("Color")) {
                String resolveValue = this.resolveStyle(key, value, componentDefaultStyle, interactionsVars, scene, themeVars, false, componentName);
                colorMap.put(key, resolveValue);
                continue;
            }
            if (key.contains("Image")) {
                imageMap.put(key, value);
                continue;
            }
            finalMap.put(key, value);
        }
        for (Map.Entry<String, Object> entry : imageMap.entrySet()) {
            String imageKey = entry.getKey();
            Object imageValue = entry.getValue();
            int index = imageKey.indexOf("Image");
            prefix = imageKey.substring(0, index);
            isExist = false;
            for (Map.Entry colorEntry : colorMap.entrySet()) {
                if (!((String)colorEntry.getKey()).contains(prefix)) continue;
                finalMap.put((String)colorEntry.getKey(), imageValue + "," + colorEntry.getValue());
                isExist = true;
            }
            if (isExist) continue;
            finalMap.put(imageKey, imageValue);
        }
        for (Map.Entry<String, Object> entry : colorMap.entrySet()) {
            String colorKey = entry.getKey();
            Object colorValue = entry.getValue();
            int index = colorKey.indexOf("Color");
            prefix = colorKey.substring(0, index);
            isExist = false;
            for (Map.Entry imageEntry : imageMap.entrySet()) {
                if (!((String)imageEntry.getKey()).contains(prefix) || !ToolUtil.isNotEmpty(imageEntry.getValue())) continue;
                isExist = true;
            }
            if (isExist) continue;
            finalMap.put(colorKey, colorValue);
        }
        return finalMap;
    }

    private void dealStyleExchange(String component, Map<String, Object> styles, Map<String, Object> innerStyles, DefaultStyle defaultStyle) {
        Map styleRemoveMap;
        if (ToolUtil.isNotEmpty(styles)) {
            StyleFactory.getStyleExchangeToInnerStyle().forEach((componentName, styleMap) -> {
                if (componentName.equals(component)) {
                    styleMap.forEach((styleName, styleTemplateName) -> {
                        Object toExchangeProperty = styles.get(styleName);
                        if (null != toExchangeProperty && null != innerStyles) {
                            innerStyles.put((String)styleTemplateName, toExchangeProperty);
                        }
                        styles.remove(styleName);
                    });
                }
            });
        }
        if (!CollectionUtils.isEmpty(innerStyles)) {
            StyleFactory.getInnerStyleToStyle().forEach((componentName, styleMap) -> {
                if (componentName.equals(component)) {
                    styleMap.forEach((styleTemplateName, styleName) -> {
                        Object toExchangeProperty = innerStyles.get(styleTemplateName);
                        if (null != toExchangeProperty && null != styles) {
                            styles.put((String)styleName, toExchangeProperty);
                        }
                        innerStyles.remove(styleTemplateName);
                    });
                }
            });
        }
        if (null != (styleRemoveMap = (Map)StyleFactory.getStyleRemove().get(component))) {
            Set baseStyleRemove;
            Set innerStyleRemove;
            Set styleRemove = (Set)styleRemoveMap.get("style");
            if (null != styleRemove && ToolUtil.isNotEmpty(styles)) {
                styleRemove.forEach(styles::remove);
            }
            if (null != (innerStyleRemove = (Set)styleRemoveMap.get("innerStyle")) && !CollectionUtils.isEmpty(innerStyles)) {
                innerStyleRemove.forEach(innerStyles::remove);
            }
            if (null != (baseStyleRemove = (Set)styleRemoveMap.get("base"))) {
                if (baseStyleRemove.contains("width")) {
                    defaultStyle.setWidth(null);
                }
                if (baseStyleRemove.contains("height")) {
                    defaultStyle.setHeight(null);
                }
            }
        }
    }

    @ExceptionCatcher
    public String defaultStyleGenerate(Map<String, DefaultStyle> defaultStyle, Map<String, String> themeVars, ThemeBaseConfig themeBaseConfig, Map<String, List<ComponentStyleSettings>> scssVarsValue) throws LcdpException {
        Set<String> defaultStyleSet = this.genDefaultStyleByDefaultStyleMap(defaultStyle, themeVars, themeBaseConfig);
        return String.join((CharSequence)System.lineSeparator(), defaultStyleSet);
    }

    public Set<String> genDefaultStyleByDefaultStyleMap(Map<String, DefaultStyle> defaultStyleMap, Map<String, String> themeVars, ThemeBaseConfig themeBaseConfig) throws LcdpException {
        if (ToolUtil.isNotEmpty(defaultStyleMap)) {
            HashSet<String> defaultStyleSet = new HashSet<String>();
            for (Map.Entry<String, DefaultStyle> entry : defaultStyleMap.entrySet()) {
                Map innerStyleDefault;
                boolean isConfigWidth;
                LcdpComponent lcdpComponent;
                String componentName = entry.getKey();
                DefaultStyle defaultStyle = entry.getValue();
                String className = StyleFactory.get((String)componentName);
                String clazz = ClazzFactory.get((String)componentName);
                Map interactionsVars = defaultStyle.getInteractionsVars();
                Map styles = defaultStyle.getStyles();
                Map innerStyles = defaultStyle.getInnerStyles();
                Map interactions = defaultStyle.getInteractions();
                this.genPropsStyle(defaultStyleSet, componentName, defaultStyle.getProps(), interactionsVars, themeVars, defaultStyle, null, "normal");
                this.genPropsStyle(defaultStyleSet, componentName, defaultStyle.getProps(), interactionsVars, themeVars, defaultStyle, "default", "normal");
                if (ToolUtil.isNotEmpty((Object)defaultStyle.getProps()) && ToolUtil.isNotEmpty(defaultStyle.getProps().get("themeBase"))) {
                    this.genDefaultThemeBase(defaultStyle, defaultStyle, themeVars, "normal", themeBaseConfig);
                }
                this.dealStyleExchange(componentName, styles, innerStyles, defaultStyle);
                if (null == clazz) continue;
                try {
                    lcdpComponent = (LcdpComponent)SpringUtil.getBean(Class.forName(clazz));
                }
                catch (ClassNotFoundException e) {
                    lcdpComponent = (LcdpComponent)SpringUtil.getPluginUtil().getBean(Element.class, clazz);
                }
                if (!HussarUtils.isNotEmpty((Object)lcdpComponent)) continue;
                String componentDefaultStyle = "".equals(lcdpComponent.getCommonStyleClassPrefix()) ? lcdpComponent.getCommonStyleClassPrefix() + " " + className + "{${body}}" : ".jxd_additional" + lcdpComponent.getCommonStyleClassPrefix() + " " + className + "{${body}}";
                Map outerStyleTemplate = lcdpComponent.outerStyleTemplate();
                ArrayList<String> lines = new ArrayList<String>();
                Map defaultStyles = defaultStyle.getStyles();
                boolean isConfigHeight = defaultStyle.getHeight() != null;
                boolean bl = isConfigWidth = defaultStyle.getWidth() != null;
                if (defaultStyles == null) {
                    if (isConfigHeight) {
                        lines.add("height: " + this.addPx(defaultStyle.getHeight()) + ";");
                    }
                    if (isConfigWidth) {
                        lines.add("width: " + this.addPx(defaultStyle.getWidth()) + ";");
                    }
                } else {
                    boolean hasConfigHeight;
                    boolean hasConfigWidth = defaultStyles.get("width") != null;
                    boolean bl2 = hasConfigHeight = defaultStyles.get("height") != null;
                    if (isConfigHeight && !hasConfigHeight) {
                        lines.add("height: " + this.addPx(defaultStyle.getHeight()) + ";");
                    }
                    if (isConfigWidth && !hasConfigWidth) {
                        lines.add("width: " + this.addPx(defaultStyle.getWidth()) + ";");
                    }
                }
                if (null != defaultStyles) {
                    for (Map.Entry style : defaultStyle.getStyles().entrySet()) {
                        String resolvedValue;
                        boolean hasValue;
                        String prop = (String)style.getKey();
                        Object value = style.getValue();
                        String propTemplate = null;
                        if (outerStyleTemplate != null) {
                            propTemplate = StyleGenerateUtil.removeDeepSelectors((String)((String)outerStyleTemplate.get(prop)));
                        }
                        boolean hasStyleTemplate = null != propTemplate;
                        boolean bl3 = hasValue = value != null && !"".equals(value);
                        if (hasStyleTemplate && hasValue) {
                            resolvedValue = this.resolveStyle(prop, value, defaultStyle, interactionsVars, "", themeVars, false, componentName);
                            if (resolvedValue == null) continue;
                            String prefix = "".equals(lcdpComponent.getCommonStyleClassPrefix()) ? lcdpComponent.getCommonStyleClassPrefix() + " " + className : ".jxd_additional" + lcdpComponent.getCommonStyleClassPrefix() + " " + className;
                            String propStyle = StyleGenerateUtil.backgroundReplace((String)propTemplate).replace("${prefix}", prefix).replace(".${prefix2}", "").replace("${val}", resolvedValue);
                            defaultStyleSet.add(propStyle);
                            continue;
                        }
                        resolvedValue = this.resolveStyle(prop, value, defaultStyle, interactionsVars, "", themeVars, false, componentName);
                        lines.add(StyleGenerateUtil.backgroundReplace((String)(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, prop) + ":")) + resolvedValue + ";");
                    }
                }
                if (!lines.isEmpty()) {
                    String componentDefaultStyleJson = componentDefaultStyle.replace("${body}", String.join((CharSequence)"", lines));
                    defaultStyleSet.add(componentDefaultStyleJson);
                }
                if (null != (innerStyleDefault = defaultStyle.getInnerStyles())) {
                    Map styleTemplate = lcdpComponent.styleTemplate();
                    if (styleTemplate != null) {
                        for (Map.Entry style : innerStyleDefault.entrySet()) {
                            boolean hasValue;
                            String prop = (String)style.getKey();
                            Object value = style.getValue();
                            String propTemplate = StyleGenerateUtil.removeDeepSelectors((String)((String)styleTemplate.get(prop)));
                            if (ToolUtil.isNotEmpty((Object)propTemplate) && propTemplate.equals("dynamicStyleTemplate")) {
                                Class<?> componentClass;
                                block28: {
                                    componentClass = null;
                                    try {
                                        componentClass = Class.forName(ClazzFactory.get((String)componentName));
                                    }
                                    catch (ClassNotFoundException e) {
                                        LcdpComponent component = (LcdpComponent)SpringUtil.getPluginUtil().getBean(componentName, "", "");
                                        if (!HussarUtils.isNotEmpty((Object)component)) break block28;
                                        componentClass = component.getClass();
                                    }
                                }
                                if (HussarUtils.isNotEmpty(componentClass)) {
                                    try {
                                        Function invoke = (Function)componentClass.getMethod("dynamicStyleTemplate", String.class).invoke((Object)"dynamicStyleTemplate", prop);
                                        if (ToolUtil.isNotEmpty(value)) {
                                            propTemplate = (String)invoke.apply(value);
                                        }
                                    }
                                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                                        this.logger.error("\u6e32\u67d3\u6837\u5f0f\u5f02\u5e38", (Throwable)e);
                                    }
                                }
                            }
                            boolean hasStyleTemplate = null != propTemplate;
                            boolean bl4 = hasValue = value != null && !"".equals(value);
                            if (hasStyleTemplate && hasValue) {
                                String resolvedValue = this.resolveStyle(prop, value, defaultStyle, interactionsVars, "", themeVars, false, componentName);
                                String prefix = "".equals(lcdpComponent.getCommonStyleClassPrefix()) ? lcdpComponent.getCommonStyleClassPrefix() + " " + className : ".jxd_additional" + lcdpComponent.getCommonStyleClassPrefix() + " " + className;
                                if (resolvedValue == null) continue;
                                String propStyle = StyleGenerateUtil.backgroundReplace((String)propTemplate).replace("${prefix}", prefix).replace(".${prefix2}", "").replace("${val}", resolvedValue);
                                defaultStyleSet.add(propStyle);
                                continue;
                            }
                            if (!hasStyleTemplate && this.speedCodeProperties.isDeveloperMode()) {
                                this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684'" + prop + "'\u6837\u5f0f\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6837\u5f0f\u6a21\u677f");
                            }
                            if (hasValue || !this.speedCodeProperties.isDeveloperMode()) continue;
                            this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684'" + prop + "'\u6837\u5f0f\u65f6\u627e\u4e0d\u5230'\u503c'");
                        }
                        continue;
                    }
                    if (!this.speedCodeProperties.isDeveloperMode()) continue;
                    this.logger.debug("\u6e32\u67d3'" + componentName + "'\u7684innerStyle\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94\u7684styleTemplate");
                    continue;
                }
                if (!this.speedCodeProperties.isDeveloperMode()) continue;
                this.logger.debug("\u627e\u4e0d\u5230\uff1a" + componentName + "\u5bf9\u5e94\u7684\u7c7b");
            }
            TreeSet<String> sortCommonStyleList = new TreeSet<String>(Comparator.reverseOrder());
            sortCommonStyleList.addAll(defaultStyleSet);
            return sortCommonStyleList;
        }
        return new HashSet<String>();
    }

    public void genDefaultThemeBase(DefaultStyle interaction, DefaultStyle defaultStyle, Map<String, String> themeVars, String scene, ThemeBaseConfig themeBaseConfig) throws LcdpException {
        if (this.existThemeBase(defaultStyle.getProps(), defaultStyle)) {
            Map interactionThemeBase = Optional.ofNullable(interaction.getProps().get("themeBase")).flatMap(DynDataUtil::asObject).orElseGet(HashMap::new);
            Map defaultThemeBase = Optional.ofNullable(defaultStyle.getProps().get("themeBase")).flatMap(DynDataUtil::asObject).orElseGet(HashMap::new);
            for (Map.Entry scssEntry : interactionThemeBase.entrySet()) {
                Object themeBaseKey = scssEntry.getKey();
                Object themeBaseValue = scssEntry.getValue();
                Optional relatedThemeBaseValue = DynDataUtil.subscript(themeBaseValue, (String)"related").flatMap(DynDataUtil::asString);
                if (!relatedThemeBaseValue.isPresent()) {
                    relatedThemeBaseValue = DynDataUtil.subscript(themeBaseValue, (String)"value").flatMap(DynDataUtil::asString);
                }
                String keys = themeBaseKey.toString();
                if (!relatedThemeBaseValue.isPresent()) continue;
                String valuess = (String)relatedThemeBaseValue.get();
                Object matchDefault = defaultThemeBase.get(keys);
                if (!DynDataUtil.isObjectType(matchDefault)) {
                    throw new LcdpException(LcdpExceptionEnum.ERROR, "\u7ec4\u4ef6\u9ed8\u8ba4\u503c\u57fa\u7840\u6837\u5f0f\u914d\u7f6e\u9519\u8bef");
                }
                Map defaultConfig = (Map)JSON.parseObject((String)JSON.toJSONString(matchDefault), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                defaultConfig.put("value", valuess);
                String findKey = Optional.ofNullable(defaultConfig.get("value")).flatMap(DynDataUtil::asString).orElseGet(String::new);
                String findType = Optional.ofNullable(defaultConfig.get("type")).flatMap(DynDataUtil::asString).orElseGet(String::new);
                HashMap stylesForRender = new HashMap();
                if (ObjectUtil.equal((Object)"custom", (Object)findKey)) {
                    this.renderDefaultGroups(defaultConfig, defaultStyle);
                    this.renderDefaultMultiSpacing(defaultConfig, defaultStyle, keys);
                    continue;
                }
                Optional baseCssOpt = themeBaseConfig.find(findType, findKey);
                if (!baseCssOpt.isPresent()) {
                    return;
                }
                for (Map.Entry baseEntry : ((Map)baseCssOpt.get()).entrySet()) {
                    String key = (String)baseEntry.getKey();
                    Object value = baseEntry.getValue();
                    if ("color".equals(key)) {
                        if (!DynDataUtil.isObjectType(value)) {
                            stylesForRender.put(key, value);
                            continue;
                        }
                        Map values = (Map)value;
                        if (((Boolean)values.get("useRelated")).booleanValue()) {
                            stylesForRender.put(key, value);
                            continue;
                        }
                        Object colorValue = values.get("color");
                        stylesForRender.put(key, colorValue);
                        continue;
                    }
                    if ("boxShadow".equals(key)) {
                        stylesForRender.put(key, this.renderBoxShadow(key, value, themeVars, defaultStyle, scene));
                        continue;
                    }
                    if ("config".equals(key)) continue;
                    stylesForRender.put(key, value);
                }
                Object groupsObj = defaultConfig.get("groups");
                if (!DynDataUtil.isObjectType(groupsObj)) continue;
                Map defaultGroups = (Map)JSON.parseObject((String)JSON.toJSONString(groupsObj), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                HashMap<String, Object> styleForRender = new HashMap<String, Object>();
                HashMap<String, Object> innerStyleForRender = new HashMap<String, Object>();
                for (Map.Entry groupsEntry : defaultGroups.entrySet()) {
                    Object matched;
                    String cssKey;
                    String matchKey = (String)groupsEntry.getKey();
                    Object groupsCssConfig = groupsEntry.getValue();
                    if (!DynDataUtil.isObjectType(groupsCssConfig)) continue;
                    Map cssConfig = (Map)JSON.parseObject((String)JSON.toJSONString(groupsCssConfig), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                    Object siteObj = cssConfig.get("site");
                    Object mapObj = cssConfig.get("map");
                    Object valueObj = cssConfig.get("value");
                    String type = String.valueOf(defaultConfig.get("type"));
                    String sites = ObjectUtil.isEmpty(siteObj) ? String.valueOf(defaultConfig.get("site")) : String.valueOf(siteObj);
                    String string = cssKey = ObjectUtil.isEmpty(mapObj) ? matchKey : String.valueOf(cssConfig.get("map"));
                    if (ObjectUtil.equal((Object)"styles", (Object)sites)) {
                        matched = stylesForRender.get(cssKey);
                        if ("shadow".equals(type)) {
                            styleForRender.put(matchKey, this.renderBoxShadow(matchKey, matched, themeVars, defaultStyle, scene));
                            continue;
                        }
                        styleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                        continue;
                    }
                    if (!ObjectUtil.equal((Object)"innerStyles", (Object)sites)) continue;
                    matched = stylesForRender.get(cssKey);
                    if ("shadow".equals(type)) {
                        innerStyleForRender.put(matchKey, this.renderBoxShadow(matchKey, matched, themeVars, defaultStyle, scene));
                        continue;
                    }
                    innerStyleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                }
                if (defaultStyle.getStyles() != null) {
                    defaultStyle.getStyles().putAll(styleForRender);
                }
                if (defaultStyle.getInnerStyles() == null) continue;
                defaultStyle.getInnerStyles().putAll(innerStyleForRender);
            }
        }
    }

    private void renderDefaultGroups(Map<String, Object> defaultConfig, DefaultStyle currentComponentStyle) throws LcdpException {
        Object groupsObj = defaultConfig.get("groups");
        if (DynDataUtil.isObjectType((Object)groupsObj)) {
            Map defaultGroups = (Map)JSON.parseObject((String)JSON.toJSONString((Object)groupsObj), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
            HashMap<String, Object> styleForRender = new HashMap<String, Object>();
            HashMap<String, Object> innerStyleForRender = new HashMap<String, Object>();
            for (Map.Entry groupsEntry : defaultGroups.entrySet()) {
                String matchKey = (String)groupsEntry.getKey();
                Object groupsCssConfig = groupsEntry.getValue();
                if (!DynDataUtil.isObjectType(groupsCssConfig)) continue;
                Map cssConfig = (Map)JSON.parseObject((String)JSON.toJSONString(groupsCssConfig), (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
                Object siteObj = cssConfig.get("site");
                Object valueObj = cssConfig.get("value");
                String site = ObjectUtil.isEmpty(siteObj) ? String.valueOf(defaultConfig.get("site")) : String.valueOf(siteObj);
                Object matched = null;
                if (ObjectUtil.equal((Object)"styles", (Object)site)) {
                    if (currentComponentStyle.getStyles() != null) {
                        matched = currentComponentStyle.getStyles().get(matchKey);
                    }
                    styleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                    if (!ObjectUtil.isNotEmpty(matched)) continue;
                    currentComponentStyle.getStyles().remove(matchKey);
                    continue;
                }
                if (!ObjectUtil.equal((Object)"innerStyles", (Object)site)) continue;
                if (currentComponentStyle.getInnerStyles() != null) {
                    matched = currentComponentStyle.getInnerStyles().get(matchKey);
                }
                innerStyleForRender.put(matchKey, this.normalizeStyleValue(ObjectUtil.isEmpty(matched) ? valueObj : matched));
                if (!ObjectUtil.isNotEmpty(matched) || currentComponentStyle.getInnerStyles() == null) continue;
                currentComponentStyle.getInnerStyles().remove(matchKey);
            }
            if (currentComponentStyle.getStyles() != null) {
                currentComponentStyle.getStyles().putAll(styleForRender);
            }
            if (currentComponentStyle.getInnerStyles() != null) {
                currentComponentStyle.getInnerStyles().putAll(innerStyleForRender);
            }
        }
    }

    private void renderDefaultMultiSpacing(Map<String, Object> defaultConfig, DefaultStyle defaultStyle, String key) throws LcdpException {
        Object defaultObj = defaultConfig.get("default");
        if (DynDataUtil.isArrayType((Object)defaultObj)) {
            HashMap<String, String> styleForRender = new HashMap<String, String>();
            HashMap<String, String> innerStyleForRender = new HashMap<String, String>();
            Object matched = null;
            if (ObjectUtil.equal((Object)"styles", (Object)String.valueOf(defaultConfig.get("site")))) {
                if (defaultStyle.getStyles() != null) {
                    matched = defaultStyle.getStyles().get(key);
                }
                styleForRender.put(key, this.renderPadding(ObjectUtil.isEmpty(matched) ? defaultObj : matched, defaultObj));
            } else if (ObjectUtil.equal((Object)"innerStyles", (Object)String.valueOf(defaultConfig.get("site")))) {
                if (defaultStyle.getInnerStyles() != null) {
                    matched = defaultStyle.getInnerStyles().get(key);
                }
                innerStyleForRender.put(key, this.renderPadding(ObjectUtil.isEmpty(matched) ? defaultObj : matched, defaultObj));
            }
            if (defaultStyle.getStyles() != null) {
                defaultStyle.getStyles().putAll(styleForRender);
            }
            if (defaultStyle.getInnerStyles() != null) {
                defaultStyle.getInnerStyles().putAll(innerStyleForRender);
            }
        }
    }

    private String addPx(Integer integer) {
        return integer == 0 ? "0" : integer + "px";
    }

    private void componentCommonStyle(String componentLibrary, Map<String, List<ComponentStyleSettings>> scssVars) throws LcdpException {
        Map defaultStyles = this.defaultStyleCacheService.list(componentLibrary);
        HashSet necessaryComponents = new HashSet();
        for (Map.Entry entry : defaultStyles.entrySet()) {
            Optional.ofNullable(entry.getValue()).map(DefaultStyle::getInteractionsVars).filter(vars -> !vars.isEmpty()).ifPresent(interactionsVars -> necessaryComponents.add(entry.getKey()));
        }
        for (String componentName : necessaryComponents) {
            Object componentStyleSettings;
            if (!scssVars.containsKey(componentName)) {
                componentStyleSettings = new ComponentStyleSettings();
                componentStyleSettings.setName("default");
                DefaultStyle styleVars = new DefaultStyle();
                styleVars.setStyles(new HashMap());
                styleVars.setInnerStyles(new HashMap());
                styleVars.setInteractions(new HashMap());
                styleVars.setProps(new HashMap());
                componentStyleSettings.setStyleVars(styleVars);
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(componentStyleSettings);
                scssVars.putIfAbsent(componentName, list);
            }
            componentStyleSettings = scssVars.get(componentName);
            Iterator iterator = componentStyleSettings.iterator();
            while (iterator.hasNext()) {
                ComponentStyleSettings componentStyleSetting = (ComponentStyleSettings)iterator.next();
                if (componentStyleSetting == null) continue;
                DefaultStyle styleVars = componentStyleSetting.getStyleVars();
                if (styleVars == null) {
                    styleVars = new DefaultStyle();
                    styleVars.setStyles(new HashMap());
                    styleVars.setInnerStyles(new HashMap());
                    styleVars.setInteractions(new HashMap());
                    styleVars.setProps(new HashMap());
                    componentStyleSetting.setStyleVars(styleVars);
                }
                this.complementComponentStyle(styleVars, (DefaultStyle)defaultStyles.get(componentName));
            }
        }
    }

    private void complementComponentStyle(DefaultStyle componentStyle, DefaultStyle defaultStyle) throws LcdpException {
        if (defaultStyle != null) {
            this.complementSingleSceneStyle(componentStyle, defaultStyle, false);
            Map interactions = defaultStyle.getInteractions();
            if (interactions != null) {
                HashMap<String, DefaultStyle> componentInteractions = componentStyle.getInteractions();
                if (componentInteractions == null) {
                    componentInteractions = new HashMap<String, DefaultStyle>();
                    componentStyle.setInteractions(componentInteractions);
                }
                for (Map.Entry entry : interactions.entrySet()) {
                    String scene = (String)entry.getKey();
                    if (((DefaultStyle)entry.getValue()).getIsOpen() == null) {
                        ((DefaultStyle)entry.getValue()).setIsOpen(Boolean.valueOf(false));
                    }
                    if (componentInteractions.get(scene) == null) {
                        DefaultStyle sceneStyle = new DefaultStyle();
                        sceneStyle.setStyles(new HashMap());
                        sceneStyle.setInnerStyles(new HashMap());
                        sceneStyle.setProps(new HashMap());
                        componentInteractions.put(scene, sceneStyle);
                    }
                    if (((DefaultStyle)componentInteractions.get(scene)).getIsOpen() == null) {
                        ((DefaultStyle)componentInteractions.get(scene)).setIsOpen(((DefaultStyle)entry.getValue()).getIsOpen());
                    }
                    if (scene.contains("_") && ToolUtil.isNotEmpty(componentStyle.getInteractions().get(scene.substring(0, scene.indexOf("_")))) && ((DefaultStyle)componentStyle.getInteractions().get(scene.substring(0, scene.indexOf("_")))).getIsOpen() != null && Boolean.TRUE.equals(((DefaultStyle)componentStyle.getInteractions().get(scene.substring(0, scene.indexOf("_")))).getIsOpen())) continue;
                    this.complementSingleSceneStyle((DefaultStyle)componentInteractions.get(scene), (DefaultStyle)entry.getValue(), true);
                }
            }
        }
    }

    private void complementSingleSceneStyle(DefaultStyle componentStyle, DefaultStyle defaultStyle, boolean isInteract) throws LcdpException {
        Map innerStyles;
        Map defaultStyleProps;
        Map styles;
        if (componentStyle == null) {
            throw new NullPointerException();
        }
        if (defaultStyle == null) {
            throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, "\u7ec4\u4ef6\u9ed8\u8ba4\u6837\u5f0f\u53ca\u6837\u5f0f\u8ba1\u7b97\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        if (isInteract && (styles = defaultStyle.getStyles()) != null) {
            for (Map.Entry entry : styles.entrySet()) {
                HashMap<String, Object> componentStyles = componentStyle.getStyles();
                if (componentStyles == null) {
                    componentStyles = new HashMap<String, Object>();
                    componentStyle.setStyles(componentStyles);
                }
                componentStyles.computeIfAbsent((String)entry.getKey(), k -> entry.getValue());
            }
        }
        if ((defaultStyleProps = defaultStyle.getProps()) != null) {
            for (Map.Entry entry : defaultStyleProps.entrySet()) {
                Optional defaultThemeBase;
                if (DynDataUtil.isBooleanType(entry.getValue())) {
                    HashMap<String, Object> props = componentStyle.getProps();
                    if (props == null) {
                        props = new HashMap<String, Object>();
                        componentStyle.setProps(props);
                    }
                    props.computeIfAbsent((String)entry.getKey(), k -> entry.getValue());
                }
                if (!DynDataUtil.isObjectType(entry.getValue()) && "themeBase".equals(entry.getKey()) || !(defaultThemeBase = Optional.ofNullable(entry.getValue()).flatMap(DynDataUtil::asObject)).isPresent()) continue;
                defaultThemeBase.ifPresent(themeBaseOpt -> {
                    HashMap<String, Object> props = componentStyle.getProps();
                    HashMap componentThemeBaseMap = new HashMap();
                    if (props == null) {
                        props = new HashMap<String, Object>();
                        props.computeIfAbsent("themeBase", k -> componentThemeBaseMap);
                        componentStyle.setProps(props);
                    }
                    Optional componentThemeBaseOpt = Optional.ofNullable(props.get("themeBase")).flatMap(DynDataUtil::asObject);
                    componentThemeBaseOpt.ifPresent(componentThemeBase -> {
                        for (Map.Entry themeBaseEntry : componentThemeBase.entrySet()) {
                            if (!DynDataUtil.isStringType(themeBaseEntry.getKey()) && !DynDataUtil.isStringType(themeBaseEntry.getValue())) continue;
                            componentThemeBaseMap.computeIfAbsent(themeBaseEntry.getKey().toString(), k -> themeBaseEntry.getValue().toString());
                        }
                    });
                    for (Map.Entry themeBaseEntry : themeBaseOpt.entrySet()) {
                        Optional value = Optional.ofNullable(themeBaseEntry.getValue()).flatMap(nxt -> DynDataUtil.subscript((Object)nxt, (String)"value")).flatMap(DynDataUtil::asString);
                        if (!value.isPresent()) {
                            value = Optional.ofNullable(themeBaseEntry.getValue()).flatMap(nxt -> DynDataUtil.subscript((Object)nxt, (String)"related")).flatMap(DynDataUtil::asString);
                        }
                        value.ifPresent(s -> componentThemeBaseMap.computeIfAbsent(themeBaseEntry.getKey().toString(), k -> s));
                    }
                    props.compute("themeBase", (k, v) -> componentThemeBaseMap);
                });
            }
        }
        if (isInteract && (innerStyles = defaultStyle.getInnerStyles()) != null) {
            for (Map.Entry entry : innerStyles.entrySet()) {
                HashMap<String, Object> componentInnerStyles = componentStyle.getInnerStyles();
                if (componentInnerStyles == null) {
                    componentInnerStyles = new HashMap<String, Object>();
                    componentStyle.setInnerStyles(componentInnerStyles);
                }
                componentInnerStyles.computeIfAbsent((String)entry.getKey(), k -> entry.getValue());
            }
        }
    }

    private String resolveStyle(String prop, Object value, DefaultStyle defaultStyle, Map<String, Object> interactionsVars, String scene, Map<String, String> themeVars, boolean noFollow, String componentName) throws LcdpException {
        try {
            if (DynDataUtil.isBasicType((Object)value)) {
                return String.valueOf(value);
            }
            if (DynDataUtil.isArrayType((Object)value)) {
                return this.renderBoxShadow(prop, value, themeVars, defaultStyle, scene);
            }
            if (!DynDataUtil.isObjectType((Object)value)) {
                throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u5f15\u7528\u5bf9\u8c61\u4e0d\u6b63\u786e");
            }
            boolean formatVersion = DynDataUtil.subscript((Object)value, (String)"useRelated").isPresent();
            if (!formatVersion) {
                Optional related = DynDataUtil.subscript((Object)value, (String)"related").flatMap(DynDataUtil::asString);
                Optional template = DynDataUtil.subscript((Object)value, (String)"template").flatMap(DynDataUtil::asString);
                if (!related.isPresent()) {
                    throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u5f15\u7528\u5bf9\u8c61\u7f3a\u5931 related");
                }
                String reference = ToolUtil.isNotEmpty((Object)scene) && !"normal".equals(scene) ? scene + ToolUtil.firstLetterToUpper((String)StringUtils.removeStart((String)((String)related.get()), (String)"default")) : (String)related.get();
                String resolvedValue = this.resolveStyleByReference(reference, defaultStyle, interactionsVars, themeVars, noFollow, componentName, (String)related.get());
                return Optional.ofNullable(resolvedValue).map(val -> template.map(tmpl -> tmpl.replace("$val", (CharSequence)val)).orElse((String)val)).orElse(null);
            }
            Optional useRelated = DynDataUtil.subscript((Object)value, (String)"useRelated").flatMap(DynDataUtil::asBoolean);
            Optional color = DynDataUtil.subscript((Object)value, (String)"color").flatMap(DynDataUtil::asString);
            Optional relatedColor = DynDataUtil.subscript((Object)value, (Object[])new Object[]{"related", "color"}).flatMap(DynDataUtil::asString);
            if (useRelated.orElse(false).booleanValue()) {
                if (!relatedColor.isPresent()) {
                    throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u5f15\u7528\u5bf9\u8c61\u7f3a\u5931 related.color");
                }
                return this.resolveGradientColorValue(prop, (String)relatedColor.get(), themeVars, defaultStyle, scene, interactionsVars);
            }
            return color.orElse("");
        }
        catch (LcdpException e) {
            this.logger.error(e.getDetail(), (Throwable)e);
            return null;
        }
    }

    private String resolveGradientColorValue(String prop, String variable, Map<String, String> themeVars, DefaultStyle defaultStyle, String scene, Map<String, Object> interactionsVars) {
        if (themeVars.get("$" + variable.trim()) != null) {
            return "var(--c-" + variable + ")";
        }
        Object styleValue = "normal".equals(scene) ? this.lookupSceneStyleByName(prop, defaultStyle) : Optional.ofNullable(defaultStyle).map(DefaultStyle::getInteractions).map(interactions -> (DefaultStyle)interactions.get(scene)).map(sceneStyle -> this.lookupSceneStyleByName(prop, (DefaultStyle)sceneStyle)).orElse(null);
        Optional nextReference = DynDataUtil.subscript((Object)styleValue, (String)"related").flatMap(DynDataUtil::asString);
        if (nextReference.isPresent()) {
            Optional related;
            String reference = ToolUtil.isNotEmpty((Object)scene) && !"normal".equals(scene) ? scene + ToolUtil.firstLetterToUpper((String)StringUtils.removeStart((String)((String)nextReference.get()), (String)"default")) : (String)nextReference.get();
            Optional next = Optional.ofNullable(interactionsVars).map(vars -> vars.get(reference)).flatMap(DynDataUtil::asObject);
            if (next.isPresent() && (related = next.flatMap(nxt -> DynDataUtil.subscript((Object)nxt, (String)"related")).flatMap(DynDataUtil::asString)).isPresent()) {
                Optional lastRelated;
                if (((String)related.get()).contains("$")) {
                    return "var(--c-" + ((String)related.get()).substring(1) + ")";
                }
                Optional lastReference = Optional.of(interactionsVars).map(vars -> vars.get(related.get())).flatMap(DynDataUtil::asObject);
                if (lastReference.isPresent() && (lastRelated = lastReference.flatMap(nxt -> DynDataUtil.subscript((Object)nxt, (String)"related")).flatMap(DynDataUtil::asString)).isPresent()) {
                    return "var(--c-" + ((String)lastRelated.get()).substring(1) + ")";
                }
            }
        }
        return null;
    }

    private String resolveStyleByReference(String reference, DefaultStyle defaultStyle, Map<String, Object> interactionsVars, Map<String, String> themeVars, boolean noFollow, String componentName, String relatedGet) throws LcdpException {
        String value;
        Optional<String> themeVarNext = Optional.ofNullable(themeVars.get(relatedGet));
        if (themeVarNext.isPresent()) {
            return themeVarNext.get();
        }
        Optional next = Optional.ofNullable(interactionsVars).map(vars -> vars.get(reference)).flatMap(DynDataUtil::asObject);
        if (!next.isPresent()) {
            throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u6837\u5f0f\u8ba1\u7b97\u89c4\u5219\u7f3a\u5931 " + reference);
        }
        Optional related = next.flatMap(nxt -> DynDataUtil.subscript((Object)nxt, (String)"related")).flatMap(DynDataUtil::asString);
        Optional rule = next.flatMap(nxt -> DynDataUtil.subscript((Object)nxt, (String)"rule")).flatMap(DynDataUtil::asObject);
        if (!related.isPresent() || !rule.isPresent()) {
            throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u6837\u5f0f\u8ba1\u7b97\u89c4\u5219\u4e0d\u6b63\u786e " + reference);
        }
        if (interactionsVars.get(related.get()) == null) {
            if (noFollow) {
                return null;
            }
            value = (String)related.get();
        } else {
            Object styleValue = this.lookupStyleByReference((String)related.get(), defaultStyle, componentName);
            if (styleValue == null) {
                value = this.resolveStyleByReference(DynDataUtil.asString(related.get()).orElse(""), defaultStyle, interactionsVars, themeVars, noFollow, componentName, (String)related.get());
            } else if (DynDataUtil.isBasicType((Object)styleValue)) {
                value = DynDataUtil.asString((Object)styleValue).orElse(null);
            } else if (DynDataUtil.isObjectType((Object)styleValue)) {
                String nextReference = (String)DynDataUtil.subscript((Object)styleValue, (String)"related").flatMap(DynDataUtil::asString).orElseThrow(() -> new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u6837\u5f0f\u5f15\u7528\u4e0d\u6b63\u786e " + styleValue));
                value = this.resolveStyleByReference(nextReference, defaultStyle, interactionsVars, themeVars, noFollow, componentName, (String)related.get());
            } else {
                throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u6837\u5f0f\u5bf9\u8c61\u7c7b\u578b\u4e0d\u6b63\u786e " + styleValue);
            }
        }
        value = this.resolveVariableValue(value, themeVars);
        return value;
    }

    private Object lookupStyleByReference(String reference, DefaultStyle defaultStyle, String componentName) throws LcdpException {
        String[] sceneAndName = reference.split("(?=[A-Z])", 2);
        if (sceneAndName.length != 2) {
            throw new LcdpException(LcdpExceptionEnum.RENDER_FAIL, componentName + "\u7684related\u5f15\u7528\u5f62\u5f0f\u4e0d\u6b63\u786e " + reference);
        }
        String scene = sceneAndName[0];
        String name = ToolUtil.firstToLower((String)sceneAndName[1]);
        if ("default".equals(scene)) {
            return this.lookupSceneStyleByName(name, defaultStyle);
        }
        return Optional.ofNullable(defaultStyle).map(DefaultStyle::getInteractions).map(interactions -> (DefaultStyle)interactions.get(scene)).map(sceneStyle -> this.lookupSceneStyleByName(name, (DefaultStyle)sceneStyle)).orElse(null);
    }

    private Object lookupSceneStyleByName(String name, DefaultStyle sceneStyle) {
        return Optional.ofNullable(sceneStyle).map(DefaultStyle::getStyles).map(styles -> styles.get(name)).orElseGet(() -> Optional.ofNullable(sceneStyle).map(DefaultStyle::getInnerStyles).map(innerStyles -> innerStyles.get(name)).orElse(null));
    }

    private String resolveVariableValue(String value, Map<String, String> themeVars) {
        if (ToolUtil.isEmpty((Object)value)) {
            return value;
        }
        if (value.trim().startsWith("$")) {
            String var = value.trim();
            if (themeVars == null) {
                this.logger.error("\u672a\u4fdd\u5b58\u4e3b\u9898\u8272\u53d8\u91cf\u5217\u8868\uff0c\u65e0\u6cd5\u89e3\u6790\u53d8\u91cf " + var);
                return value;
            }
            String val = themeVars.get(var);
            if (val != null) {
                return "var(--c-" + var.substring(1) + ")";
            }
            this.logger.error("\u627e\u4e0d\u5230\u4e3b\u9898\u8272\u53d8\u91cf " + var);
            return "var(--c-" + value.substring(1) + ")";
        }
        return value;
    }

    private String calculateValueByRule(String value, Map<Object, Object> rule) {
        if (ToolUtil.isEmpty((Object)value)) {
            return value;
        }
        try {
            double h = this.parseHslOffset(rule, "H");
            double s = this.parseHslOffset(rule, "S");
            double l = this.parseHslOffset(rule, "L");
            return ColorUtil.adjustHsl((String)value, (double)h, (double)s, (double)l);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("\u6e32\u67d3\u6837\u5f0f\u5f02\u5e38", (Throwable)e);
            return value;
        }
    }

    private double parseHslOffset(Map<Object, Object> rule, String property) {
        return DynDataUtil.subscript(rule, (String)property).flatMap(DynDataUtil::asDouble).orElse(0.0);
    }

    static class ClassPreview {
        private String clazz;
        private String sceneStyleClassName;
        private String interactiveStyleAdditionClass;

        public ClassPreview(String clazz, String sceneStyleClassName, String interactiveStyleAdditionClass) {
            this.clazz = clazz;
            this.sceneStyleClassName = sceneStyleClassName;
            this.interactiveStyleAdditionClass = interactiveStyleAdditionClass;
        }

        public String getClazz() {
            return this.clazz;
        }

        public void setClazz(String clazz) {
            this.clazz = clazz;
        }

        public String getSceneStyleClassName() {
            return this.sceneStyleClassName;
        }

        public void setSceneStyleClassName(String sceneStyleClassName) {
            this.sceneStyleClassName = sceneStyleClassName;
        }

        public String getInteractiveStyleAdditionClass() {
            return this.interactiveStyleAdditionClass;
        }

        public void setInteractiveStyleAdditionClass(String interactiveStyleAdditionClass) {
            this.interactiveStyleAdditionClass = interactiveStyleAdditionClass;
        }
    }

    static class StyleParams {
        private String componentName;
        private String scene;
        private String settingsName;
        private Map<String, Object> interactionsVars;
        private DefaultStyle currentComponentStyle;
        private DefaultStyle componentStyle;
        private DefaultStyle defaultStyle;
        private Map<String, String> themeVars;

        public StyleParams(String componentName, String scene, String settingsName, Map<String, Object> interactionsVars, DefaultStyle currentComponentStyle, DefaultStyle componentStyle, DefaultStyle defaultStyle, Map<String, String> themeVars) {
            this.componentName = componentName;
            this.scene = scene;
            this.settingsName = settingsName;
            this.interactionsVars = interactionsVars;
            this.currentComponentStyle = currentComponentStyle;
            this.componentStyle = componentStyle;
            this.defaultStyle = defaultStyle;
            this.themeVars = themeVars;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public String getScene() {
            return this.scene;
        }

        public void setScene(String scene) {
            this.scene = scene;
        }

        public String getSettingsName() {
            return this.settingsName;
        }

        public void setSettingsName(String settingsName) {
            this.settingsName = settingsName;
        }

        public Map<String, Object> getInteractionsVars() {
            return this.interactionsVars;
        }

        public void setInteractionsVars(Map<String, Object> interactionsVars) {
            this.interactionsVars = interactionsVars;
        }

        public DefaultStyle getCurrentComponentStyle() {
            return this.currentComponentStyle;
        }

        public void setCurrentComponentStyle(DefaultStyle currentComponentStyle) {
            this.currentComponentStyle = currentComponentStyle;
        }

        public DefaultStyle getComponentStyle() {
            return this.componentStyle;
        }

        public void setComponentStyle(DefaultStyle componentStyle) {
            this.componentStyle = componentStyle;
        }

        public DefaultStyle getDefaultStyle() {
            return this.defaultStyle;
        }

        public void setDefaultStyle(DefaultStyle defaultStyle) {
            this.defaultStyle = defaultStyle;
        }

        public Map<String, String> getThemeVars() {
            return this.themeVars;
        }

        public void setThemeVars(Map<String, String> themeVars) {
            this.themeVars = themeVars;
        }
    }
}

