<#macro rowCalculate colList>
    <#list colList as item>
        <#if item.children?? && (item.children?size>0) >
            <@rowCalculate colList=item.children></@rowCalculate>
        <#elseif  item.rowCalculateFormula?? && item.rowCalculateFormula !="">
            ${item.field!}Fn: (scope) => {
                const self = this;
                return ${item.rowCalculateFormula!}
            },
        </#if>
    </#list>
</#macro>
<#if importName != "" && dbdHaveMethod?? && dbdHaveMethod>
    <#--表格加载样式-->
    self.${instanceKey!}TableLoading = true;
    let ${importName!}Obj = {
        <#--无分页不带分页参数-->
        <#if isPagination?? && isPagination>
        ...self.${ListQuery!},
        </#if>
        ${queryAttr!}
    };
    <#if isPagination?? && isPagination>
        self.${instanceKey!}UpdateKey++
    </#if>
    <#if showFilter?? && showFilter>
       const queryConditions = self.${instanceKey!}GetQueryConditions(${importName!}Obj);
       if (queryConditions && queryConditions.length) {
         ${importName!}Obj.superQueryConditionDto = queryConditions;
       }
    </#if>
    const taskId = HussarRouter.query(self, 'taskId');
    ${importName!}Obj.taskId = taskId;
    let importMethod = '${importMethod!}';
    <#if isTotalCalculate?? && isTotalCalculate >
    self.${instanceKey!}TotalCalculate(${importName!}Obj);
    </#if>
    ${importName!}[importMethod](${importName!}Obj).then(async res => {
        const data = res.data;
        if ((res.code === 200 || res.code === 10000) && data) {
        let convert = [];
        (data.data).forEach((item) => {
        const flowRouteParamCopy = {};
        flowRouteParamCopy.businessId = item['${primaryKey!}'] ? item['${primaryKey!}'] : '';
        flowRouteParamCopy.taskId = item.taskId ? item.taskId : '';
        flowRouteParamCopy.definitionKey = item.processDefinitionKey ? item.processDefinitionKey : '';
        flowRouteParamCopy.taskDefinitionKey = item.taskDefinitionKey ? item.taskDefinitionKey : '';
        convert.push({
            flowRouteParam: flowRouteParamCopy,
            ...item,
            <@rowCalculate colList=tableShowFields!></@rowCalculate>
        })
        });
    <#--            <#if isPagination?? && isPagination>-->
        self.${instanceKey!}TableTotal = data.count || 0;
    <#--            </#if>-->
        self.${instanceKey!}ReturnData = data.data;
    <#--数据表格数据展示,数据替换完成之后才进行表格数据的展示-->
        <#if isShowConfig?? && isShowConfig>
            await self.${instanceKey!}ReplaceData(convert);
        <#else >
            ${dataName!} = convert;
            self.${instanceKey!}TableLoading = false;
        </#if>
        <#--表格加载完成事件-->
        <#if isLoadedEvent?? && isLoadedEvent>
            if (self.${instanceKey!}TableLoaded) {
                self.${instanceKey!}TableLoaded();
            }
        </#if>
        ${callbackCode!}
        } else {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsFailed', fallbackStr: '表格数据请求失败'}), 'error');
        self.${instanceKey!}TableLoading = false;
        }
        }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsAbnormal', fallbackStr: '表格数据请求异常'}), 'error');
        self.${instanceKey!}TableLoading = false;
        })
<#else>
    ${callbackCode!}
</#if>
