<#if rangeDisabled == 'beforeToday'>
<#-- 禁用今天以前的日期 -->
if (time.getTime() < (Date.now()-(24 * 60 * 60 * 1000))) {
    return true;
}
<#elseif rangeDisabled == 'afterToday'>
<#-- 禁用今天以后的日期 -->
if (time.getTime() > Date.now()) {
    return true;
}
<#elseif rangeDisabled == 'todayAndBefore'>
<#-- 禁用今天及今天以前的日期 -->
if (time.getTime() <= Date.now()) {
    return true;
}
<#elseif rangeDisabled == 'todayAndAfter'>
<#-- 禁用今天及今天以后的日期 -->
if (time.getTime() >= (Date.now()-(24 * 60 * 60 * 1000))) {
    return true;
}
<#elseif rangeDisabled == 'beforeCertainDay' && disabledStartDate?? && disabledStartDate != ''>
<#-- 禁用某刻之前的日期 -->
if (!(${disabledStartDate!})) {
    return false;
}
const startDay = new Date(${disabledStartDate!});
startDay.setHours(0, 0, 0, 0);
if (time.getTime() < startDay.getTime()) {
    return true;
}
<#elseif rangeDisabled == 'afterCertainDay' && disabledStartDate?? && disabledStartDate != ''>
<#-- 禁用某刻之后的日期 -->
if (!(${disabledStartDate!})) {
    return false;
}
const startDay = new Date(${disabledStartDate!});
if (time.getTime() > startDay.getTime()) {
    return true;
}
<#elseif rangeDisabled == 'specificDateRange' && disabledStartDate?? && disabledStartDate != '' && disabledEndDate?? && disabledEndDate != ''>
<#-- 禁用特定范围外的日期 -->
if (!(${disabledStartDate!}) || !${disabledEndDate!}) {
    return false;
}
const startDay = new Date(${disabledStartDate!});
startDay.setHours(0, 0, 0, 0);
const endDay = new Date(${disabledEndDate!});
if (time.getTime() < startDay.getTime() || time.getTime() > endDay.getTime()){
    return true;
}
<#elseif rangeDisabled == 'withinSpecificDateRange' && disabledStartDate?? && disabledStartDate != '' && disabledEndDate?? && disabledEndDate != ''>
<#-- 禁用特定范围内的日期 -->
if (!(${disabledStartDate!}) || !${disabledEndDate!}) {
    return false;
}
const startDay = new Date(${disabledStartDate!});
const endDay = new Date(${disabledEndDate!});
endDay.setHours(0, 0, 0, 0);
if (startDay.getTime() < time.getTime() && time.getTime() < endDay.getTime()) {
    return true;
}
if (self.${instanceKey!}StartTime === null || self.${instanceKey!}StartTime === undefined || !/[\S]+/.test(self.${instanceKey!}StartTime)) {
return false;
}
// 如果开始时间和结束时间都被选中
if (self.${instanceKey!}StartTime && self.${instanceKey!}EndTime) {
return false;
}
// 第一次选择左侧，禁用右侧的日期
if (self.${instanceKey!}StartTime <= startDay) {
return time > startDay;
}
// 第一次选择右侧，禁用左侧的日期
if (self.${instanceKey!}StartTime >= endDay) {
return time < endDay;
}
<#elseif rangeDisabled == 'specificDateRangeAndThisDate' && disabledStartDate?? && disabledStartDate != '' && disabledEndDate?? && disabledEndDate != ''>
<#-- 禁用特定范围外的日期（包含特定日期） -->
if (!(${disabledStartDate!}) || !${disabledEndDate!}) {
    return false;
}
const startDay = new Date(${disabledStartDate!});
startDay.setHours(0, 0, 0, 0);
const endDay = new Date(${disabledEndDate!});
if (time.getTime() < startDay.getTime() || time.getTime() >= endDay.getTime()){
    return true;
}
<#elseif rangeDisabled == 'withinSpecificDateRangeAndThisDate' && disabledStartDate?? && disabledStartDate != '' && disabledEndDate?? && disabledEndDate != ''>
<#-- 禁用特定范围内的日期（包含特定日期） -->
if (!(${disabledStartDate!}) || !${disabledEndDate!}) {
    return false;
}
const startDay = new Date(${disabledStartDate!});
const endDay = new Date(${disabledEndDate!});
endDay.setHours(0, 0, 0, 0);
if (startDay.getTime() <= time.getTime() && time.getTime() < endDay.getTime()) {
    return true;
}
if (self.${instanceKey!}StartTime === null || self.${instanceKey!}StartTime === undefined || !/[\S]+/.test(self.${instanceKey!}StartTime)) {
return false;
}
// 如果开始时间和结束时间都被选中
if (self.${instanceKey!}StartTime && self.${instanceKey!}EndTime) {
return false;
}
// 第一次选择左侧，禁用右侧的日期
if (self.${instanceKey!}StartTime < startDay) {
return time >= startDay;
}
// 第一次选择右侧，禁用左侧的日期
if (self.${instanceKey!}StartTime >= endDay) {
return time <= endDay;
}
</#if>
<#if beforeFirst?? && beforeFirst>
    if (this.${instanceKey!}StartTime === null || this.${instanceKey!}StartTime === undefined || !/[\S]+/.test(this.${instanceKey!}StartTime)) {
    return false;
    }
    // 如果开始时间和结束时间都被选中
    if (this.${instanceKey!}StartTime && this.${instanceKey!}EndTime) {
    return false;
    }
    return time.getTime() < this.${instanceKey!}StartTime;
</#if>
