<#--定义列递归宏-->
<#macro editTree list>
    <#list list! as item>
        <#if (item.isParent?? && item.isParent!)>
            <vxe-table-colgroup align="${item.bodyAlign!}"
                                header-align="${item.align!}"
                                title="${item.label!}"
                                <#if item.width??>width="${item.width!}"</#if>
            >
                <@editTree list = item.children></@editTree>
            </vxe-table-colgroup>
        <#else>
            <#if item.rowSummary?? && item.rowSummary>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width="${item.width!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.label?? && item.label?length gt 0>:min-width="${(item.label?length * tHeadFontSize + 38)}"</#if>
                        </#if>
                                  title="${item.label!}"
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                >
                    <#if item.rowCalculate??>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{$numeral(${item.rowCalculate.editFormulaReplace!}).format('${item.rowCalculate.format!}')}}</span>
                        </template>
                    </#if>
                </vxe-table-column>
            <#elseif item.isShowConfig?? && item.isShowConfig!>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width="${item.width!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.label?? && item.label?length gt 0>:min-width="${(item.label?length * tHeadFontSize + 38)}"</#if>
                        </#if>
                                  title="${item.label!}"
                        <#if item.width??>width="${item.width!}"</#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                >
                    <template v-slot="{ row }">
                        <span class="vxe-cell--label">{{row.${item.prop!}}}</span>
                    </template>
                </vxe-table-column>
            <#else>
                <vxe-table-column align="${item.bodyAlign!}"
                                  header-align="${item.align!}"
                                  field="${item.prop!}"
                                  title="${item.label!}"
                        <#if item.width??>
                            <#if item.isMinWidth?? && item.isMinWidth!>
                                :min-width="${item.width!}"
                            <#else>
                                width="${item.width!}"
                            </#if>
                        <#else>
                            <#if item.label?? && item.label?length gt 0>:min-width="${(item.label?length * tHeadFontSize + 38)}"</#if>
                        </#if>
                        <#if (item.sort?? && item.sort)>
                            sortable
                        </#if>
                        <#if (item.fixed?? && item.fixed.isFixed?? && item.fixed.isFixed)>
                            <#if (item.fixed.left?? && item.fixed.left)>
                                fixed="left"
                            <#else>
                                fixed="right"
                            </#if>
                        </#if>
                        <#--可编辑列-->
                        <#if item.colEditComponent! != '' && item.colEditComponent! !='empty'>
                    :edit-render="{
                                immediate: true,
                                <#--输入框-->
                                <#if item.colEditComponent! == 'input' || item.colEditComponent! == 'dialog'>
                                name: 'input',
                                attrs: {type: 'text'},
                                <#--数字框-->
                                <#elseif item.colEditComponent! == 'number'>
                                name: '$input',
                                props: {type: 'number'},
                                <#--日期-->
                                <#elseif item.colEditComponent! == 'date'>
                                name: '$input',
                                props:{valueFormat: 'yyyy-MM-dd HH:mm:ss', type:'<#if item.selectFormat??>${item.selectFormat.dateFmtSelect!}</#if>'},
                                <#--下拉框-->
                                <#elseif item.colEditComponent! == 'select'>
                                name: '$select',
                                props: {type: 'select'},
                                options: ${instanceKey!}${item.prop!?cap_first}Options,
                                <#else >
                                </#if>
                                events: {
                                <#--合计行触发事件-->
                                <#if columnSummary?? && columnSummary>
                                input: ${instanceKey!}UpdateFooterEvent,
                                </#if>
                                <#--数据展示替换-->
                                <#if item.showConfig?? && item.showConfig>
                                change: ${instanceKey!}ReplaceData,
                                </#if>
                                <#--列弹框展示-->
                                <#if item.colEditComponent! == 'dialog'>
                                focus: ${instanceKey!}${item.prop?cap_first}EditEvent,
                                </#if>
                                }
                              }"
                        </#if>>
                    <#if item.colComponent! == 'date'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $dayjs(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.dateFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                    <#elseif item.colComponent! == 'number'>
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.${item.prop!}) ? $numeral(row.${item.prop!}).format('<#if item.selectType??>${item.selectType.numberFmtSelect!}</#if>') : '--'}}</span>
                        </template>
                    <#else>
                    </#if>
                </vxe-table-column>
            </#if>
        </#if>
    </#list>
</#macro>
<div v-show="!${instanceKey!}Hidden">
    <h-edit-Operation-table
            instance-key="${instanceKey!}"
            :key="${instanceKey!}Refresh"
            ref="${instanceKey!}TableRef"
            theme-name="${styleSchemeClassName!}"
            :props="${instanceKey!}PropsData"
            :inner-styles="${instanceKey!}InnerStyles"
            <#--列表loading-->
            :table-loading="${instanceKey!}TableLoading"
            <#--列表合计-->
            <#if columnSummary?? && columnSummary>
                :summary-method="${instanceKey!}ColumnSummaryEvent"
                show-summary
            </#if>
            :data="${instanceKey!}Data"
            <#--循环生成超链接事件-->
            <#list needOperations as item>
                <#if item.isEvent?? && item.isEvent>
                    @${item.eventName}="${instanceKey!}${item.eventName?cap_first}"
                </#if>
            </#list>
            :table-show-fields="${instanceKey!}OptCols">
        <#--列表列-->
        <@editTree list=tableShowFields!></@editTree>
    </h-edit-Operation-table>
    <#if hasSortTableOverall??>
        ${hasSortTableOverall!}
    </#if>
</div>
