/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Trigger;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NumberRangeVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/NumberRange/number-range.ftl");
        this.renderAttr(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethods(lcdpComponent, ctx);
    }

    private void renderAttr(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx);
        this.dealDisabledAttr(lcdpComponent, ctx);
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormMounted(lcdpComponent, ctx);
        ctx.addMounted(RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/numberRange_mounted.ftl", params));
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        String minRealBindData = this.renderDataItem(lcdpComponent, ctx, Collections.singletonList("minNumber"));
        String maxRealBindData = this.renderDataItem(lcdpComponent, ctx, Collections.singletonList("maxNumber"));
        lcdpComponent.addRenderParam("minRealBindData", (Object)minRealBindData);
        lcdpComponent.addRenderParam("maxRealBindData", (Object)maxRealBindData);
        lcdpComponent.addRenderParam("Max", (Object)("$event, " + maxRealBindData));
        lcdpComponent.addRenderParam("Min", (Object)("$event, " + minRealBindData));
        ctx.addData(instanceKey + "Focusing: false", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u662f\u5426\u83b7\u53d6\u7126\u70b9\u5c5e\u6027"));
        this.renderInputMethod(lcdpComponent, ctx, minRealBindData, maxRealBindData);
        this.renderBlurMethod(lcdpComponent, ctx, minRealBindData, maxRealBindData);
    }

    private String renderDataItem(LcdpComponent lcdpComponent, Ctx ctx, List<String> dataItems) throws LcdpException {
        ComponentDataUtil.ComponentValueStatusEnum dataItemDateStatus = ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, dataItems);
        String suffix = dataItems.get(0).substring(0, 1).toUpperCase() + dataItems.get(0).substring(1);
        String realBindData = ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)dataItemDateStatus) ? RenderVModelUtil.renderDataItem((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)suffix, dataItems, null).getRenderValue() : RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)suffix, dataItems, (String)"null");
        return realBindData;
    }

    private void renderInputMethod(LcdpComponent lcdpComponent, Ctx ctx, String minRealBindData, String maxRealBindData) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Integer decimal = (Integer)lcdpComponent.getProps().get("decimal");
        if (ToolUtil.isEmpty((Object)decimal)) {
            decimal = 0;
        }
        params.put("decimal", decimal);
        String decimalType = (String)lcdpComponent.getProps().get("decimalType");
        Boolean completion = true;
        completion = ToolUtil.isNotEmpty((Object)decimalType) && "completion".equals(decimalType) ? Boolean.valueOf(true) : (ToolUtil.isNotEmpty((Object)decimalType) && "truncation".equals(decimalType) ? Boolean.valueOf(false) : Boolean.valueOf(true));
        params.put("completion", completion);
        params.put("negative", lcdpComponent.getProps().get("negative"));
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        params.put("dataProp", minRealBindData);
        params.put("type", true);
        ctx.addMethod(instanceKey + "HandleMinInput", Collections.singletonList("v"), RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/deal_number.ftl", params), false);
        ctx.addMethod(instanceKey + "MinValue", Collections.singletonList("value"), RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/el_inputNumberValue.ftl", params), false);
        ctx.addData(lcdpComponent.getInstanceKey() + "MinInputData: false,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u662f\u5426\u624b\u52a8\u8f93\u5165"));
        ctx.addData(lcdpComponent.getInstanceKey() + "MaxInputData: false,", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u662f\u5426\u624b\u52a8\u8f93\u5165"));
        params.put("dataProp", maxRealBindData);
        params.put("type", false);
        ctx.addMethod(instanceKey + "HandleMaxInput", Collections.singletonList("v"), RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/deal_number.ftl", params), false);
        ctx.addMethod(instanceKey + "MaxValue", Collections.singletonList("value"), RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/el_inputNumberValue.ftl", params), false);
        ctx.addMethod(instanceKey + "Format", Collections.singletonList("value"), RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/el_value_format.ftl", params), false);
    }

    private void renderBlurMethod(LcdpComponent lcdpComponent, Ctx ctx, String minRealBindData, String maxRealBindData) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String instanceKey = lcdpComponent.getInstanceKey();
        params.put("instanceKey", instanceKey);
        params.put("minNumber", minRealBindData);
        params.put("maxNumber", maxRealBindData);
        String decimalType = (String)lcdpComponent.getProps().get("decimalType");
        Boolean completion = true;
        completion = ToolUtil.isNotEmpty((Object)decimalType) && "completion".equals(decimalType) ? Boolean.valueOf(true) : (ToolUtil.isNotEmpty((Object)decimalType) && "truncation".equals(decimalType) ? Boolean.valueOf(false) : Boolean.valueOf(true));
        params.put("completion", completion);
        Integer decimal = (Integer)lcdpComponent.getProps().get("decimal");
        if (ToolUtil.isEmpty((Object)decimal)) {
            decimal = 0;
        }
        params.put("decimal", decimal);
        ctx.addMethod(instanceKey + "HandleBlur", Collections.singletonList("value"), RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/numberRange_handleBlur.ftl", params), false);
    }

    private void renderMethods(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instanceKey", instanceKey);
        params.put("value", true);
        ctx.addMethod(instanceKey + "HandleFocus", Collections.singletonList("value"), RenderUtil.renderTemplate((String)"/template/elementui/element/NumberRange/numberRange_handleFocus.ftl", params), false);
        List triggers = lcdpComponent.getTrigger();
        if (ToolUtil.isNotEmpty((Object)triggers)) {
            for (Trigger trigger : triggers) {
                if ("change".equals(trigger.getName())) {
                    lcdpComponent.addRenderParam("change", (Object)true);
                }
                if ("blur".equals(trigger.getName())) {
                    lcdpComponent.addRenderParam("blur", (Object)true);
                }
                if ("focus".equals(trigger.getName())) {
                    lcdpComponent.addRenderParam("focus", (Object)true);
                }
                if (!"input".equals(trigger.getName())) continue;
                lcdpComponent.addRenderParam("input", (Object)true);
            }
            lcdpComponent.setTriggers(triggers.stream().filter(i -> !i.getName().equals("change") && !i.getName().equals("blur") && !i.getName().equals("focus") && !i.getName().equals("input")).collect(Collectors.toList()));
        }
    }

    private void dealDisabledAttr(LcdpComponent lcdpComponent, Ctx ctx) {
        Map props = lcdpComponent.getProps();
        Boolean disabledValue = props.get("disabled") != null ? props.get("disabled") : Boolean.valueOf(false);
        ctx.addData(lcdpComponent.getInstanceKey() + "Disabled: " + disabledValue, MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"\u7981\u7528\u5c5e\u6027"));
    }
}

