/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.AudioVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class JXDAudio
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.extendelement.JXDAudio";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)":focus");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)".is-disabled");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_audio");
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("loop", "${prefix} .loop-btn {bottom:12px;z-index: 1;right:72px;width:24px;color:white;position:${val};}");
        map.put("loopPlay", "${prefix} .loopPlay-btn {bottom:12px;z-index: 1;right:72px;width:24px;color:white;position:${val};display:none}");
        map.put("play", "${prefix} .play-btn {bottom:9px;z-index: 1;left:2px;width:32px;color:white;position:${val};}");
        map.put("pause", "${prefix} .pause-btn {bottom:9px;z-index: 1;left:2px;width:32px;color:white;position:${val};display:none}");
        map.put("speed", "${prefix} .speed-btn {bottom:12px;z-index: 1;right:0px;width:70px;position:${val};font-size: 14px;text-align: center;}");
        map.put("word", "${prefix} .speed-num {color: ${val};}");
        map.put("muted", "${prefix} .muted-btn {bottom:12px;z-index: 1;right:105px;width:24px;color:white;position:${val};}");
        map.put("mutedHide", "${prefix} .mutedHide {display:${val};filter: brightness(0.7);}");
        map.put("progress", "${prefix} .progress {position: absolute;left: 44px;top: ${val}px;width: calc(100% - 190px);}");
        map.put("controls", "${prefix} .controls {position: ${val};width: 100%;height: 100%;min-width:300px;min-height:45px}");
        map.put("videoTimer", "${prefix} .video-timer {color: ${val};width: fit-content;font-weight: 400;bottom: 20px;left: 44px;position: absolute;}");
        map.put("videoSound", "${prefix} .video-sound {position: absolute;bottom: ${val};right: 95px;}");
        map.put("disabledBtn", "${prefix} .disabled-btn {filter: ${val};}");
        map.put("soundBar", "${prefix} .soundBar {height: ${val};background: #00a1d6;}");
        map.put("audioShotbtn", "${prefix} .audio-shotbtn {width: 100%;min-width: 300px;min-height:45px;height: ${val};}");
        map.put("popContainerT", "${prefix} .popContainer {position: absolute;z-index: 1002;top: ${val}px;background: rgba(0,0,0,0);}");
        map.put("popContainerL", "${prefix} .popContainer {left: ${val}px;}");
        map.put("popContainerW", "${prefix} .popContainer {width: ${val}px;}");
        map.put("popContainerH", "${prefix} .popContainer {height: ${val}px;}");
        map.put("cursor", "${prefix} .popContainer {cursor: ${val};}");
        map.put("borderBox", "${prefix} {border:${val}};");
        map.put("borderTop", "${prefix} .audio-shotbtn {border-top:${val} !important;}");
        map.put("borderRight", "${prefix} .audio-shotbtn {border-right:${val} !important;}");
        map.put("borderBottom", "${prefix} .audio-shotbtn {border-bottom:${val} !important;}");
        map.put("borderLeft", "${prefix} .audio-shotbtn {border-left:${val} !important;}");
        map.put("borderTopColor", "${prefix} .audio-shotbtn {border-top-color:${val} !important;}");
        map.put("borderBottomColor", "${prefix} .audio-shotbtn {border-bottom-color:${val} !important;}");
        map.put("borderLeftColor", "${prefix} .audio-shotbtn {border-left-color:${val} !important;}");
        map.put("borderRightColor", "${prefix} .audio-shotbtn {border-right-color:${val} !important;}");
        map.put("borderRadius", "${prefix} .audio-shotbtn {border-radius:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border-radius: unset}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public VoidVisitor visitor() {
        return new AudioVisitor();
    }

    public static JXDAudio newComponent(JSONObject jsonObject) {
        Boolean isBorderRadiusNew;
        Boolean isBorderNew;
        JXDAudio audio = (JXDAudio)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)JXDAudio.class.getName()));
        Object backgroundImg = audio.getStyles().get("backgroundImageBack");
        audio.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            audio.getStyles().put("backgroundImage", backgroundImg);
        }
        Integer height = audio.getHeight() < 45 ? 45 : audio.getHeight();
        audio.getInnerStyles().put("progress", height - 34);
        audio.getInnerStyles().put("popContainerW", audio.getWidth());
        audio.getInnerStyles().put("popContainerH", audio.getHeight());
        audio.getInnerStyles().put("popContainerT", 0);
        audio.getInnerStyles().put("popContainerL", 0);
        audio.getStyles().remove("vertical");
        audio.getInnerStyles().put("videoSound", audio.getTop() >= 70 || audio.getHeight() >= 120 || audio.getHeight() + audio.getTop() >= 120 ? audio.getStyles().get("videoSound") : "-63px");
        if (audio.getProps().get("isBorderNew") != null && (isBorderNew = (Boolean)audio.getProps().get("isBorderNew")).booleanValue() && (audio.getWidth() < 300 || audio.getHeight() < 45)) {
            audio.getInnerStyles().put("borderBox", "none !important");
            audio.getInnerStyles().put("borderTop", audio.getStyles().get("borderTop"));
            audio.getInnerStyles().put("borderRight", audio.getStyles().get("borderRight"));
            audio.getInnerStyles().put("borderBottom", audio.getStyles().get("borderBottom"));
            audio.getInnerStyles().put("borderLeft", audio.getStyles().get("borderLeft"));
            audio.getInnerStyles().put("borderTopColor", audio.getStyles().get("borderTopColor"));
            audio.getInnerStyles().put("borderRightColor", audio.getStyles().get("borderRightColor"));
            audio.getInnerStyles().put("borderBottomColor", audio.getStyles().get("borderBottomColor"));
            audio.getInnerStyles().put("borderLeftColor", audio.getStyles().get("borderLeftColor"));
        }
        if (audio.getProps().get("isBorderRadiusNew") != null && (isBorderRadiusNew = (Boolean)audio.getProps().get("isBorderRadiusNew")).booleanValue()) {
            audio.getInnerStyles().put("borderRadius", audio.getStyles().get("borderRadius"));
        }
        return audio;
    }
}

