<#--懒加载查询：根据节点id查询其子节点数据 -->
const { node, resolve } = $event;
if (node.level === 0) {
    const paramData = {
        parentId: self.${compId}RootSign,
        ifLazy: '1',
        defaultLevel: '1'
    };
    ${getInfo}(paramData).then((res) => {
        const nodeData = [];
        const data = res.data;
        if ((res.code === 10000 || res.code === 200) && data) {
            data.forEach((item) => {
                <#if (showIcon)>
                    for(let i = 0; i < self.${compId!}IconList.length; i++){
                        const level = self.${compId!}IconList[i].nodeType;
                        const icon = self.${compId!}IconList[i].icon;
                        if (Number(level) === item.struLevel){
                            item.icon = icon;
                        }
                    }
                </#if>
                if(item.id === '11'){
                    item.disabled = true;
                }
                nodeData.push({
                    ...item,
                    pid: item.parentId,
                    children: self.${childrenData!}(item.children),
                })
            })
            <#if isChain>
                self.${compId!}LazyTreeData.push(nodeData);
            <#else >
                self.${compId!}LazyTreeData = nodeData;
                self.${compId!}Init = true;
            </#if>
            return resolve(nodeData);
        } else {
            self.$message.error("组织下拉树组件数据请求失败");
        }
    }).catch(function() {
        self.$message.error("组织下拉树组件数据请求异常");
    });
} else {
    if (!(node.data.hasChildren && JSON.parse(node.data.hasChildren))) {
        node.loading = false;
        return resolve([]);
    }
    if (node.data && node.data.id) {
        const paramData = {
            parentId: node.data.id,
        };
        getChildren${sourceType}(paramData).then(res => {
            if ((res.code === 200 || res.code === 10000) && res.data) {
                const nodeChilrend = [];
                res.data.forEach((item) => {
                    <#if (showIcon)>
                        for(let i = 0; i < self.${compId!}IconList.length; i++){
                            const level = self.${compId!}IconList[i].nodeType;
                            const icon = self.${compId!}IconList[i].icon;
                            if (Number(level) === item.struLevel){
                                item.icon = icon;
                            }
                        }
                    </#if>

                    <#if sourceType =='Staff' || sourceType == 'User'>
                        //判断 懒加载出来的数据，在树数据中是否存在有重复的ID，有则去重
                        const ifExist = self.checkTreeData(self.${treeData},item,false);
                        if (!ifExist) {//树结构中不存在该数据
                            if (item.children.length > 0 || (item.children.length === 0 && (item.struType === '9' || item.struType === '')))  {
                                nodeChilrend.push({
                                    ...item,
                                    pid: item.parentId,
                                    children: self.${childrenData!}(item.children)
                                });
                            } else {
                                nodeChilrend.push({
                                    ...item,
                                    pid: item.parentId,
                                    children: self.${childrenData!}(item.children),
                                    disabled: true
                                });
                            }
                        } else {
                            node.data.disabled =true;
                        }
                    <#elseif sourceType =='Organ'>
                        nodeChilrend.push({
                            ...item,
                            pid: item.parentId,
                            children: self.${childrenData!}(item.children),
                        });
                    </#if>

                });
                <#if isChain>
                    self.$refs[`${compId}Ref` + ${chainId}Index][0].lazyDataSwitchTreeData(node.data.id, nodeChilrend);
                <#else >
                    self.$refs.${compId}Ref.lazyDataSwitchTreeData(node.data.id, nodeChilrend);
                </#if>
                resolve(nodeChilrend);
            } else {
                self.$message.error("组织下拉树组件数据请求失败");
            }
        }).catch(function() {
            self.$message.error("组织下拉树组件数据请求异常");
        });
    }
}