<#-- 根据子id获取父级路径，用于懒加载数据展开回显 -->
<#if isChain>
const componentRef = `${compId}Ref` + index;
</#if>
const getInfoBySid = function(sid) {
    return new Promise((resolve, reject) => {
        <#if isChain>
            const node = self.$refs[componentRef][0].$refs.tree.getNode(sid);
        <#else >
            const node = self.$refs.${compId}Ref.$refs.tree.getNode(sid);
        </#if>
        if (!node) {
            const paramData = {
                id: sid,
            };
            ${getInfoById}(paramData).then(res => {
                if ((res.code === 200 || res.code === 10000) && res.data && JSON.stringify(res.data)!=='{}') {
                    const struFid = res.data ? res.data.struFid.split('/').filter(Boolean) : '';
                    if (struFid) {
                        resolve({ struFid: struFid, label: res.data.label });
                    }
                } else {
<#--                    self.$message.error("根据id查询数据请求失败");-->
                        resolve({});
                }
            }).catch(function() {
                self.$message.error("根据id查询数据请求异常");
            });
        } else {
            resolve({ struFid: [node.data.id], label: node.data.label });
        }
    })
}
const pidArr = [];
for (let i = 0; i < idsArr.length; i++) {
    const arr = await getInfoBySid(idsArr[i]);
    if(JSON.stringify(arr)!=='{}'){
        pidArr.push({
            struFid: arr.struFid,
            label: arr.label,
            id: idsArr[i]
        });
    }
}
if (pidArr.length > 0) {
<#if isChain>
    await self.$refs[componentRef][0].initLazyEcho(pidArr);
<#else >
    await self.$refs.${compId}Ref.initLazyEcho(pidArr);
</#if>
    self.${compId}TreeEchoSign = 1;
}
