/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.utils.TextAlignForVertical;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.ButtonGroupVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ButtonGroup
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.extendelement.JXDElButtonGroup";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)".el-button:hover:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)".el-button:focus:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)".el-button.is-disabled:not(.jxd_ins_elButtonReadonly)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"dragDisabled", (String)".el-button.is-disabled.disabledButton:not(.jxd_ins_elButtonReadonly)");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elButtonGroup");
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fontFamily", "${prefix} .el-button{font-family:${val};}");
        map.put("fontSize", "${prefix} .el-button{font-size:${val};}");
        map.put("fontWeight", "${prefix} .el-button{font-weight:${val};}");
        map.put("fontStyle", "${prefix} .el-button{font-style:${val};}");
        map.put("textDecoration", "${prefix} .el-button{text-decoration:${val};}");
        map.put("letterSpacing", "${prefix} .jxd-button-group-item {letter-spacing:${val};}");
        map.put("color", "${prefix} .el-button{color:${val};}");
        map.put("lineHeight", "${prefix} .el-button{line-height:${val};}");
        map.put("vertical", "${prefix} .el-button{vertical:${val};}");
        map.put("backgroundColor", "${prefix} .el-button{background-color:${val};}");
        map.put("backgroundImage", "${prefix} .el-button{background-image:${val};}");
        map.put("backgroundPosition", "${prefix} .el-button{background-position:${val};}");
        map.put("backgroundSize", "${prefix} .el-button{background-size:${val};}");
        map.put("backgroundRepeat", "${prefix} .el-button{background-repeat:${val};}");
        map.put("backgroundImageBack", "${prefix} .el-button{background-image-back:${val};}");
        map.put("borderTop", "${prefix} .el-button{border-top:${val};}");
        map.put("borderTopColor", "${prefix} .el-button{border-top-color:${val};}");
        map.put("borderRight", "${prefix} .el-button{border-right:${val};}");
        map.put("borderRightColor", "${prefix} .el-button{border-right-color:${val};}");
        map.put("borderBottom", "${prefix} .el-button{border-bottom:${val};}");
        map.put("borderBottomColor", "${prefix} .el-button{border-bottom-color:${val};}");
        map.put("borderLeft", "${prefix} .el-button{border-left:${val};}");
        map.put("borderLeftColor", "${prefix} .el-button{border-left-color:${val};}");
        map.put("borderRadius", "${prefix} .el-button{border-radius:${val};}");
        map.put("boxShadow", "${prefix} .el-button{box-shadow:${val};}");
        map.put("iconFontWeight", "${prefix} span i{font-weight:${val};}");
        map.put("buttonMarginLeft", "${prefix} {margin-left:${val};}");
        map.put("iconFontSize", "${prefix} span i{font-size:${val};letter-spacing:0;}");
        map.put("itemAlign", "${prefix}  {align-items:${val};}");
        map.put("itemJustifyContent", "${prefix}  {justify-content:${val};}");
        map.put("itemDisplay", "${prefix}  {display:${val};}");
        map.put("buttonSplit", "${prefix} .el-button{margin-right:${val};}");
        map.put("background", "${prefix} {background:${val};}");
        map.put("display", "${prefix} {display:flex;}");
        map.put("width", "${prefix} .el-dropdown{width:${val};} ${prefix} .el-button{width:${val};}");
        map.put("height", "${prefix} .el-dropdown{height:100% !important;} ${prefix} .el-button{height:100% !important;}");
        map.put("colors", "${prefix} .disabledButton{color:${val};}");
        map.put("backgroundColors", "${prefix} .disabledButton{background-color:${val};}");
        map.put("borderTops", "${prefix} .disabledButton{border-top:${val};}");
        map.put("borderTopColors", "${prefix} .disabledButton{border-top-color:${val};}");
        map.put("borderRights", "${prefix} .disabledButton{border-right:${val};}");
        map.put("borderRightColors", "${prefix} .disabledButton{border-right-color:${val};}");
        map.put("borderBottoms", "${prefix} .disabledButton{border-bottom:${val};}");
        map.put("borderBottomColors", "${prefix} .disabledButton{border-bottom-color:${val};}");
        map.put("borderLefts", "${prefix} .disabledButton{border-left:${val};}");
        map.put("borderLeftColors", "${prefix} .disabledButton{border-left-color:${val};}");
        map.put("borderRadiuss", "${prefix} .disabledButton{border-radius:${val};}");
        map.put("boxShadows", "${prefix} .disabledButton{box-shadow:${val};}");
        map.put("textAlign", "dynamicStyleTemplate");
        map.put("buttonWidth", "${prefix} .el-button{width:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("textAlign", value -> {
            if (value.equals("left")) {
                return "${prefix} .el-button {text-align:${val};}${prefix} .el-button {justify-content: flex-start;}";
            }
            if (value.equals("center")) {
                return "${prefix} .el-button {text-align:${val};}${prefix} .el-button {justify-content: center;}";
            }
            if (value.equals("right")) {
                return "${prefix} .el-button {text-align:${val};}${prefix} .el-button {justify-content: flex-end;}";
            }
            if (value.equals("justify")) {
                return "${prefix} .el-button {text-align:${val};}${prefix} .el-button {justify-content: space-between;}";
            }
            return "";
        });
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}, .jxd-button-group-item{border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix},.jxd-button-group-item {border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} .el-button{box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public VoidVisitor visitor() {
        return new ButtonGroupVoidVisitor();
    }

    public static ButtonGroup newComponent(JSONObject jsonObject) {
        ButtonGroup buttonGroup = (ButtonGroup)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)ButtonGroup.class.getName()));
        Object backgroundImg = buttonGroup.getStyles().get("backgroundImageBack");
        buttonGroup.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            buttonGroup.getStyles().put("backgroundImage", backgroundImg);
        }
        TextAlignForVertical.setTextAlign(buttonGroup, "styles");
        buttonGroup.getStyles().remove("vertical");
        buttonGroup.getInnerStyles().put("iconFontWeight", "normal");
        String marginLeft = (String)buttonGroup.getStyles().get("margin-left");
        if (ToolUtil.isNotEmpty((Object)marginLeft)) {
            buttonGroup.getInnerStyles().put("buttonMarginLeft", marginLeft);
        } else {
            buttonGroup.getInnerStyles().put("buttonMarginLeft", "0");
        }
        String marginRight = (String)buttonGroup.getInnerStyles().get("buttonSplit");
        if (ToolUtil.isNotEmpty((Object)marginRight)) {
            buttonGroup.getInnerStyles().put("buttonSplit", marginRight);
        } else {
            buttonGroup.getInnerStyles().put("buttonSplit", "5px");
        }
        Object fontSize = buttonGroup.getStyles().get("fontSize");
        buttonGroup.getInnerStyles().put("iconFontSize", fontSize);
        buttonGroup.getInnerStyles().put("display", "${prefix} {display:flex;}");
        Boolean isFolded = (Boolean)buttonGroup.getProps().get("isFolded");
        if (isFolded.booleanValue()) {
            JSONArray jsonOption = (JSONArray)buttonGroup.getProps().get("options");
            Integer foldedShowNum1 = (Integer)buttonGroup.getProps().get("foldedShowNum");
            for (int i = 0; i < jsonOption.size(); ++i) {
                if (!((Boolean)jsonOption.getJSONObject(i).get((Object)"hidden")).booleanValue()) continue;
                Integer n = foldedShowNum1;
                Integer n2 = foldedShowNum1 = Integer.valueOf(foldedShowNum1 + 1);
            }
            int foldedHiddenNum = jsonOption.size() - foldedShowNum1;
            int width = buttonGroup.getWidth();
            int foldedShowNum = (Integer)buttonGroup.getProps().get("foldedShowNum");
            String buttonSplit = (String)buttonGroup.getInnerStyles().get("buttonSplit");
            int buttonSplit1 = 5;
            if (StringUtils.isNotEmpty((CharSequence)buttonSplit)) {
                buttonSplit1 = Integer.parseInt(StringUtils.substringBefore((String)buttonSplit, (String)"p"));
            }
            int buttonWidth = (width - buttonSplit1 * foldedShowNum) / (foldedShowNum + 1);
            if (foldedHiddenNum == 0) {
                buttonGroup.setWidth(width - buttonWidth);
            }
            buttonGroup.getInnerStyles().put("width", buttonWidth + "px");
        } else {
            JSONArray jsonOption = (JSONArray)buttonGroup.getProps().get("options");
            int width = buttonGroup.getWidth();
            String buttonSplit = (String)buttonGroup.getInnerStyles().get("buttonSplit");
            int buttonSplit1 = 5;
            if (StringUtils.isNotEmpty((CharSequence)buttonSplit)) {
                buttonSplit1 = Integer.parseInt(StringUtils.substringBefore((String)buttonSplit, (String)"p"));
            }
            int buttonWidth = (width - buttonSplit1 * (jsonOption.size() - 1)) / jsonOption.size();
            buttonGroup.getInnerStyles().put("width", buttonWidth + "px");
        }
        buttonGroup.getInnerStyles().put("height", "${prefix} .el-dropdown{height:100% !important;},${prefix} .el-button{height:100% !important;}");
        buttonGroup.getInnerStyles().put("flex", "${prefix} .el-dropdown{flex:1;},${prefix} .el-button{flex:1;}");
        buttonGroup.addClassName("button_additional");
        return buttonGroup;
    }
}

