/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataitem.reference.GetValueBO;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.dataset.MethodConfigAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.reference.ColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.ReplaceDataUtil;
import com.jxdinfo.hussar.formdesign.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.formdesign.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.ComponentResource;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Trigger;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CustomTableVoidVisitor
implements VoidVisitor<LcdpComponent, Ctx> {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("pageSize"))) {
            Integer size = (Integer)lcdpComponent.getProps().get("pageSize");
            lcdpComponent.addRenderParam("size", (Object)size);
        }
        lcdpComponent.registerTemplatePath("/template/elementui/element/customTable/custom_table.ftl");
        Map dataParams = lcdpComponent.getRenderParamsToBind();
        this.renderAttrs(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx, dataParams);
        this.renderMethod(lcdpComponent, ctx, dataParams);
        this.renderEvent(lcdpComponent, ctx);
        this.dealNeedOperation(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx);
        List elementResourceDTOList = ctx.getElementResourceDTOList();
        for (ComponentResource componentResource : elementResourceDTOList) {
            if (!componentResource.getKey().equals(lcdpComponent.getInstanceKey())) continue;
            dealFormDataVisitor.dealPermissionAttr(lcdpComponent, ctx);
        }
    }

    public void renderData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException, IOException {
        this.renderTableData(lcdpComponent, ctx);
        this.renderSelectData(lcdpComponent, ctx);
        this.renderTotalData(lcdpComponent, ctx, dataParams);
        this.renderPageData(lcdpComponent, ctx, dataParams);
        String dataArrayStr = RenderUtil.renderTemplate((String)"/template/elementui/element/customTable/custom_table_data.ftl", dataParams);
        ctx.addDataCommon(dataArrayStr);
    }

    private void renderTableData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)"[]");
        lcdpComponent.addRenderParam("valueData", (Object)valueData);
    }

    private void renderSelectData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        ArrayList<String> selectItems = new ArrayList<String>();
        selectItems.add("data");
        RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_DATA_CHECKED.getType(), selectItems, (String)"[]");
    }

    private void renderTotalData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException, IOException {
        if (null != dataParams.get("isPagination") && ((Boolean)dataParams.get("isPagination")).booleanValue()) {
            ArrayList<String> totalItems = new ArrayList<String>();
            totalItems.add("total");
            String totalData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_TOTAL.getType(), totalItems, (String)"0");
            lcdpComponent.addRenderParam("TableTotal", (Object)totalData);
            dataParams.put("TableTotal", totalData);
        }
    }

    private void renderPageData(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException, IOException {
        ArrayList<String> pageDataItems = new ArrayList<String>();
        pageDataItems.add("pagination");
        StringBuilder pageDefault = new StringBuilder(16);
        pageDefault.append("{\ncurrent: 1,\nsize: ");
        if (null != dataParams.get("size")) {
            pageDefault.append(Integer.parseInt(dataParams.get("size").toString())).append(",\n}");
        } else {
            pageDefault.append("10,\n}");
        }
        String pageData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._TABLE_PAGE_DATA.getType(), pageDataItems, (String)pageDefault.toString());
        lcdpComponent.addRenderParam("ListQuery", (Object)pageData);
        dataParams.put("ListQuery", pageData);
    }

    public void renderMethod(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws IOException, LcdpException {
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"showConfigs");
        this.renderTableLoad(lcdpComponent, ctx, showConfigAnalyses, dataParams);
        this.renderReplaceData(lcdpComponent, ctx, showConfigAnalyses);
        this.renderSelection(lcdpComponent, ctx);
        this.renderTablePage(lcdpComponent, ctx, dataParams);
        this.renderHyperlinks(lcdpComponent, ctx, dataParams);
    }

    private void renderTablePage(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        ArrayList<String> handleSizeChange = new ArrayList<String>();
        handleSizeChange.add("pageSize");
        ArrayList<String> handleCurrentChange = new ArrayList<String>();
        handleCurrentChange.add("currentPage");
        Object isPagination = lcdpComponent.getProps().get("isPagination");
        if (ToolUtil.isNotEmpty(isPagination) && Boolean.parseBoolean(isPagination.toString())) {
            this.dealRestfulPagination(params, lcdpComponent, ctx);
            params.put("ListQuery", dataParams.get("ListQuery"));
            params.put("isSortChange", this.renderSortOverall(lcdpComponent));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleSizeChange", handleSizeChange, RenderUtil.renderTemplate((String)"/template/elementui/element/customTable/custom_table_handle_size_change_method.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleCurrentChange", handleCurrentChange, RenderUtil.renderTemplate((String)"/template/elementui/element/customTable/custom_table_handle_current_change_method.ftl", params));
        }
    }

    public void renderTableLoad(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses, Map<String, Object> dataParams) throws LcdpException, IOException {
        HashMap<String, Object> tableMap = new HashMap<String, Object>(dataParams);
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        HashMap<String, List<DataSFieldAnalysis>> fields = new HashMap();
        String primary = "";
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            String dataModelId = dataSModelAnalysis.getDataModelId();
            fields = dataSModelAnalysis.getFields();
            if (ToolUtil.isNotEmpty((Object)dataModelId)) {
                primary = ModelProvideAdapter.adaptor((String)dataModelId).getPrimaryFieldName(dataModelId);
                tableMap.put("primaryKey", primary);
            }
            this.getApi(lcdpComponent, ctx, dataSModelAnalysis, tableMap);
        }
        boolean renderSortOverall = this.renderSortOverall(lcdpComponent);
        tableMap.put("renderSortOverall", renderSortOverall);
        Boolean crossPageSelect = (Boolean)lcdpComponent.getProps().get("crossPageSelect");
        if (ToolUtil.isNotEmpty((Object)crossPageSelect) && crossPageSelect.booleanValue()) {
            tableMap.put("crossPageSelect", true);
        }
        this.getColFieldMapping(tableMap, fields, primary);
        Optional<ShowConfigAnalysis> showConfig = Optional.ofNullable(showConfigAnalyses).map(analyse -> (ShowConfigAnalysis)analyse.get(0));
        if (showConfig.isPresent() && showConfig.get().isConfigComplete()) {
            tableMap.put("isShowConfig", true);
        }
        ArrayList<String> callbacks = new ArrayList<String>();
        callbacks.add("callback");
        Boolean isRadio = (Boolean)lcdpComponent.getProps().get("isRadio");
        tableMap.put("isRadio", isRadio);
        tableMap.put("callbackCodeWithoutData", AsyncActionUtil.getCallbackCodeWithoutData((String)"\u6570\u636e\u8868\u683c"));
        tableMap.put("callbackCode", "if (callback && typeof callback === 'function') {callback();}");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "TableLoad", callbacks, RenderUtil.renderTemplate((String)"/template/elementui/element/customTable/custom_table_load_method.ftl", tableMap));
    }

    private void getApi(LcdpComponent lcdpComponent, Ctx ctx, DataSModelAnalysis dataSModelAnalysis, Map<String, Object> tableMap) throws LcdpException {
        Object isPagination;
        String sortConditionName;
        DataSortConditionAnalysis dataSortConditionAnalysis;
        DataSConditionAnalysis dataSConditionAnalysis;
        String operationName = "hussarQuery";
        String apiFileName = "";
        String apiFilePath = "";
        StringBuilder queryAttr = new StringBuilder(128);
        String dataModelId = dataSModelAnalysis.getDataModelId();
        if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
            apiFileName = this.fileMappingService.getFileName(dataModelId);
            apiFilePath = this.fileMappingService.getImportPath(dataModelId);
        }
        if (ToolUtil.isNotEmpty((Object)(dataSConditionAnalysis = dataSModelAnalysis.getCondition()))) {
            List conditionList = dataSConditionAnalysis.getQueryConditionModelList();
            queryAttr = QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx);
            String querySelectionName = dataSConditionAnalysis.getSelectCondition();
            if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                operationName = operationName + querySelectionName;
            }
        }
        if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
            operationName = operationName + sortConditionName;
        }
        if (ToolUtil.isNotEmpty(isPagination = lcdpComponent.getProps().get("isPagination")) && Boolean.parseBoolean(isPagination.toString())) {
            operationName = operationName + CodeSuffix._TABLE_PAGE_SUFFIX.getType();
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
        }
        tableMap.put("importName", apiFileName);
        tableMap.put("importMethod", operationName);
        tableMap.put("queryAttr", queryAttr);
    }

    private void getColFieldMapping(Map<String, Object> tableMap, Map<String, List<DataSFieldAnalysis>> fields, String primary) {
        JSONArray componentCols = (JSONArray)tableMap.get("component_cols");
        List cols = JSON.parseArray((String)componentCols.toJSONString(), ColsAnalysis.class);
        HashMap<String, String> colFields = new HashMap<String, String>();
        String col = "";
        String field = "";
        if (ToolUtil.isNotEmpty(fields) && ToolUtil.isNotEmpty((Object)cols)) {
            for (ColsAnalysis colsAnalysis : cols) {
                boolean flag = true;
                for (List<DataSFieldAnalysis> modelField : fields.values()) {
                    List dataItems;
                    if (!HussarUtils.isNotEmpty(modelField) || modelField.size() <= 0 || !ToolUtil.isNotEmpty((Object)colsAnalysis) || !ToolUtil.isNotEmpty((Object)(dataItems = modelField.get(0).getDataItemPath())) || dataItems.size() <= 1 || !colsAnalysis.getId().equals(dataItems.get(1))) continue;
                    col = colsAnalysis.getField();
                    field = modelField.get(0).getFieldName();
                    colFields.put(col, field);
                    flag = false;
                    break;
                }
                if (!flag) continue;
                col = colsAnalysis.getField();
                colFields.put(col, col);
            }
        }
        boolean containPrimary = false;
        if (ToolUtil.isNotEmpty(fields)) {
            for (List<DataSFieldAnalysis> modelField : fields.values()) {
                if (!HussarUtils.isNotEmpty(modelField) || modelField.size() <= 0 || !primary.equals(modelField.get(0).getFieldName())) continue;
                containPrimary = true;
                break;
            }
        }
        if (!containPrimary && ToolUtil.isNotEmpty((Object)primary)) {
            colFields.put(primary, primary);
        }
        tableMap.put("colFields", colFields);
    }

    private void renderReplaceData(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws IOException, LcdpException {
        HashMap<String, Object> replaceDataMap = new HashMap<String, Object>();
        if (ToolUtil.isNotEmpty(showConfigAnalyses) && showConfigAnalyses.get(0).isConfigComplete()) {
            List showConfigItemInfos = ReplaceDataUtil.handlerShowConfigs((Ctx)ctx, showConfigAnalyses);
            replaceDataMap.put("showConfigItemInfos", showConfigItemInfos);
            replaceDataMap.put("instanceKey", lcdpComponent.getInstanceKey());
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, ctx, null);
            replaceDataMap.put("tableData", valueVisitor.getDataItemValue(null).getRenderValue());
            ctx.addMethod(lcdpComponent.getInstanceKey() + CodeSuffix._REPLACE_DATA.getType(), RenderUtil.renderTemplate((String)"/template/elementui/element/customTable/custom_table_replace_data_method.ftl", replaceDataMap));
        }
    }

    private void renderEvent(LcdpComponent lcdpComponent, Ctx ctx) {
        List triggers;
        List eventConfigs = lcdpComponent.getEvents();
        if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("item");
            boolean rowClick = false;
            boolean rowDblClick = false;
            for (EventConfig eventConfig : eventConfigs) {
                if ("rowClick".equals(eventConfig.getTrigger())) {
                    lcdpComponent.addRenderParam("rowClick", (Object)true);
                    rowClick = true;
                }
                if (!"rowDblClick".equals(eventConfig.getTrigger())) continue;
                rowDblClick = true;
                lcdpComponent.addRenderParam("rowDblClick", (Object)true);
            }
            if (rowClick && rowDblClick) {
                ctx.addDataCommon(lcdpComponent.getInstanceKey() + "TimeOut: ''");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "RowClickFront", params, "clearTimeout(self." + lcdpComponent.getInstanceKey() + "TimeOut);\nself." + lcdpComponent.getInstanceKey() + "TimeOut = setTimeout(() => {\nself." + lcdpComponent.getInstanceKey() + "RowClick(item)\n}, 350);");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "RowDblClickFront", params, "clearTimeout(self." + lcdpComponent.getInstanceKey() + "TimeOut);\nself." + lcdpComponent.getInstanceKey() + "RowDblClick(item);");
            }
        }
        if (ToolUtil.isNotEmpty((Object)(triggers = lcdpComponent.getTrigger()))) {
            triggers.clear();
        }
    }

    private void renderSelection(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        Boolean showSelection = (Boolean)lcdpComponent.getProps().get("showSelection");
        if (ToolUtil.isNotEmpty((Object)showSelection) && showSelection.booleanValue()) {
            String chooseCheckBox = (String)lcdpComponent.getProps().get("chooseCheckBox");
            Boolean isRadio = (Boolean)lcdpComponent.getProps().get("isRadio");
            String instanceKey = lcdpComponent.getInstanceKey();
            if (ToolUtil.isNotEmpty((Object)chooseCheckBox)) {
                LcdpComponent checkBoxComponent = (LcdpComponent)ctx.getComponentMap().get(chooseCheckBox);
                checkBoxComponent.addAttr("@change", instanceKey + "SelectRow(" + instanceKey + "Item)");
                ArrayList<String> params = new ArrayList<String>();
                params.add("item");
                HashMap<String, Object> moduleMap = new HashMap<String, Object>();
                moduleMap.put("instanceKey", instanceKey);
                moduleMap.put("isRadio", isRadio);
                ctx.addMethod(instanceKey + "SelectRow", params, RenderUtil.renderTemplate((String)"/template/elementui/element/customTable/custom_table_select_row_method.ftl", moduleMap));
            }
        }
    }

    private void dealRestfulPagination(Map<String, Object> params, LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        if (ToolUtil.isEmpty(lcdpComponent.getProps().get("calculateRefer"))) {
            return;
        }
        List getValueBOS = JSON.parseArray((String)lcdpComponent.getProps().get("calculateRefer").toString(), GetValueBO.class);
        if (ToolUtil.isNotEmpty((Object)getValueBOS) && getValueBOS.size() > 0) {
            for (GetValueBO getValueBO : getValueBOS) {
                LcdpComponent apiComponent;
                if (!ToolUtil.isNotEmpty((Object)getValueBO.getCurrentData()) || getValueBO.getCurrentData().size() != 1 || !"value".equals(getValueBO.getCurrentData().get(0)) || !ToolUtil.isNotEmpty((Object)(apiComponent = (LcdpComponent)ctx.getComponentMap().get(getValueBO.getComponentGetData().getInstanceKey())))) continue;
                JSONObject methodObj = JSON.parseObject((String)JSON.toJSONString((Object)apiComponent.getDatas()));
                if (ToolUtil.isEmpty((Object)methodObj) || ToolUtil.isEmpty((Object)methodObj.get((Object)"datamodel"))) {
                    return;
                }
                MethodConfigAnalysis methodConfigAnalysis = (MethodConfigAnalysis)JSON.parseObject((String)methodObj.get((Object)"datamodel").toString(), MethodConfigAnalysis.class);
                String dataModelId = methodConfigAnalysis.getDataModelId();
                DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)dataModelId);
                if (!ToolUtil.isNotEmpty((Object)methodConfigAnalysis) || !ToolUtil.isNotEmpty((Object)dataModelId) || dataModelBase == null) continue;
                params.put("restfulOperationName", getValueBO.getComponentGetData().getInstanceKey() + "ApiLoad");
            }
        }
    }

    private void dealNeedOperation(LcdpComponent lcdpComponent, Ctx ctx) {
        Boolean isNeedOperation = (Boolean)lcdpComponent.getProps().get("needOperation");
        if (ToolUtil.isNotEmpty((Object)isNeedOperation) && isNeedOperation.booleanValue()) {
            JSONArray needOperations = (JSONArray)lcdpComponent.getProps().get("needOperations");
            String instanceKey = lcdpComponent.getInstanceKey();
            if (ToolUtil.isNotEmpty((Object)needOperations)) {
                for (int i = 0; i < needOperations.size(); ++i) {
                    JSONObject needOperation = needOperations.getJSONObject(i);
                    String eventName = needOperation.getString("eventName");
                    String chooseButton = needOperation.getString("chooseButton");
                    LcdpComponent buttonComponent = (LcdpComponent)ctx.getComponentMap().get(chooseButton);
                    buttonComponent.addAttr("@click", instanceKey + eventName.substring(0, 1).toUpperCase() + eventName.substring(1) + "(" + instanceKey + "Item)");
                }
            }
        }
    }

    private void renderHyperlinks(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams) throws LcdpException {
        HashMap params = new HashMap();
        JSONArray componentCols = (JSONArray)dataParams.get("component_cols");
        if (ToolUtil.isNotEmpty((Object)componentCols)) {
            List componentColsAnalyses = JSON.parseArray((String)componentCols.toJSONString(), TableOptColsAnalysis.class);
            for (TableOptColsAnalysis componentColsAnalysis : componentColsAnalyses) {
                Map childrenComponentsMap;
                Map hyperlinks = componentColsAnalysis.getHyperlinks();
                if (!ToolUtil.isNotEmpty((Object)hyperlinks) || !ToolUtil.isNotEmpty(hyperlinks.get("fileId"))) continue;
                if (ToolUtil.isNotEmpty(hyperlinks.get("jumpType"))) {
                    params.put("jumpType", hyperlinks.get("jumpType"));
                }
                String id = String.valueOf(hyperlinks.get("fileId"));
                String routerPath = null;
                if (ToolUtil.isNotEmpty((Object)id)) {
                    routerPath = FileUtil.posixPath((String[])new String[]{"${PREFIX.pathName}", this.fileMappingService.getFormatPath(id)});
                    ctx.addImports("PREFIX", "#/prefixCommon");
                }
                params.put("url", routerPath);
                Map pageParamConfig = (Map)hyperlinks.get("pageParamConfig");
                Set pageParamSet = pageParamConfig.keySet();
                HashMap<String, String> paramConfig = new HashMap<String, String>();
                HashMap<String, String> optColsFieldMap = new HashMap<String, String>();
                block1: for (String key : pageParamSet) {
                    Map pageParam = (Map)pageParamConfig.get(key);
                    JSONArray instanceData = (JSONArray)pageParam.get("instanceData");
                    String instanceKey = String.valueOf(pageParam.get("instanceKey"));
                    LcdpComponent hyperlinksLcdp = (LcdpComponent)ctx.getComponentMap().get(instanceKey);
                    if (ToolUtil.isNotEmpty((Object)hyperlinksLcdp) && hyperlinksLcdp.getName().contains("JXDElCustomTable")) {
                        JSONArray hyperlinksLcdpOptCols = (JSONArray)hyperlinksLcdp.getProps().get("component_cols");
                        List hyperlinksLcdpOptColsAnalyses = JSON.parseArray((String)hyperlinksLcdpOptCols.toJSONString(), TableOptColsAnalysis.class);
                        for (TableOptColsAnalysis tableOptColsAnalysis : hyperlinksLcdpOptColsAnalyses) {
                            if (!tableOptColsAnalysis.getId().equals(instanceData.getString(1))) continue;
                            optColsFieldMap.put(key, "row." + tableOptColsAnalysis.getField());
                            continue block1;
                        }
                        continue;
                    }
                    ComponentReference componentReference = (ComponentReference)JSON.parseObject((String)pageParamConfig.get(key).toString(), ComponentReference.class);
                    ComponentData paramData = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)componentReference);
                    if (null != paramData) {
                        paramConfig.put(key, paramData.getRenderValue());
                        continue;
                    }
                    paramConfig.put(key, "''");
                }
                params.put("params", optColsFieldMap);
                if (ToolUtil.isNotEmpty(paramConfig)) {
                    StringBuilder paramStr = new StringBuilder();
                    Object[] keySet = paramConfig.keySet().toArray();
                    for (int j = 0; j < keySet.length; ++j) {
                        JSONObject ppcElement = (JSONObject)pageParamConfig.get(keySet[j]);
                        if (j == keySet.length - 1) {
                            if ("input".equals(ppcElement.get((Object)"type")) || "constant".equals(ppcElement.get((Object)"type"))) {
                                paramStr.append(keySet[j] + "=" + paramConfig.get(keySet[j]).toString().replace("'", ""));
                                continue;
                            }
                            paramStr.append(keySet[j] + "=${" + paramConfig.get(keySet[j]) + "}");
                            continue;
                        }
                        if ("input".equals(ppcElement.get((Object)"type")) || "constant".equals(ppcElement.get((Object)"type"))) {
                            paramStr.append(keySet[j] + "=" + paramConfig.get(keySet[j]).toString().replace("'", "") + "&");
                            continue;
                        }
                        paramStr.append(keySet[j] + "=${" + paramConfig.get(keySet[j]) + "}&");
                    }
                    params.put("paramStr", paramStr);
                    params.put("paramConfig", paramConfig);
                }
                if (!ToolUtil.isNotEmpty((Object)(childrenComponentsMap = lcdpComponent.getChildrenComponents()))) continue;
                List childrenComponents = (List)childrenComponentsMap.get("default");
                block4: for (LcdpComponent childrenComponent : childrenComponents) {
                    JSONArray quotes = (JSONArray)childrenComponent.getProps().get("reference");
                    if (!ToolUtil.isNotEmpty((Object)quotes)) continue;
                    for (int i = 0; i < quotes.size(); ++i) {
                        JSONObject quote = quotes.getJSONObject(i);
                        JSONObject componentQuote = quote.getJSONObject("componentQuote");
                        if (!ToolUtil.isNotEmpty((Object)componentQuote)) continue;
                        String instanceKey = componentQuote.getString("instanceKey");
                        JSONArray instanceData = componentQuote.getJSONArray("instanceData");
                        if (!ToolUtil.isNotEmpty((Object)instanceData) || !"item".equals(instanceData.get(0)) || !componentColsAnalysis.getId().equals(instanceData.get(1)) || !lcdpComponent.getInstanceKey().equals(instanceKey)) continue;
                        ArrayList<String> args = new ArrayList<String>();
                        args.add(lcdpComponent.getInstanceKey() + "Item");
                        Trigger trigger = new Trigger("click", args);
                        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
                        triggers.add(trigger);
                        childrenComponent.setTriggers(triggers);
                        ArrayList<String> pageKeyList = new ArrayList<String>();
                        pageKeyList.add("row");
                        ctx.addMethod(childrenComponent.getInstanceKey() + "Click", pageKeyList, RenderUtil.renderTemplate((String)"/template/elementui/element/table/table_hyperlinksMethod.ftl", params));
                        continue block4;
                    }
                }
            }
        }
    }

    private boolean renderSortOverall(LcdpComponent lcdpComponent) {
        boolean isSortOverallFlag = false;
        Boolean isPagination = (Boolean)lcdpComponent.getProps().get("isPagination");
        Boolean isSortOverall = (Boolean)lcdpComponent.getProps().get("isSortOverall");
        if (ToolUtil.isNotEmpty((Object)isSortOverall) && isSortOverall.booleanValue() && ToolUtil.isNotEmpty((Object)isPagination) && isPagination.booleanValue()) {
            lcdpComponent.addRenderParam("isSortChange", (Object)isSortOverall);
            isSortOverallFlag = isSortOverall;
        }
        return isSortOverallFlag;
    }
}

