/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.io.IOException;
import java.util.HashMap;

public class CameraVisitor
implements VoidVisitor<LcdpComponent, Ctx> {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/elementui/element/camera/camera.ftl");
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        String dialogWidth = "";
        String dialogHeight = "";
        String dialogLocation = "";
        Boolean showIcon = (Boolean)lcdpComponent.getProps().get("showIcon");
        if (showIcon.booleanValue()) {
            dialogWidth = lcdpComponent.getProps().get("dialogWidth").toString();
            dialogHeight = lcdpComponent.getProps().get("dialogHeight").toString();
            dialogLocation = lcdpComponent.getProps().get("dialogLocation").toString();
        }
        lcdpComponent.addRenderParam("instanceKey", (Object)lcdpComponent.getInstanceKey());
        lcdpComponent.addRenderParam("dialogWidth", (Object)dialogWidth);
        lcdpComponent.addRenderParam("dialogHeight", (Object)dialogHeight);
        lcdpComponent.addRenderParam("width", (Object)width);
        lcdpComponent.addRenderParam("height", (Object)height);
        lcdpComponent.addRenderParam("dialogLocation", (Object)dialogLocation);
        lcdpComponent.addRenderParam("showIcon", (Object)showIcon);
        this.renderData(lcdpComponent, ctx);
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        String cameraUrl;
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
        Boolean showIcon = (Boolean)lcdpComponent.getRenderParams().get("showIcon");
        if (showIcon.booleanValue()) {
            ctx.addDataCommon(lcdpComponent.getInstanceKey() + "Visible: false");
        }
        if ("".equals(cameraUrl = lcdpComponent.getProps().get("cameraUrl").toString())) {
            ctx.addDataCommon(lcdpComponent.getInstanceKey() + "CameraUrl: ''");
        } else {
            ctx.addDataCommon(lcdpComponent.getInstanceKey() + "CameraUrl: '" + cameraUrl + "'");
        }
        RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)"''");
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        Boolean showIcon = (Boolean)lcdpComponent.getRenderParams().get("showIcon");
        if (showIcon.booleanValue()) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "CameraVisible", RenderUtil.renderTemplate((String)"/template/elementui/element/camera/camera_visible.ftl", params));
        } else {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "CameraHidden", RenderUtil.renderTemplate((String)"/template/elementui/element/camera/camera_hidden.ftl", params));
        }
    }
}

