/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.extend.publish;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.ScriptCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ScriptPublisher;
import com.jxdinfo.hussar.formdesign.elementui.extend.model.ExtendWCssScript;
import com.jxdinfo.hussar.formdesign.elementui.extend.result.CssScriptCodeResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;

@ClientKind(kind="com.jxdinfo.CssScript.extend.publish")
public class CssScriptPublishImpl
implements ScriptPublisher {
    public static final String KIND = "com.jxdinfo.CssScript.extend.publish";
    private static FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
    private static final String CSS_SUFFIX = ".css";

    public void publish(ScriptCtx<CodeResult> scriptCtx) throws LcdpException {
        BaseFile baseFile = scriptCtx.getBaseFile();
        ExtendWCssScript extendWCssScript = (ExtendWCssScript)((Object)JSON.parseObject((String)baseFile.getData(), ExtendWCssScript.class));
        FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
        String modelPath = fileMappingService.getFormatParentPath(baseFile.getId());
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
        String frontProjectPath = pathStrategy.vuePathService().getFrontProjectPath();
        String extendScriptPath = pathStrategy.vuePathService().getExtendScriptPath();
        String rootPath = pathStrategy.vuePathService().getCloudFrontProjectPath(frontProjectPath, new String[]{extendScriptPath});
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
        String path = FileUtil.systemPath((String[])new String[]{rootPath, formDesignProperties.getExtendCssScriptPath(), modelPath, baseFile.getName() + CSS_SUFFIX});
        if (HussarUtils.isNotEmpty((Object)extendWCssScript.getEditorNote())) {
            filePublishService.writeStringToFile(extendWCssScript.getEditorNote(), path, baseFile.getId());
        }
        CssScriptCodeResult cssScriptCodeResult = new CssScriptCodeResult();
        cssScriptCodeResult.setFilePath(path);
        cssScriptCodeResult.setResultType(ResultBeanEnum.CSS_SCRIPT);
        cssScriptCodeResult.setId(baseFile.getId());
        scriptCtx.addGenCodeResults((CodeResult)cssScriptCodeResult);
    }
}

