<#macro conditionList cList>
    <#list cList! as item>
    {
        <#if item.children?? && (item.children?size > 0) >
            children:[
                <@conditionList cList=item.children!></@conditionList>
            ],
        <#else>
        <#list allFields as fieldItem>
            <#if fieldItem.id == item.fromModelField>
                "name": "${fieldItem.name}",
            </#if>
        </#list>
            "symbol": "${item.symbol}",
            "queryAttrName": "${item.queryAttrName!}",
        </#if>
        "match": "${item.connect!}",
    },
    </#list>
</#macro>

const viewMap = {
    <#list allViewMapList! as view>
        "${view.viewId!}": {
            viewType: "${view.viewType!}",
            queryConditionsFields: [
                <#if view.queryConditions?? && view.queryConditions.fields?? && (view.queryConditions.fields?size > 0) >
                <@conditionList cList=view.queryConditions.fields!></@conditionList>
                </#if>
            ],
            queryObj:  {
                ${view.queryAttr!}
            },
        },
    </#list>
};
return viewMap;