
<#list importScriptsList! as imp>
    ${imp}
</#list>
export default {
    components: {
            <#list componentsList as component>
            ${component}
            </#list>
    },
    props: {
    <#list props as prop>
        ${prop.paramName}: ${prop.paramDataType?cap_first},
    </#list>
        },
    data() {
        const self = this;
        return {
            <#if dicts?? && dicts?size gt 0>
                dictOptions: [], // 字典数据
            </#if>
            <#if levelDicts?? && levelDicts?size gt 0>
                levelDictOptions: [], // 多级字典数据
            </#if>
            <#macro generateData data key>
                ${key}, <#if data.comments??> <#list data.comments as comment>// ${comment}</#list> </#if>
            </#macro>
            <#list datas?keys as key>
                <#assign data=datas[key]>
                <#if data?? && (data.annotationKey!"") == "" && (data.commonFlag)>
                    <@generateData data=data key=key />
                </#if>
            </#list>
            <#list annotationComponent! as annotation>
                <#assign hasValid = false>
                <#list datas?keys as key>
                <#assign data=datas[key]>
                <#if data?? && (data.annotationKey!"") == annotation>
                    <#assign hasValid = true>
                    <#break>
                </#if>
            </#list>
            <#if hasValid>
                <#list datas?keys as key>
                <#assign data=datas[key]>
                <#if data?? && (data.annotationKey!"") == annotation>
                    <@generateData data=data key=key />
                </#if>
                </#list>
            </#if>
            </#list>
        }
    },
    computed: {
        <#macro generateComputed computed key>
        <#if computed.comments??>
        /**
         <#list computed.comments as comment>
         * ${comment}
         </#list>
         */
            </#if>
            ${key}(${computed.argBody!}){
            const self = this;
            <#list computed.bodies as body>
            ${body}
            </#list>
        },
        </#macro>
        <#list computeds?keys as key>
            <#assign computed=computeds[key]>
            <#if computed?? && (computed.annotationKey!"") == "" && (computed.commonFlag)>
                <@generateComputed computed=computed key=key />
            </#if>
        </#list>
        <#list annotationComponent! as annotation>
            <#assign hasValid = false>
            <#list computeds?keys as key>
            <#assign computed=computeds[key]>
            <#if computed?? && (computed.annotationKey!"") == annotation>
                <#assign hasValid = true>
                <#break>
            </#if>
        </#list>
        <#if hasValid>
            <#list computeds?keys as key>
            <#assign computed=computeds[key]>
            <#if computed?? && (computed.annotationKey!"") == annotation>
                <@generateComputed computed=computed key=key />
            </#if>
            </#list>
        </#if>
        </#list>

        <#macro generateComputedWithGetSets computed key>
            <#if computed.comments??>
            /**
             <#list computed.comments as comment>
             * ${comment}
             </#list>
             */
                </#if>
                ${key}:{
                <#list computed.bodies as body>
                ${body}
                </#list>
            },
        </#macro>
        <#list computedWithGetSets?keys as key>
            <#assign computed=computedWithGetSets[key]>
            <#if computed?? && (computed.annotationKey!"") == "" && (computed.commonFlag)>
                <@generateComputedWithGetSets computed=computed key=key />
            </#if>
        </#list>
        <#list annotationComponent! as annotation>
            <#assign hasValid = false>
            <#list computedWithGetSets?keys as key>
            <#assign computed=computedWithGetSets[key]>
            <#if computed?? && (computed.annotationKey!"") == annotation>
                <#assign hasValid = true>
                <#break>
            </#if>
        </#list>
        <#if hasValid>
            <#list computedWithGetSets?keys as key>
            <#assign computed=computedWithGetSets[key]>
            <#if computed?? && (computed.annotationKey!"") == annotation>
                <@generateComputedWithGetSets computed=computed key=key />
            </#if>
            </#list>
        </#if>

        </#list>
    },
    watch: {
        <#macro generateWatch watch key>
            <#if (key!?index_of('\'') > -1)>
                <#if watch.comments??>
                /**
                 <#list watch.comments as comment>
                * ${comment}
                 </#list>
                */
                 </#if>
                ${key}:{
                <#list watch.bodies as body>
                ${body}
                </#list>
            },
            <#else>
            <#if watch.comments??>
            /**
             <#list watch.comments as comment>
             * ${comment}
             </#list>
             */
                </#if>
                ${key}(${watch.argBody!}){
                <#list watch.bodies as body>
                ${body}
                </#list>
            },
            </#if>
        </#macro>
        <#list watches?keys as key>
            <#assign watch=watches[key]>
            <#if watch?? && (watch.annotationKey!"") == "">
                <@generateWatch watch=watch key=key />
            </#if>
        </#list>

        <#list annotationComponent! as annotation>
        <#assign hasValid = false>
        <#list watches?keys as key>
            <#assign watch=watches[key]>
            <#if watch?? && (watch.annotationKey!"") == annotation>
                <#assign hasValid = true>
                <#break>
            </#if>
        </#list>
        <#if hasValid>
            <#list watches?keys as key>
            <#assign watch=watches[key]>
            <#if watch?? && (watch.annotationKey!"") == annotation>
                <@generateWatch watch=watch key=key />
            </#if>
            </#list>
        </#if>
        </#list>
    },
    methods: {
        <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
        /**
         * 查询字典数据
         */
        async queryDictOptions_extension() {
            const self = this;
            <#if dicts?? && dicts?size gt 0>
                const queryDictObj = {
                    typeNames: '<#list dicts[0 ..! dicts?size - 1] as dict>${dict},</#list>${dicts[dicts?size - 1]}'
                };
                await dict.${dictMethod}(queryDictObj).then((res) => {
                    if (res.code === 10000 || res.code === 200) {
                        self.dictOptions = res.data;
                        <#list optionLoads as optionLoad>
                            ${optionLoad}
                        </#list>
                    } else {
                        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                    }
                }).catch(function () {
                    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                });
            </#if>
            <#if levelDicts?? && levelDicts?size gt 0>
                const queryLevelDictObj = {
                    typeNames: '<#list levelDicts[0 ..! levelDicts?size - 1] as levelDict>${levelDict},</#list>${levelDicts[levelDicts?size - 1]}'
                };
                await dict.${treeMethod}(queryLevelDictObj).then((res) => {
                    if (res.code === 10000 || res.code === 200) {
                        self.levelDictOptions = res.data;
                        <#list treeLoads as treeLoad>
                            ${treeLoad}
                        </#list>
                    } else {
                        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                    }
                }).catch(function () {
                    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dictionaryDataAbnormal', fallbackStr: '字典数据请求异常'}), 'error');
                });
            </#if>
        },
        </#if>
        <#macro generateMethod method key>
            <#assign importName=key>
            <#if async?? && async?size gt 0>
                <#list async! as async_importName>
                    <#if async_importName == key>
                        <#assign importName=("async " + key)?string>
                    </#if>
                </#list>
            </#if>
            <#if method.comments??>
            /**
             <#list method.comments as comment>
            * ${comment}
             </#list>
             */
            </#if>
            <#if method.notNeedMethodBody??>
                ${importName},
            <#else>
                ${importName}(${method.argBody!}){
                    const self = this;
                    <#list method.bodies![] as body>
                    ${body}
                    </#list>
                },
            </#if>
        </#macro>
        <#list methods?keys as key>
            <#assign method=methods[key]>
            <#if method?? && (method.annotationKey!"") == "" && (method.commonFlag)>
                <@generateMethod method=method key=key />
            </#if>
        </#list>
        <#list annotationComponent! as annotation>
            <#assign hasValid = false>
            <#list methods?keys as key>
            <#assign method = methods[key]>
            <#if method?? && (method.annotationKey!"") == annotation>
                <#assign hasValid = true>
                <#break>
            </#if>
        </#list>
        <#if hasValid>
            <#list methods?keys as key>
            <#assign method=methods[key]>
            <#if method?? && (method.annotationKey!"") == annotation && (method.commonFlag)>
                <@generateMethod method=method key=key />
            </#if>
            </#list>
        </#if>
        </#list>
        /* custom-methods # 二次开发自定义方法代码开始 */
        <#if customMethods??>
            <#list customMethods as method>
                <#if method.methodInfo??>
                <#assign methodInfo=method.methodInfo>
                    <#if methodInfo.methodBody?? && methodInfo.methodBody != "">
                        ${methodInfo.methodBody},
                    </#if>
                </#if>
            </#list>
        </#if>
        /* custom-methods # 二次开发自定义方法代码结束*/
    },
    <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
    async </#if> created() {
        const self = this;
        <#list createdsCommon! as createds>
        ${createds}
        </#list>
        <#if (dicts?? && dicts?size gt 0) || (levelDicts?? && levelDicts?size gt 0)>
        // 查询字典数据
        await self.queryDictOptions_extension();
        </#if>
    },
    beforeDestroy() {
        const self = this;
    },

    filters: {
        <#macro generateFilter filter key>
            <#if filter.comments??>
            /**
             <#list filter.comments as comment>
             * ${comment}
             </#list>
             */
                </#if>
                ${key}(${filter.argBody!}){
                <#list filter.bodies as body>
                ${body}
                </#list>
            },
        </#macro>
        <#list filters?keys as key>
            <#assign filter=filters[key]>
            <#if filter?? && (filter.annotationKey!"") == "">
                <@generateFilter filter=filter key=key />
            </#if>
        </#list>
        <#list annotationComponent! as annotation>
            <#assign hasValid = false>
            <#list filters?keys as key>
            <#assign filter = filters[key]>
                <#if filter?? && (filter.annotationKey!"") == annotation>
                    <#assign hasValid = true>
                    <#break>
            </#if>
            </#list>
            <#if hasValid>
                <#list filters?keys as key>
                <#assign filter = filters[key]>
                <#if filter?? && (filter.annotationKey!"") == annotation>
                    <@generateFilter filter=filter key=key />
                </#if>
                </#list>
            </#if>
        </#list>
    },
    destroyed() {
        const self = this;
        <#list destroyeds! as destroyed>
            ${destroyed}
        </#list>
        <#if pollSwitchMethod>
            <#if destroyPolls?? && (destroyPolls?size>0)>
                <#list destroyPolls! as destroyPoll>
                    clearInterval(self.${destroyPoll});
                </#list>
            </#if>
        </#if>
    },
    activated() {
        const self = this;
        <#list activateds! as activated>
        ${activated}
        </#list>
        <#if isActivated?? && isActivated>
            if(HussarRouter.query(self, 'refresh')){
                self.${rootInstanceKey!}Activated();
            }
        </#if>
    },
    <#-- 重启环境下，实现页面局部刷新 -->
    beforeRouteUpdate(to, from, next){

    },
    deactivated() {
        const self = this;
        <#list deactivateds! as deactivated>
        ${deactivated}
        </#list>
    },

};



