/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.utils.TextAlignForVertical;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.LinkVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class Link
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElLink";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elLink");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover.el-link");
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("padding", "${prefix} {padding:${val}}");
        map.put("fontSize", "${prefix} span{font-size:${val}}");
        map.put("fontFamily", "${prefix} span{font-family:${val}}");
        map.put("fontStyle", "${prefix} span{font-style:${val}}");
        map.put("fontWeight", "${prefix} span{font-weight:${val}}");
        map.put("color", "${prefix} span{color:${val}}");
        map.put("textDecoration", "${prefix} span{text-decoration:${val}}");
        map.put("textAlign", "${prefix} {text-align:${val}}");
        map.put("letterSpacing", "${prefix} span{letter-spacing:${val}}");
        map.put("lineHeight", "${prefix} span{line-height:1.5}${prefix} .el-link--inner{display:flex;align-items:center;width:100%;height:100%}${prefix} .el-link--inner span{width:100%;white-space:nowrap}");
        map.put("itemAlign", "${prefix} > span{align-items:${val};}");
        map.put("itemJustifyContent", "${prefix} > span{justify-content:${val};}");
        map.put("itemDisplay", "${prefix} > span{display:${val};}");
        map.put("spanHeight", "${prefix} > span{height:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        map.put("isShear", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none}";
            }
            return "";
        });
        map.put("isRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {box-shadow: none}";
            }
            return "";
        });
        map.put("isShear", value -> {
            if (ToolUtil.isNotEmpty((Object)value) && ((Boolean)value).booleanValue()) {
                return "${prefix} > span > span {width: 100%;white-space: nowrap;text-overflow: ellipsis;overflow: hidden;}${prefix} {white-space: nowrap;text-overflow: ellipsis;overflow: hidden;}";
            }
            return "${prefix} {overflow: visible;}${prefix} > span > span {overflow: visible;}";
        });
        return (Function)map.get(key);
    }

    public VoidVisitor visitor() {
        return new LinkVoidVisitor();
    }

    public static Link newComponent(JSONObject jsonObject) {
        Link link = (Link)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)Link.class.getName()));
        Object backgroundImg = link.getStyles().get("backgroundImageBack");
        link.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            link.getStyles().put("backgroundImage", backgroundImg);
        }
        String vertical = "vertical";
        boolean isVertical = Boolean.parseBoolean(String.valueOf(link.getStyles().get(vertical)));
        if (link.isVerticalFill() && (link.getStyles().get(vertical) == null || isVertical)) {
            link.getInnerStyles().put("spanHeight", "100%");
        }
        TextAlignForVertical.setTextAlign(link, "innerStyles");
        return link;
    }
}

