<#if instanceKey?? && instanceKey != "">
    <#if primaryFieldName?? && primaryFieldName != "">
        const tableDelete = {
            ids: data.${primaryFieldName!"id"},
        };
        <#if importName != "">
            self.$confirm(self.hussar_t({key: 'vfg.confirmedToDelete', fallbackStr: '确定要删除吗?'}), self.hussar_t({key: 'vfg.notice', fallbackStr: '提示'}), {
                confirmButtonText: self.hussar_t({key: 'vfg.confirm', fallbackStr: '确定'}),
                cancelButtonText: self.hussar_t({key: 'vfg.cancel', fallbackStr: '取消'}),
                type: 'warning'
            }).then(() => {
                const loading = self.$loading({
                    lock: true,
                    text: 'Loading',
                    spinner: 'el-icon-loading',
                    background: 'rgba(0, 0, 0, 0.7)'
                });
                ${importName!}.${importMethod!}(tableDelete).then(res => {
                    if (res) {
                        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.deleteSuccessful', fallbackStr: '删除成功'}), 'success');
                        <#if bodies?? && (bodies?size>0)>
                            <#list bodies as body>
                                ${body}
                            </#list>
                        </#if>
                        if (self.${instanceKey!}ListQuery && self.${instanceKey!}TableTotal === self.${instanceKey!}ListQuery.size *
                                (self.${instanceKey!}ListQuery.current - 1) + 1) {
                            self.${instanceKey!}ListQuery.current--;
                        }
                        self.${instanceKey!}TableLoad();
                    } else {
                        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsFailed', fallbackStr: '表格数据请求失败'}), 'error');
                    }
                    loading.close();
                }).catch(function() {
                    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.TheRequestForTableDataIsAbnormal', fallbackStr: '表格数据请求异常'}), 'error');
                    loading.close();
                })
            }).catch(() => {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.undelete', fallbackStr: '已取消删除'}), 'info');
            });
        <#else>
            ${asyncBodyWithoutData!}
        </#if>
    <#else>
        // 未配置数据模型，生成了空方法体
    </#if>
<#else>
    ${asyncBodyCode!}
</#if>