<#macro colTree colList>
    <#list colList as item>
        tableHead.push({
            "title" : '${item.title?js_string!}',
            "horizontal" : '${item.align!}',
            "colspan" : ${item.colspan!1},
            "rowspan" : ${item.rowspan!1},
            "level" : level
        });
        const ${item.field!}Index = tableField.indexOf('${item.field!}');
        let ${item.field!}Letter = self.${instanceKey!}excelExportForArea(${item.field!}Index);
        <#if item.colComponent! == 'date' && item.selectType.dateFmtSelect??>
            colArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!}',
                "dataType": "date",
                "length": '${item.selectType.dateFmtSelect!}'.length
            });
        <#elseif item.colComponent! == 'number' && item.selectType.numberFmtSelect??>
            colArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!}',
                "dataType": "number",
                "length": '${item.selectType.numberFmtSelect!}'.length
            });
        <#else>
            colArray.push({
                "letter": ${item.field!}Letter,
                "horizontal": '${item.bodyAlign!}',
                "dataType": "string",
                "length": 0
            });
        </#if>
    </#list>
    --level;
</#macro>
<#macro tableHead>
    for (let i = 0; i < tableHead.length; i++){
        if (tableHead[i].rowspan + tableHead[i].level - 1> maxLevel){
            tableHead[i].rowspan = maxLevel - tableHead[i].level + 1;
        }
    }
    let excelCell = [];
    let rows = [];
    for (let i = 0;i < tableField.length; i++){
        for (let j = 0; j < maxLevel; j++){
            let cell = {"xAxis":i,"yAxis":j,isEdit:false};
            excelCell.push(cell);
        }
    }
    for (let i = 0;i < maxLevel; i++){
        let x = 0;
        let row = [];
        for (let j=0;j < tableHead.length; j++){
            let index = excelCell.findIndex(function(value, index, arr) {
                return value.isEdit === false && value.yAxis === i;
            });
            if (index !== -1) {
                x = excelCell.find(function(value, index, arr) {
                    return value.isEdit === false && value.yAxis === i;
                }).xAxis;
            }
            if ( tableHead[j].level - 1 === i){
        let startArea = self.${instanceKey!}excelExportForArea(x) + (1 + i);
        let endArea = self.${instanceKey!}excelExportForArea(x + tableHead[j].colspan - 1) + (tableHead[j].rowspan + i);
        for (let k = x; k < x + tableHead[j].colspan; k++){
                    for (let m = i;m < tableHead[j].rowspan + i; m++){
                        excelCell.find(function(value, index, arr) {
                            return value.xAxis === k && value.yAxis === m;
                        }).isEdit = true;
                    }
                }
                while (row.length < x){
                    row.push("");
                }
                row[x] = tableHead[j].title;
                tableHead[j].merge = startArea + ":" + endArea;
            }
        }
        rows.push(row);
    }
    worksheet.insertRows(1, rows);
    for (let j=0;j < tableHead.length; j++){
        worksheet.mergeCells(tableHead[j].merge);
        worksheet.getCell(tableHead[j].merge.split(":")[0]).alignment = {
            vertical: 'middle',
            horizontal: tableHead[j].horizontal
        };
    }
    for (let i = 0; i < colArray.length; i++){
        for (let j = maxLevel + 1; j < 1000; j++) {
            worksheet.getCell(colArray[i].letter + j).alignment = { horizontal: colArray[i].horizontal };
        if (colArray[i].dataType === "date"){
                let cell = worksheet.getCell(colArray[i].letter+j)
                cell.value = cell.value !== null ? cell.value.substr(0,colArray[i].length) : '';
            }
        }
    }
</#macro>

<#if componentName?? && componentName != "">
    let tableData = [
        <#list tableShowFields! as item>
            <#if (item_index != (tableShowFields?size-1))>
                "${item.title}",
            <#else>
                "${item.title}"
            </#if>
        </#list>
    ];
    let tableField = [
        <#list tableShowFields! as item>
            <#if (item_index != (tableShowFields?size-1))>
                "${item.field}",
            <#else>
                "${item.field}"
            </#if>
        </#list>
    ];
    let columns = [];
    for (let i = 0; i < tableData.length; i++){
        let excelCol = {};
        //excelCol.header = tableData[0][i];
        excelCol.key = tableField[i];
        excelCol.width = 30;
        columns.push(excelCol);
    }
    const Excel = require("exceljs");
    let workbook = new Excel.Workbook();
    let worksheet = workbook.addWorksheet("sheet1");
    const fileName = "data.xlsx";
    workbook.created = new Date();
    workbook.modified = new Date();
    worksheet.columns = columns;

    let dicts = [];
    let relates = [];
    <#if showConfigItemInfos??>
        <#list showConfigItemInfos! as item>
            <#if item.isConfigComplete && item.commonModelType?? >
                let dict${item_index} = [];
                let relate${item_index} = [];
                <#if !item.dictType?? || item.dictType == "">
                    const ${item.importName!}Obj${item_index} = {};
                <#else>
                    const ${item.importName!}Obj${item_index} = {
                    typeName: '${item.dictType}',
                    };
                </#if>
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示字典表
                if (data${item_index} && data${item_index}.length > 0) {
                for (let i = 0; i < data${item_index}.length; i++) {
                dict${item_index}.push({
                field: '${item.tableFieldWhere!}',
                value: data${item_index}[i].value,
                label: data${item_index}[i].label
                });
                }
                relate${item_index}.push({
                tableFieldWhere: '${item.tableFieldWhere!}',
                field: '${item.tableFieldWhere!}'
                });
                }
                } else {
                HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}), 'error');
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            <#elseif item.isConfigComplete>
                const dict${item_index} = [];
                const relate${item_index} = [];
                const ${item.importName!}Obj${item_index} = {
                inValues: '',
                ${item.queryObjectAttr!}
                };
                const res${item_index} = await ${item.importName!}.${item.importMethod!}(${item.importName!}Obj${item_index}).catch(function () {
                self.$message.error(self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}));
                });
                const data${item_index} = res${item_index}.data;
                if ((res${item_index}.code === 200 || res${item_index}.code === 10000) && data${item_index}) {
                // 数据展示数据模型
                if (data${item_index}.data && data${item_index}.data.length > 0) {
                for (let i = 0; i < data${item_index}.data.length; i++) {
                <#list item.mappingRelates! as mapping>
                    dict${item_index}.push({
                    field: '${item.tableFieldWhere!}',
                    value: data${item_index}.data[i].${item.relateTableFieldWhere!},
                    label: data${item_index}.data[i].${mapping.relateField!}
                    });
                </#list>
                }
                <#list item.mappingRelates! as mapping>
                    relate${item_index}.push({
                    tableFieldWhere: '${item.tableFieldWhere!}',
                    field: '${mapping.field!}'
                    });
                </#list>
                }
                } else {
                self.$message.error(self.hussar_t({key: 'vfg.DatadisplayFailed', fallbackStr: '数据展示数据请求失败'}));
                }
                dicts.push({field: '${item.tableFieldWhere!}', dict: dict${item_index}});
                relates.push(relate${item_index});
            </#if>
        </#list>
    </#if>

    <#if importName != "">
    <#if isPagination?? && isPagination>
    const cloneListQyery = Object.assign(
        Object.create(Object.getPrototypeOf(self.${instanceKey!}ListQuery)),
        self.${instanceKey!}ListQuery
    );
    let isClose = true;
    if (self.${instanceKey!}ListQuery.size > 0 && self.${instanceKey!}TableTotal/self.${instanceKey!}ListQuery.size > 1) {
        await self.$confirm(self.hussar_t({key: 'vfg.exportPage', fallbackStr: '请选择导出数据范围？'}), self.hussar_t({key: 'vfg.notice', fallbackStr: '提示'}), {
            distinguishCancelAndClose: true,
            confirmButtonText: self.hussar_t({key: 'noCode-currentPageData', fallbackStr: '当前页数据'}),
            cancelButtonText: self.hussar_t({key: 'noCode-allData', fallbackStr: '全部数据'}),
            type: 'warning'
        }).catch((action) => {
            if(action === 'cancel') {
                cloneListQyery.current = 1;
                cloneListQyery.size = 1000;
            } else {
                isClose = false;
            }
        });
    }
    </#if>
        const ${importName!}Obj = {
    <#--无分页不带分页参数-->
        <#if isPagination?? && isPagination>
        ...cloneListQyery,
        </#if>
        ${queryAttr!}
    };
        <#if isPagination?? && isPagination>
            if(!isClose) return;
        </#if>

    ${importName!}.${importMethod!}(${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data) {
        const convert = [];
        (res.data.data).forEach((item) => {
            convert.push({
                <#assign map=colFields/>
                <#assign keys=map?keys/>
        <#list keys! as key>
            <#assign flag=false/>
            <#if (key_index != (keys?size-1))>
                <#if showConfigItemInfos??>
                    <#list showConfigItemInfos! as item>
                        <#if item.isConfigComplete && item.commonModelType?? >
                            <#if item.tableFieldWhere == key>
                                ${key}: dicts.find(function(dictItem) {
                                return dictItem.field === '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                }) !== undefined ? dicts.find(function(dictItem) {
                                return dictItem.field === '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                }).label : item.${item.tableFieldWhere},
                                <#assign flag=true/>
                            </#if>
                        <#elseif showConfigItemInfos??>
                            <#list item.mappingRelates! as mapping>
                                <#if mapping.field == key>
                                    ${key}: dicts.find(function(dictItem) {
                                    return dictItem.field === '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                    }) !== undefined ? dicts.find(function(dictItem) {
                                    return dictItem.field === '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                    }).label : item.${item.tableFieldWhere},
                                    <#assign flag=true/>
                                </#if>
                            </#list>
                        </#if>
                    </#list>
                </#if>
                <#if flag == false>
                    ${key}: item.${map[key]},
                </#if>
            <#else>
                <#if showConfigItemInfos??>
                    <#list showConfigItemInfos! as item>
                        <#if item.isConfigComplete && item.commonModelType?? >
                            <#if item.tableFieldWhere == key>
                                ${key}: dicts.find(function(dictItem) {
                                return dictItem.field === '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                }) !== undefined ? dicts.find(function(dictItem) {
                                return dictItem.field === '${item.tableFieldWhere}';
                                }).dict.find(function(dictItem) {
                                return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                }).label : item.${item.tableFieldWhere},
                                <#assign flag=true/>
                            </#if>
                        <#elseif showConfigItemInfos??>
                            <#list item.mappingRelates! as mapping>
                                <#if mapping.field == key>
                                    ${key}: dicts.find(function(dictItem) {
                                    return dictItem.field === '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                    }) !== undefined ? dicts.find(function(dictItem) {
                                    return dictItem.field === '${item.tableFieldWhere}';
                                    }).dict.find(function(dictItem) {
                                    return item.${item.tableFieldWhere} === dictItem.value && dictItem.field === '${key}';
                                    }).label : item.${item.tableFieldWhere},
                                    <#assign flag=true/>
                                </#if>
                            </#list>
                        </#if>
                    </#list>
                </#if>
                <#if flag == false>
                    ${key}: item.${map[key]}
                </#if>
            </#if>
        </#list>
    })
    });
        worksheet.insertRows(1, convert);
        let colArray = [];
        let tableHead = [];
        let level = 1;
        let maxLevel = 1;
        <@colTree colList=tableShowFields!></@colTree>
        for (let i = 0; i < tableHead.length; i++){
            if (tableHead[i].level > maxLevel){
                maxLevel = tableHead[i].level;
            }
        }
        <@tableHead></@tableHead>
        workbook.xlsx.writeBuffer().then(function (buffer) {
            saveAs(new Blob([buffer], {
                type: 'application/octet-stream'
            }), fileName);
        });
    } else {
        self.$message.error(self.hussar_t({key: 'vfg.TheRequestForTableDataIsFailed', fallbackStr: '表格数据请求失败'}));
        self.${instanceKey!}TableLoading = false;
    }
    }).catch(function() {
        self.$message.error(self.hussar_t({key: 'vfg.TheRequestForTableDataIsAbnormal', fallbackStr: '表格数据请求异常'}));
        self.${instanceKey!}TableLoading = false;
    })
    <#else>
        worksheet.insertRows(1, ${dataName!});
        let colArray = [];
        let tableHead = [];
        let level = 1;
        <@colTree colList=tableShowFields!></@colTree>
        <@tableHead></@tableHead>
        workbook.xlsx.writeBuffer().then(function (buffer) {
            saveAs(new Blob([buffer], {
                type: 'application/octet-stream'
            }), fileName);
        });
    </#if>
</#if>