/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.provide.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.DataReturnValue;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionProvideVisitor;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.FormQueryAction.value")
public class FormQueryProvideVisitor
implements ActionProvideVisitor<Ctx> {
    private Map<String, Object> params;
    private Ctx ctx;
    private Action action;

    public void visit(Action action, Ctx ctx, Map<String, Object> params) throws LcdpException {
        this.action = action;
        this.ctx = ctx;
        this.params = params;
    }

    public Map<String, String> getDataMapping(DataReturnValue dataReturnValue) throws LcdpException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        DataSModelAnalysis dataModel = this.getDataModel();
        String dataModelId = dataModel.getDataModelId();
        List fields = ModelProvideAdapter.adaptor((String)dataModelId).getFields(dataModelId);
        for (DataModelFieldBase field : fields) {
            mapping.put(field.getId(), field.getName());
        }
        return mapping;
    }

    public ComponentData getReturnValue(DataReturnValue dataReturnValue) throws LcdpException {
        ComponentData componentData = new ComponentData();
        List dataItems = dataReturnValue.getDataItems();
        if (ToolUtil.isEmpty((Object)dataItems)) {
            return componentData;
        }
        DataSModelAnalysis dataModel = this.getDataModel();
        if (ToolUtil.isEmpty((Object)dataModel)) {
            return componentData;
        }
        String dataModelId = dataModel.getDataModelId();
        String instanceKey = ((JSONObject)this.action.getParamValues().get("formQuery")).get((Object)"instanceKey").toString();
        LcdpComponent lcdpComponent = (LcdpComponent)this.ctx.getComponentMap().get(instanceKey);
        StringBuilder dataName = new StringBuilder(128);
        if (ToolUtil.isNotEmpty((Object)lcdpComponent)) {
            ValueVisitor valueVisitor = (ValueVisitor)lcdpComponent.getProvideVisitor("value");
            valueVisitor.visit(lcdpComponent, this.ctx, null);
            dataName = new StringBuilder(valueVisitor.getDataItemValue(null).getRenderValue());
        }
        componentData.setDataType(dataReturnValue.getDataType());
        if (dataItems.size() == 1) {
            componentData.setRenderValue(dataName.toString());
        } else if (dataItems.size() > 1) {
            List fields = ModelProvideAdapter.adaptor((String)dataModelId).getFields(dataModelId);
            Map<String, String> map = fields.stream().collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName, (key1, key2) -> key1));
            for (int index = 0; index < dataItems.size(); ++index) {
                String id = (String)dataItems.get(index);
                if (index <= 1 && ToolUtil.isNotEmpty((Object)map.get(id))) {
                    dataName.append(".").append(map.get(id));
                    continue;
                }
                if (index <= 1) continue;
                dataName.append(".").append(id);
            }
            componentData.setRenderValue(dataName.toString());
        }
        return componentData;
    }

    private DataSModelAnalysis getDataModel() {
        String instanceKey = ((JSONObject)this.action.getParamValues().get("formQuery")).get((Object)"instanceKey").toString();
        LcdpComponent lcdpComponent = (LcdpComponent)this.ctx.getComponentMap().get(instanceKey);
        DataSAnalysis data = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        return data.getDatamodel();
    }
}

