/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.extend.service.impl;

import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.lock.FileLockInfoVo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsCheckVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsFileInfo;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsPathVO;
import com.jxdinfo.hussar.formdesign.extend.model.ExtendJsRelationVO;
import com.jxdinfo.hussar.formdesign.extend.model.RegisterJsScriptFileVO;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendJsCommonService;
import com.jxdinfo.hussar.formdesign.extend.service.ExtendJsService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.FileLockManagerService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@ClientKind(kind="com.jxdinfo.WebPage.extend.js")
public class ExtendJsServiceImpl
implements ExtendJsService {
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class);
    private FormDesignProperties speedCodeProperties = (FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class);
    private FileMappingService fileMappingService = (FileMappingService)SpringContextUtil.getBean(FileMappingService.class);
    private FileLockManagerService lockManagerService = (FileLockManagerService)SpringContextUtil.getBean(FileLockManagerService.class);

    public ApiResponse<List<ExtendJsPathVO>> listJs() throws LcdpException, IOException {
        ExtendJsCommonService extendJsCommonService = (ExtendJsCommonService)SpringContextUtil.getBean(ExtendJsCommonService.class);
        List extendJsPathVos = extendJsCommonService.listJs(this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath(), this.pathStrategy.vuePathService().getFrontProjectPath(), "WebPage");
        return ApiResponse.success((Object)extendJsPathVos);
    }

    public ApiResponse<ExtendJsCheckVO> getErrorForJs(String filePath) throws LcdpException {
        ExtendJsCommonService extendJsCommonService = (ExtendJsCommonService)SpringContextUtil.getBean(ExtendJsCommonService.class);
        ExtendJsCheckVO extendJsCheckVo = extendJsCommonService.getErrorForJs(this.pathStrategy.vuePathService().getFrontProjectPath(), filePath, "WebPage");
        return ApiResponse.success((Object)extendJsCheckVo);
    }

    public ApiResponse<RegisterJsScriptFileVO> listMethod(String filePath, String fileId) throws IOException, LcdpException {
        if (StringUtil.isNotBlank((CharSequence)fileId) && !this.fileMappingService.isFileExist(fileId)) {
            return ApiResponse.fail((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ExtendJsCommonService extendJsCommonService = (ExtendJsCommonService)SpringContextUtil.getBean(ExtendJsCommonService.class);
        if (StringUtil.isEmpty((Object)filePath) && StringUtil.isNotBlank((CharSequence)fileId)) {
            return ApiResponse.success((Object)extendJsCommonService.listMethodByStorage(this.pathStrategy.vuePathService().getFrontProjectPath(), (ExtendJsFileInfo)extendJsCommonService.get(fileId), "WebPage"));
        }
        if (StringUtil.isNotBlank((CharSequence)filePath) && StringUtil.isEmpty((Object)fileId)) {
            return ApiResponse.success((Object)extendJsCommonService.listMethodByPath(this.pathStrategy.vuePathService().getFrontProjectPath(), filePath, "WebPage"));
        }
        if (StringUtil.isNotBlank((CharSequence)filePath) && StringUtil.isNotBlank((CharSequence)fileId)) {
            return ApiResponse.success((Object)extendJsCommonService.listMethodByPathAndStorage(this.pathStrategy.vuePathService().getFrontProjectPath(), filePath, (ExtendJsFileInfo)extendJsCommonService.get(fileId), "WebPage"));
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
    }

    public ApiResponse<FileLockInfoVo> saveJsFile(ExtendJsFileInfo fileInfo) throws IOException, LcdpException {
        ApiResponse response = this.lockManagerService.checkLock(fileInfo.getId(), null);
        if (!response.isSuccess()) {
            return response;
        }
        ExtendJsCommonService extendJsCommonService = (ExtendJsCommonService)SpringContextUtil.getBean(ExtendJsCommonService.class);
        if (this.fileMappingService.isFileExist(fileInfo.getId())) {
            extendJsCommonService.updateFile((BaseFile)fileInfo);
        } else {
            if (extendJsCommonService.checkExists(fileInfo.getFilePath(), "WebPage")) {
                return ApiResponse.fail((String)"\u53c2\u6570\u7f3a\u5931");
            }
            extendJsCommonService.create((BaseFile)fileInfo);
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> getJsContentByPath(String filePath) throws LcdpException {
        if (StringUtil.isEmpty((Object)filePath)) {
            return ApiResponse.fail((IResultCode)ResultCode.NO_EXIST_RESOURCE);
        }
        ExtendJsCommonService extendJsCommonService = (ExtendJsCommonService)SpringContextUtil.getBean(ExtendJsCommonService.class);
        return ApiResponse.success((String)extendJsCommonService.getJsContentByPath(this.pathStrategy.vuePathService().getFrontProjectPath(), filePath, "WebPage"));
    }

    public ApiResponse<List<ExtendJsRelationVO>> getRelation(String fileId, String functionName) {
        ArrayList relationVOList = new ArrayList();
        return ApiResponse.success(relationVOList);
    }
}

