/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.ModifierFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.RejectNodeVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class RejectNode
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElRejectNode";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":not(.is-disabled):hover");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)":not(.is-disabled):focus-within");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)".el-input.is-disabled");
        ModifierFactory.addComponentEventModifier((String)name, (String)"click", (String)"native");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elRejectNode");
    }

    public VoidVisitor visitor() {
        return new RejectNodeVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("backgroundColor", "${prefix} input{background-color:${val};}");
        map.put("backgroundImage", "${prefix} input{background-image:${val};}");
        map.put("backgroundPosition", "${prefix} input{background-position:${val};}");
        map.put("backgroundSize", "${prefix} input{background-size:${val};}");
        map.put("backgroundRepeat", "${prefix} input{background-repeat:${val};}");
        map.put("borderTop", "${prefix} input{border-top:${val};}");
        map.put("borderTopColor", "${prefix} input{border-top-color:${val};}");
        map.put("borderLeft", "${prefix} input{border-left:${val};}");
        map.put("borderLeftColor", "${prefix} input{border-left-color:${val};}");
        map.put("borderRight", "${prefix} input{border-right:${val};}");
        map.put("borderRightColor", "${prefix} input{border-right-color:${val};}");
        map.put("borderBottom", "${prefix} input{border-bottom:${val};}");
        map.put("borderBottomColor", "${prefix} input{border-bottom-color:${val};}");
        map.put("borderRadius", "${prefix} {border-radius:${val};} ${prefix} input{border-radius:${val};}");
        map.put("placeholderColor", "${prefix} input::-webkit-input-placeholder{color:${val};}");
        map.put("placeholderFontSize", "${prefix} input::-webkit-input-placeholder{font-size:${val};}");
        map.put("placeholderTextAlign", "${prefix} input::-webkit-input-placeholder{text-align:${val};}");
        map.put("placeholderFontFamily", "${prefix} input::-webkit-input-placeholder{font-family:${val};}");
        map.put("placeholderFontWeight", "${prefix} input::-webkit-input-placeholder{font-weight:${val};}");
        map.put("placeholderFontStyle", "${prefix} input::-webkit-input-placeholder{font-style:${val};}");
        map.put("placeholderTextDecoration", "${prefix} input::-webkit-input-placeholder{text-decoration:${val};}");
        map.put("placeholderLetterSpacing", "${prefix} input::-webkit-input-placeholder{letter-spacing:${val};}");
        map.put("fontSize", "${prefix} input:not(:placeholder-shown){font-size:${val};}");
        map.put("fontFamily", "${prefix} input:not(:placeholder-shown){font-family:${val};}");
        map.put("color", "${prefix} input:not(:placeholder-shown){color:${val};}");
        map.put("textAlign", "${prefix} input:not(:placeholder-shown){text-align:${val};}");
        map.put("padding", "${prefix} input{padding:${val};}");
        map.put("fontStyle", "${prefix} input:not(:placeholder-shown){font-style:${val};}");
        map.put("letterSpacing", "${prefix} input:not(:placeholder-shown){letter-spacing:${val};}");
        map.put("textDecoration", "${prefix} input:not(:placeholder-shown){text-decoration:${val};}");
        map.put("fontWeight", "${prefix} input:not(:placeholder-shown){font-weight:${val};}");
        map.put("height", "${prefix} input{height: ${val};}");
        map.put("boxShadow", "${prefix} input{box-shadow:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("textAlign", value -> {
            String textAlign = "${prefix} {text-align: ${val};}";
            if (value.equals("left")) {
                return textAlign + "${prefix} {justify-content: flex-start;}";
            }
            if (value.equals("right")) {
                return textAlign + "${prefix} {justify-content: flex-end;}";
            }
            if (value.equals("center")) {
                return textAlign + "${prefix} {justify-content: center;}";
            }
            if (value.equals("justify")) {
                return textAlign + "${prefix} {justify-content: space-between;}";
            }
            return "";
        });
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} input {border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix}, ${prefix} input {border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} input{box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public static RejectNode newComponent(JSONObject jsonObject) {
        RejectNode select = (RejectNode)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)RejectNode.class.getName()));
        Object backgroundImg = select.getInnerStyles().get("backgroundImageBack");
        select.getInnerStyles().remove("backgroundImageBack");
        select.getInnerStyles().put("backgroundImage", backgroundImg);
        return select;
    }
}

