/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.utils.TextAlignForVertical;
import com.jxdinfo.hussar.formdesign.elementui.visitor.element.LabelGroupVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class LabelGroup
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElLabelGroup";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elLabelGroup");
    }

    public VoidVisitor<LcdpComponent, Ctx> visitor() {
        return new LabelGroupVoidVisitor();
    }

    public static LabelGroup newComponent(JSONObject jsonObject) {
        Object isShear;
        LabelGroup labelGroup = (LabelGroup)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)LabelGroup.class.getName()));
        Object backgroundImg = labelGroup.getStyles().get("backgroundImageBack");
        labelGroup.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            labelGroup.getStyles().put("backgroundImage", backgroundImg);
        }
        if (ToolUtil.isNotEmpty(isShear = labelGroup.getProps().get("isShear")) && ((Boolean)isShear).booleanValue()) {
            labelGroup.getStyles().put("whiteSpace", "nowrap");
            labelGroup.getStyles().put("textOverflow", "ellipsis");
            labelGroup.getStyles().put("overflow", "hidden");
        }
        TextAlignForVertical.setTextAlign(labelGroup, "styles");
        labelGroup.getInnerStyles().put("required", "red");
        return labelGroup;
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("wordBreak", "${prefix} span{word-break:${val};}");
        map.put("spanPadding", "${prefix} .label-group_label{padding: ${val}; display: inline-block; align-items: center;}");
        map.put("spanMarginPadding", "${prefix} .label-group_outside_div{margin: ${val}; display: inline-block;}");
        map.put("borderTop", "${prefix} .label-group_label{border-top: ${val};}");
        map.put("borderTopColor", "${prefix} .label-group_label{border-top-color: ${val};}");
        map.put("borderLeft", "${prefix} .label-group_label{border-left: ${val};}");
        map.put("borderLeftColor", "${prefix} .label-group_label{border-left-color: ${val};}");
        map.put("borderBottom", "${prefix} .label-group_label{border-bottom: ${val};}");
        map.put("borderBottomColor", "${prefix} .label-group_label{border-bottom-color: ${val};}");
        map.put("borderRight", "${prefix} .label-group_label{border-right: ${val};}");
        map.put("borderRightColor", "${prefix} .label-group_label{border-right-color: ${val};}");
        map.put("borderRadius", "${prefix} .label-group_label{border-radius: ${val};}");
        map.put("spanBackgroundColor", "${prefix} .label-group_label{background-color: ${val};}");
        map.put("textAlign", "${prefix} .label-group_label{text-align: ${val};}; ${prefix}{text-align: ${val};}");
        map.put("boxShadow", "${prefix} .label-group_label{box-shadow: ${val};}");
        map.put("color", "${prefix} .label-group_text{color: ${val}; display: inline-block; overflow: hidden; vertical-align: middle;}");
        map.put("fontSize", "${prefix} .label-group_text{font-size: ${val}; line-height: ${val};}");
        map.put("fontWeight", "${prefix} .label-group_text{font-weight: ${val};}");
        map.put("fontStyle", "${prefix} .label-group_text{font-style: ${val};}");
        map.put("textDecoration", "${prefix} .label-group_text{text-decoration: ${val};}");
        map.put("letterSpacing", "${prefix} .label-group_text{letter-spacing: ${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} .label-group_label{border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} .label-group_label{border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} .label-group_label{box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }
}

