/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HViewsVoidVisitor
implements VoidVisitor<LcdpComponent, Ctx> {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String relatedKey = (String)lcdpComponent.getProps().get("relatedKey");
        LcdpComponent tableComponent = null;
        if (ToolUtil.isNotEmpty((Object)relatedKey)) {
            lcdpComponent.addRenderParam("relatedKey", (Object)relatedKey);
            tableComponent = (LcdpComponent)ctx.getComponentMap().get(relatedKey);
        }
        lcdpComponent.addRenderParam("pageId", (Object)ctx.getPageInfo().getId());
        lcdpComponent.registerTemplatePath("/template/elementui/element/hViews/hViews.ftl");
        MultilineExegesisUtil.handleExegesisText((LcdpComponent)lcdpComponent, (String)"exegesis", (String)"exegesisResult");
        Map dataParams = lcdpComponent.getRenderParamsToBind();
        if (ToolUtil.isNotEmpty((Object)tableComponent)) {
            dataParams.put("tableParams", tableComponent.getRenderParamsToBind());
            this.renderViewFilterMap(lcdpComponent, ctx, dataParams, tableComponent);
            this.renderViewConfig(lcdpComponent, ctx, dataParams, tableComponent);
            this.renderMethods(lcdpComponent, ctx, dataParams, tableComponent);
        }
        this.renderAttrs(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderViewConfig(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams, LcdpComponent tableComponent) throws LcdpException {
        JSONArray optColsJSONObject = (JSONArray)tableComponent.getProps().get("opt_cols");
        JSONArray allCols = this.getAllColumns(optColsJSONObject);
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)tableComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        HashMap<String, List<DataSFieldAnalysis>> fields = new HashMap();
        String dataModelId = "";
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            fields = dataSModelAnalysis.getFields();
            dataModelId = dataSModelAnalysis.getDataModelId();
        }
        ctx.addComputed("appId", RenderUtil.renderTemplate((String)"/template/elementui/element/hViews/appId.ftl", new HashMap()), true, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
        if (ToolUtil.isNotEmpty((Object)tableComponent)) {
            ctx.addComputed(tableComponent.getInstanceKey() + "ConfigBySelectedView", RenderUtil.renderTemplate((String)"/template/elementui/element/hViews/tableConfigBySelectedView.ftl", dataParams), true, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
        }
        this.renderSortableFields(fields, allCols, dataParams, dataModelId);
        this.renderColumnFields(fields, dataParams, tableComponent);
        this.renderCustomFilterFields(fields, allCols, dataParams, dataModelId);
        ctx.addData(RenderUtil.renderTemplate((String)"/template/elementui/element/hViews/viewConfig.ftl", dataParams));
    }

    private void renderSortableFields(Map<String, List<DataSFieldAnalysis>> fields, JSONArray cols, Map<String, Object> dataParams, String dataModelId) {
        ArrayList sortableFields = new ArrayList();
        for (Object obj : cols) {
            JSONObject col = (JSONObject)obj;
            String field = col.getString("auth");
            String reflectionField = DataModelUtil.getSourceFieldName((String)dataModelId, (String)field);
            if (!ToolUtil.isNotEmpty((Object)field) || !ToolUtil.isEmpty((Object)reflectionField)) continue;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("name", field);
            params.put("title", col.getString("title"));
            params.put("titleType", col.getString("titleType"));
            String type = "string";
            if (Arrays.asList("long", "int", "double").contains(col.getString("dataType"))) {
                type = "number";
            } else if (Arrays.asList("date").contains(col.getString("dataType"))) {
                type = "date";
            }
            params.put("type", type);
            sortableFields.add(params);
        }
        dataParams.put("sortableFields", sortableFields);
    }

    private void renderColumnFields(Map<String, List<DataSFieldAnalysis>> fields, Map<String, Object> dataParams, LcdpComponent tableComponent) {
        ArrayList columnFields = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)tableComponent)) {
            JSONArray cols = (JSONArray)tableComponent.getProps().get("opt_cols");
            for (Object obj : cols) {
                JSONObject col = (JSONObject)obj;
                String field = col.getString("field");
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (ToolUtil.isEmpty((Object)field)) {
                    field = col.getString("id");
                }
                params.put("name", field);
                params.put("title", col.getString("title"));
                if (col.get((Object)"titleType") != null && col.get((Object)"titleType").getClass() == String.class) {
                    params.put("title", (String)col.get((Object)"title"));
                    params.put("titleType", col.get((Object)"titleType"));
                } else if (col.get((Object)"title") != null && col.get((Object)"title").getClass() == String.class) {
                    params.put("title", (String)col.get((Object)"title"));
                    params.put("titleType", "string");
                } else {
                    JSONObject title = (JSONObject)col.get((Object)"title");
                    if (title.get((Object)"international").equals(true)) {
                        params.put("title", "hussar_t({key: '" + ((JSONObject)col.get((Object)"title")).get((Object)"internationalCode") + "', fallbackStr: '" + ((JSONObject)col.get((Object)"title")).get((Object)"name") + "'})");
                        params.put("titleType", "object");
                    } else {
                        params.put("title", ((JSONObject)col.get((Object)"title")).get((Object)"name"));
                        params.put("titleType", "newString");
                    }
                }
                columnFields.add(params);
            }
        }
        dataParams.put("columnFields", columnFields);
    }

    private void renderCustomFilterFields(Map<String, List<DataSFieldAnalysis>> fields, JSONArray cols, Map<String, Object> dataParams, String dataModelId) {
        ArrayList customFilterFields = new ArrayList();
        for (Object obj : cols) {
            JSONObject col = (JSONObject)obj;
            Boolean filter = col.getBoolean("filter");
            String field = col.getString("auth");
            if (!ToolUtil.isNotEmpty((Object)filter) || !filter.booleanValue() || !ToolUtil.isNotEmpty((Object)field)) continue;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (ToolUtil.isNotEmpty((Object)col.get((Object)"titleType")) && col.get((Object)"titleType").equals("object")) {
                params.put("title", col.get((Object)"title"));
            } else {
                params.put("title", col.getString("title"));
            }
            params.put("titleType", col.getString("titleType"));
            String colFieldValue = col.getString("field");
            params.put("name", colFieldValue);
            customFilterFields.add(params);
        }
        dataParams.put("customFilterFields", customFilterFields);
    }

    private void renderMethods(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams, LcdpComponent tableComponent) throws LcdpException {
        ctx.addImports("setTableByViewConfig", "@/pages/index/utils/lowcode/viewUtil");
        ctx.addImports("setViewFilters", "@/pages/index/utils/lowcode/viewUtil");
        ArrayList<String> params = new ArrayList<String>();
        params.add("view");
        params.add("allViewConf");
        ctx.addAsyncMethod(lcdpComponent.getInstanceKey() + "UpdateView", params, RenderUtil.renderTemplate((String)"template/elementui/element/hViews/changeViewMethod.ftl", dataParams));
    }

    private void renderViewFilterMap(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> dataParams, LcdpComponent tableComponent) throws LcdpException {
        String relatedKey = (String)dataParams.get("relatedKey");
        if (ToolUtil.isNotEmpty((Object)relatedKey)) {
            JSONArray views = (JSONArray)lcdpComponent.getProps().get("views");
            JSONArray allViewMapList = new JSONArray();
            JSONObject dataModel = (JSONObject)tableComponent.getDatas().get("datamodel");
            if (ToolUtil.isNotEmpty((Object)dataModel)) {
                String modelId = (String)dataModel.get((Object)"dataModelId");
                dataParams.put("dataModelId", modelId);
                for (Object view : views) {
                    HashMap<String, Object> viewMap = new HashMap<String, Object>();
                    JSONObject viewObj = (JSONObject)view;
                    viewMap.put("viewType", ((JSONObject)view).get((Object)"viewType"));
                    viewMap.put("viewId", ((JSONObject)view).get((Object)"viewId"));
                    JSONObject tableConf = (JSONObject)((JSONArray)viewObj.get((Object)"configs")).get(0);
                    Object viewDataModel = tableConf.get((Object)"datamodel");
                    if (!ToolUtil.isNotEmpty((Object)modelId)) continue;
                    DataSModelAnalysis dataSModelAnalysis = (DataSModelAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)viewDataModel), DataSModelAnalysis.class);
                    DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                    List conditionList = dataSConditionAnalysis.getQueryConditionModelList();
                    List paramConfigs = dataSModelAnalysis.getParamValue();
                    StringBuilder queryAttr = QueryAttrUtil.getDataSetQueryAttr((List)conditionList, (List)paramConfigs, (Ctx)ctx, (String)modelId);
                    viewMap.put("queryAttr", queryAttr);
                    String querySelectionName = dataSConditionAnalysis.getSelectCondition();
                    if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                        Map queryConditions = DataModelUtil.getQueryConditionByModelIDAndName((String)modelId, (String)querySelectionName);
                        viewMap.put("queryConditions", queryConditions);
                    }
                    List allFields = ModelProvideAdapter.adaptor((String)modelId).getFields(modelId);
                    dataParams.put("allFields", allFields);
                    allViewMapList.add(viewMap);
                }
                dataParams.put("allViewMapList", allViewMapList);
                ArrayList params = new ArrayList();
                ctx.addMethod(lcdpComponent.getInstanceKey() + tableComponent.getInstanceKey() + "GetViewFilterMap", params, RenderUtil.renderTemplate((String)"template/elementui/element/hViews/getViewFilterMap.ftl", dataParams));
            }
        }
    }

    private JSONArray getAllColumns(JSONArray cols) {
        JSONArray allColumns = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)cols)) {
            for (Object col : cols) {
                JSONObject colObj = (JSONObject)col;
                if (Boolean.TRUE.equals(colObj.getBoolean("isParent"))) {
                    JSONArray allChildCols = this.getAllColumns(colObj.getJSONArray("children"));
                    for (Object childCol : allChildCols) {
                        JSONObject childColObj = (JSONObject)childCol;
                        allColumns.add((Object)childColObj);
                    }
                    continue;
                }
                JSONObject colConf = new JSONObject();
                String field = colObj.getString("field");
                colConf.put("field", (Object)field);
                Boolean filter = colObj.getBoolean("filter");
                colConf.put("filter", (Object)filter);
                String dataType = colObj.getString("dataType");
                colConf.put("dataType", (Object)dataType);
                String auth = colObj.getString("auth");
                colConf.put("auth", (Object)auth);
                Object colObjTitleType = colObj.get((Object)"titleType");
                if (ToolUtil.isNotEmpty((Object)colObjTitleType)) {
                    colConf.put("title", (Object)((String)colObj.get((Object)"title")));
                    colConf.put("titleType", (Object)((String)colObjTitleType));
                } else if (colObj.get((Object)"title") != null && colObj.get((Object)"title").getClass() == String.class) {
                    colConf.put("title", (Object)((String)colObj.get((Object)"title")));
                    colConf.put("titleType", (Object)"string");
                } else {
                    JSONObject title = (JSONObject)colObj.get((Object)"title");
                    if (title.get((Object)"international").equals(true)) {
                        colConf.put("title", (Object)("hussar_t({key: '" + ((JSONObject)colObj.get((Object)"title")).get((Object)"internationalCode") + "', fallbackStr: '" + ((JSONObject)colObj.get((Object)"title")).get((Object)"name") + "'})"));
                        colConf.put("titleType", (Object)"object");
                    } else {
                        colConf.put("title", ((JSONObject)colObj.get((Object)"title")).get((Object)"name"));
                        colConf.put("titleType", (Object)"newString");
                    }
                }
                allColumns.add((Object)colConf);
            }
        }
        return allColumns;
    }
}

