/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.cascade;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.io.Files;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.scenes.model.FormDesignScenes;
import com.jxdinfo.hussar.formdesign.common.service.ResourceCascadeService;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ResourceCascadeVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

@ClientKind(kind="com.jxdinfo.Workflow.cascade")
public class WorkflowCascadeImpl
implements ResourceCascadeVisitor {
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    public static final String KIND = "com.jxdinfo.Workflow.cascade";
    private final PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    private final ResourceCascadeService resourceCascadeService = (ResourceCascadeService)SpringContextHolder.getBean(ResourceCascadeService.class);

    public void cascadeEdit(BaseFile baseFile) throws LcdpException {
    }

    public void cascadeCopy(String id, String newId, String newName, String parentPath) throws LcdpException, IOException {
    }

    public void cascadeMove(String id, String newName, String parentId) throws LcdpException, IOException {
        String rootPath = FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().getProjectAndCodePath()});
        String parentPath = this.getMetaPath(parentId);
        try {
            String eName;
            FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
            if (HussarUtils.equals((Object)FormDesignScenes.DATABASE, (Object)formDesignProperties.getScenes())) {
                SysMidFileCodeService sysMidFileCodeService = (SysMidFileCodeService)SpringContextHolder.getBean(SysMidFileCodeService.class);
                SysMidFileCode metaFile = sysMidFileCodeService.getMetaFile(id);
                eName = metaFile.getName();
            } else {
                WorkflowInfo workflowInfo = (WorkflowInfo)JSON.parseObject((String)FileUtils.readFileToString((File)new File(this.relativeToAbsolute(this.fileMappingService.getDataPath(id) + ".meta", rootPath)), (String)"UTF-8"), WorkflowInfo.class);
                eName = workflowInfo.geteName();
            }
            this.resourceCascadeService.deleteWorkFlowPublishFile(eName);
            String workFlowName = eName.split(":")[0].replace("_", "");
            String saveJavaFilePathPrefix = this.pathStrategy.javaPathService().backProjectJava(new String[]{"bpmvisitor", this.fileMappingService.getFormatParentPath(id), workFlowName}).getLocalPath().toLowerCase();
            String bpmToPath = this.pathStrategy.javaPathService().backProjectJava(new String[]{"bpmvisitor", parentPath}).getLocalPath().toLowerCase();
            File bpmFrom = new File(saveJavaFilePathPrefix);
            File bpmTo = new File(bpmToPath);
            if (FileUtils.exists((File)bpmFrom)) {
                if (!FileUtils.exists((File)bpmTo)) {
                    FileUtils.forceMkdir((File)bpmTo);
                }
                if (!workFlowName.isEmpty()) {
                    bpmTo = new File(bpmToPath + File.separator + workFlowName);
                    if (!FileUtils.exists((File)bpmTo)) {
                        FileUtils.moveDirectory((File)bpmFrom, (File)bpmTo);
                    } else {
                        FileUtils.moveDirectoryToDirectory((File)bpmFrom, (File)bpmTo, (boolean)false);
                    }
                    this.iteratorFile(bpmTo, this.fileMappingService.getFormatParentPath(id), parentPath);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void iteratorFile(File file, String oldName, String newName) throws IOException {
        if (FileUtils.exists((File)file)) {
            if (FileUtils.isDirectory((File)file)) {
                File[] files = FileUtils.listFiles((File)file);
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, oldName, newName);
                    }
                }
            } else {
                List lines = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
                String packagePath = (String)lines.get(0);
                lines.remove(0);
                lines.add(0, packagePath.replace(".bpmvisitor" + oldName.replace("/", ".").replace("\\", ".").replace("//", ".").replace("\\\\", "."), ".bpmvisitor" + newName.replace("/", ".").replace("\\", ".").replace("//", ".").replace("\\\\", ".")));
                System.out.println((String)lines.get(0));
                FileOutputStream outputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
                BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                for (String line : lines) {
                    bufferedWriter.write(line + "\r\n");
                }
                bufferedWriter.close();
                outputStreamWriter.close();
                outputStream.close();
            }
        }
    }

    public void cascadeDelete(String id) throws LcdpException, IOException {
        String eName;
        FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
        if (HussarUtils.equals((Object)FormDesignScenes.DATABASE, (Object)formDesignProperties.getScenes())) {
            SysMidFileCodeService sysMidFileCodeService = (SysMidFileCodeService)SpringContextHolder.getBean(SysMidFileCodeService.class);
            SysMidFileCode metaFile = sysMidFileCodeService.getMetaFile(id);
            eName = metaFile.getName();
        } else {
            String rootPath = FileUtil.posixPath((String[])new String[]{this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath()});
            WorkflowInfo workflowInfo = (WorkflowInfo)JSONObject.parseObject((String)FileUtils.readFileToString((File)new File(this.relativeToAbsolute(this.fileMappingService.getDataPath(id) + ".meta", rootPath)), (String)"UTF-8"), WorkflowInfo.class);
            eName = workflowInfo.geteName();
        }
        this.resourceCascadeService.deleteWorkFlowPublishFile(eName);
        String workFlowName = eName.split(":")[0].replace("_", "");
        String saveJavaFilePathPrefix = this.pathStrategy.javaPathService().backProjectJava(new String[]{"bpmvisitor", this.fileMappingService.getFormatParentPath(id), workFlowName}).getLocalPath().toLowerCase();
        if (FileUtils.exists((File)new File(saveJavaFilePathPrefix))) {
            FileUtils.forceDelete((File)new File(saveJavaFilePathPrefix));
        }
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String getMetaPath(String id) throws LcdpException, IOException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath).replace(".meta", "");
    }
}

