/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.event;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.TableFieldUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.SortTableOverallAction")
public class SortTableOverall
implements ActionVisitor {
    public void visitor(Action action, Ctx ctx) throws Exception {
        LcdpComponent tableComponent;
        Map params = action.getParamValues();
        String dataTableId = "";
        JSONObject tableQueryObj = (JSONObject)params.get("sortTableOverall");
        if (ToolUtil.isNotEmpty((Object)tableQueryObj)) {
            dataTableId = tableQueryObj.getString("instanceKey");
        }
        if (ToolUtil.isNotEmpty((Object)(tableComponent = (LcdpComponent)ctx.getComponentMap().get(dataTableId)))) {
            boolean isOpenSortOverall = false;
            if (ToolUtil.isNotEmpty(tableComponent.getProps().get("isSortOverall"))) {
                isOpenSortOverall = (Boolean)tableComponent.getProps().get("isSortOverall");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            RenderCore renderCore = new RenderCore();
            renderCore.registerTemplatePath("template/elementui/event/SortTableOverall/SortTableOverall.ftl");
            LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
            String trigger = action.getTrigger();
            String triggerName = myLcdpComponent.getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
            map.put("trigger", triggerName);
            map.put("tableInstanceKey", dataTableId);
            ArrayList<String> colType = new ArrayList<String>(2);
            colType.add("opt_cols");
            List colsList = TableFieldUtil.getRealAllTableFieldList(colType, (LcdpComponent)tableComponent);
            String fieldList = this.dealFieldList(colsList, isOpenSortOverall);
            ctx.addImports("import SortTableOverall from '@/components/SortTableOverall/index'");
            ctx.addComponent("SortTableOverall");
            ctx.addData(dataTableId + "IsDialogShow: false", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)tableComponent, (String)"\u5f39\u7a97\u663e\u793a\u5c5e\u6027"));
            ctx.addData(dataTableId + "FieldList: " + fieldList, MultilineExegesisUtil.dealDataExegesis((LcdpComponent)tableComponent, (String)"fieldList\u5c5e\u6027"));
            ctx.addData(dataTableId + "SortOrders: {}", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)tableComponent, (String)"\u6392\u5e8f\u5c5e\u6027"));
            renderCore.registerParam(map);
            RenderResult renderResult = renderCore.render();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("tableInstanceKey", dataTableId);
            resultMap.put("isOpenSortOverall", isOpenSortOverall);
            ArrayList<String> paramForEmit = new ArrayList<String>();
            paramForEmit.add("val");
            ctx.addMethodCommon(dataTableId + "SortTable", paramForEmit, RenderUtil.renderTemplate((String)"template/elementui/event/SortTableOverall/SortTableOverallForEmit.ftl", resultMap));
            HashMap<String, String> componentParam = new HashMap<String, String>();
            componentParam.put("tableInstanceKey", dataTableId);
            String template = RenderUtil.renderTemplate((String)"template/elementui/event/SortTableOverall/SortTableOverallTemplate.ftl", componentParam);
            tableComponent.addRenderParam("hasSortTableOverall", (Object)template);
            if (renderResult.isStatus()) {
                ctx.addMethodCommon(trigger, triggerName, renderResult.getRenderString());
            }
        }
    }

    private String dealFieldList(List<TableOptColsAnalysis> colList, boolean isOpenSortOverall) {
        if (isOpenSortOverall) {
            StringBuilder stringBuffer = new StringBuilder();
            String start = "[";
            String end = "]";
            stringBuffer.append(start);
            for (TableOptColsAnalysis tableCol : colList) {
                if (!ToolUtil.isNotEmpty((Object)tableCol.isSort()) || !tableCol.isSort()) continue;
                String objStart = "{";
                String title = "label: '" + tableCol.getTitle() + "',";
                String field = "value: '" + tableCol.getField() + "',";
                String objEnd = "},";
                String result = objStart + title + field + objEnd;
                stringBuffer.append(result);
            }
            stringBuffer.append(end);
            return stringBuffer.toString();
        }
        return "[]";
    }
}

