/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.elementui.visitor.analysismodel.FaultMapDataSAnalysis;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FaultMapEchartsVisitor
implements VoidVisitor<LcdpComponent, Ctx> {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/elementui/element/FaultMapEcharts/el_faultMapEcharts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx);
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, String> instanceKey = new HashMap<String, String>();
        instanceKey.put("instanceKey", lcdpComponent.getInstanceKey());
        if (lcdpComponent.isVerticalFill() || lcdpComponent.isHorizontalFill()) {
            ctx.addMounted(RenderUtil.renderTemplate((String)"/template/elementui/element/eChartsResize/echarts_resize.ftl", instanceKey));
        }
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) {
        String instanceKey = lcdpComponent.getInstanceKey();
        ctx.addDataCommon(instanceKey + "EchartsData: null", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"echartsData\u5c5e\u6027"));
        ctx.addDataCommon(instanceKey + "OptionData: []", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"optionData\u5c5e\u6027"));
        ctx.addDataCommon(instanceKey + "Data: {\npointData:[],\nlineData:[],\nerrorPointData:[],\nrushPointData:[]}", MultilineExegesisUtil.dealDataExegesis((LcdpComponent)lcdpComponent, (String)"data\u53d8\u91cf"));
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        ctx.addComputed(lcdpComponent.getInstanceKey() + "OptionData", RenderUtil.renderTemplate((String)"template/elementui/element/FaultMapEcharts/optionData.ftl", params), false, MultilineExegesisUtil.dealComputedExegesis((LcdpComponent)lcdpComponent));
        Map maps = lcdpComponent.getProps();
        if (ToolUtil.isNotEmpty((Object)maps)) {
            this.setParamValue(params, maps);
            this.setFaultMapQuery(lcdpComponent, ctx);
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addMethod(lcdpComponent.getInstanceKey() + "FaultMapLoad", RenderUtil.renderTemplate((String)"template/elementui/element/FaultMapEcharts/el_faultMapEcharts_Success.ftl", params));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "FaultMapLoad();");
        }
    }

    private void setParamValue(Map<String, Object> params, Map<String, Object> maps) {
        params.put("titleText", maps.get("title"));
        params.put("titleColor", ToolUtil.isNotEmpty((Object)maps.get("titleColor")) ? maps.get("titleColor") : "#000");
        params.put("titleFontSize", ToolUtil.isNotEmpty((Object)maps.get("titleFontSize")) ? maps.get("titleFontSize") : "18");
        params.put("fontFamily", maps.get("fontFamily"));
        params.put("fontWeight", maps.get("fontWeight"));
        params.put("titleAlign", maps.get("titleAlign"));
        params.put("titleVerticalAlign", maps.get("titleVerticalAlign"));
        params.put("titleLeft", maps.get("titleLeft"));
        params.put("titleTop", maps.get("titleTop"));
        params.put("titleBackgroundColor", ToolUtil.isNotEmpty((Object)maps.get("titleBackgroundColor")) ? maps.get("titleBackgroundColor") : "transparent");
        params.put("tooltipBgColor", maps.get("tooltipBgColor"));
        params.put("toolColor", ToolUtil.isNotEmpty((Object)maps.get("toolColor")) ? maps.get("toolColor") : "#666");
        params.put("toolFontSize", ToolUtil.isNotEmpty((Object)maps.get("toolFontSize")) ? maps.get("toolFontSize") : "12");
        params.put("toolFontFamily", maps.get("toolFontFamily"));
        params.put("toolFontWeight", maps.get("toolFontWeight"));
        params.put("toolFontStyle", maps.get("toolFontStyle"));
        params.put("toolLineHeight", maps.get("toolLineHeight"));
        params.put("toolShow", Optional.ofNullable(maps.get("toolShow")).orElse(false));
        params.put("toolPaddingTop", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingTop")) ? maps.get("toolPaddingTop") : "10");
        params.put("toolPaddingLeft", ToolUtil.isNotEmpty((Object)maps.get("toolPaddingLeft")) ? maps.get("toolPaddingLeft") : "10");
        params.put("toolShadow", maps.get("toolShadow"));
        params.put("isShowFlag", Optional.ofNullable(maps.get("isShowFlag")).orElse(false));
        params.put("legendLocation", ToolUtil.isNotEmpty((Object)maps.get("legendLocation")) ? maps.get("legendLocation") : "center");
        params.put("legendColor", ToolUtil.isNotEmpty((Object)maps.get("legendColor")) ? maps.get("legendColor") : "#999999");
        params.put("legendFontSize", ToolUtil.isNotEmpty((Object)maps.get("legendFontSize")) ? maps.get("legendFontSize") : "16");
        params.put("legendFontFamily", maps.get("legendFontFamily"));
        params.put("legendFontWeight", maps.get("legendFontWeight"));
        params.put("legendFontStyle", maps.get("legendFontStyle"));
        params.put("itemWidth", Optional.ofNullable(maps.get("itemWidth")).orElse(22));
        params.put("itemHeight", Optional.ofNullable(maps.get("itemHeight")).orElse(10));
        params.put("itemGap", Optional.ofNullable(maps.get("itemGap")).orElse(20));
        params.put("itemOrient", ToolUtil.isNotEmpty((Object)maps.get("itemOrient")) ? maps.get("itemOrient") : "horizontal");
        params.put("itemIcon", maps.get("itemIcon"));
        params.put("itemInactiveColor", maps.get("itemInactiveColor"));
        params.put("labelShow", Optional.ofNullable(maps.get("labelShow")).orElse(false));
        params.put("labelColor", maps.get("labelColor"));
        params.put("labelFontSize", ToolUtil.isNotEmpty((Object)maps.get("labelFontSize")) ? maps.get("labelFontSize") : "14");
        params.put("labelFontWeight", maps.get("labelFontWeight"));
        params.put("labelFontFamily", maps.get("labelFontFamily"));
        params.put("symbolSize", Optional.ofNullable(maps.get("symbolSize")).orElse(18));
        params.put("symbolIcon", maps.get("symbolIcon"));
        Map tempMap = (Map)maps.get("symbolIcon");
        params.put("imgRelativePath", tempMap.get("imgRelativePath"));
        params.put("imgForSelect", tempMap.get("imgForSelect"));
        params.put("areaColor", Optional.ofNullable(maps.get("areaColor")).orElse("#409EFF"));
        params.put("areaBorderColor", Optional.ofNullable(maps.get("areaBorderColor")).orElse("#FFFFFF"));
        params.put("areaBorderWidth", Optional.ofNullable(maps.get("areaBorderWidth")).orElse(1));
        params.put("areaEmphasisColor", maps.get("areaEmphasisColor"));
        params.put("effectScatter", Optional.ofNullable(maps.get("effectScatter")).orElse(false));
        params.put("shadowColor", maps.get("shadowColor"));
        params.put("shadowBlur", maps.get("shadowBlur"));
        params.put("markerColor", maps.get("markerColor"));
        params.put("currentProvince", maps.get("currentProvince"));
        params.put("currentProvinceName", maps.get("currentProvinceName"));
        params.put("currentCity", maps.get("currentCity"));
        params.put("topicColorStr", maps.get("topicColor").toString());
    }

    private void setFaultMapQuery(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        FaultMapDataSAnalysis datasAnalysis = (FaultMapDataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), FaultMapDataSAnalysis.class);
        DataSModelAnalysis pointDataModel = datasAnalysis.getPointModel();
        DataSModelAnalysis lineDataModel = datasAnalysis.getLineModel();
        DataSModelAnalysis errorPointDataModel = datasAnalysis.getShowPointModel();
        if (ToolUtil.isNotEmpty((Object)pointDataModel) && ToolUtil.isNotEmpty((Object)lineDataModel)) {
            this.setPointQuery(pointDataModel, lcdpComponent, ctx);
            this.setLineQuery(lineDataModel, lcdpComponent, ctx);
        } else {
            this.addEmptyPointQuery(lcdpComponent, ctx);
            this.addEmptyLineQuery(lcdpComponent, ctx);
        }
        if (ToolUtil.isNotEmpty((Object)errorPointDataModel)) {
            this.setShowPointQuery(errorPointDataModel, lcdpComponent, ctx);
        } else {
            this.addEmptyShowPointQuery(lcdpComponent, ctx);
        }
    }

    private void setPointQuery(DataSModelAnalysis datasModelAnalysis, LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        boolean methodAddFlag = false;
        if (ToolUtil.isNotEmpty((Object)datasModelAnalysis)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            DataSConditionAnalysis datasConditionAnalysis = datasModelAnalysis.getCondition();
            Map datasFieldAnalysisMap = datasModelAnalysis.getFields();
            String idField = "";
            String nameField = "";
            String longitudeField = "";
            String latitudeField = "";
            if (ToolUtil.isNotEmpty((Object)datasFieldAnalysisMap)) {
                for (Map.Entry fieldList : datasFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis datasFieldAnalysis : fieldAnalyses) {
                        String dataItemValue;
                        List dataItemPath = datasFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                        switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                            case "id": {
                                idField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "name": {
                                nameField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "longitude": {
                                longitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "latitude": {
                                latitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)latitudeField) && ToolUtil.isNotEmpty((Object)longitudeField)) {
                this.getQueryParams(datasModelAnalysis, ctx, params, datasConditionAnalysis);
                params.put("idCol", idField);
                params.put("nameCol", nameField);
                params.put("longitudeCol", longitudeField);
                params.put("latitudeCol", latitudeField);
                ctx.addMethod(lcdpComponent.getInstanceKey() + "PointQuery", RenderUtil.renderTemplate((String)"template/elementui/element/FaultMapEcharts/pointQuery.ftl", params));
                methodAddFlag = true;
            }
        }
        if (!methodAddFlag) {
            this.addEmptyPointQuery(lcdpComponent, ctx);
        }
    }

    private void addEmptyPointQuery(LcdpComponent lcdpComponent, Ctx ctx) {
        ctx.addMethod(lcdpComponent.getInstanceKey() + "PointQuery", "self." + lcdpComponent.getInstanceKey() + "Data.pointData = [{name: '\u7ad9\u70b9\u4e00',value: [111.009334, 32.109198],}, {name: '\u7ad9\u70b92',value: [112.60245,31.032607],}]");
    }

    private void setLineQuery(DataSModelAnalysis datasModelAnalysis, LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        boolean methodAddFlag = false;
        if (ToolUtil.isNotEmpty((Object)datasModelAnalysis)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            DataSConditionAnalysis datasConditionAnalysis = datasModelAnalysis.getCondition();
            Map datasFieldAnalysisMap = datasModelAnalysis.getFields();
            String idField = "";
            String nameField = "";
            String longitudeField = "";
            String latitudeField = "";
            if (ToolUtil.isNotEmpty((Object)datasFieldAnalysisMap)) {
                for (Map.Entry fieldList : datasFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis datasFieldAnalysis : fieldAnalyses) {
                        String dataItemValue;
                        List dataItemPath = datasFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                        switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                            case "id": {
                                idField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "name": {
                                nameField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "longitude": {
                                longitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "latitude": {
                                latitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)latitudeField) && ToolUtil.isNotEmpty((Object)longitudeField)) {
                this.getQueryParams(datasModelAnalysis, ctx, params, datasConditionAnalysis);
                params.put("idCol", idField);
                params.put("nameCol", nameField);
                params.put("longitudeCol", longitudeField);
                params.put("latitudeCol", latitudeField);
                ctx.addMethod(lcdpComponent.getInstanceKey() + "LineQuery", RenderUtil.renderTemplate((String)"template/elementui/element/FaultMapEcharts/lineQuery.ftl", params));
                methodAddFlag = true;
            }
        }
        if (!methodAddFlag) {
            this.addEmptyLineQuery(lcdpComponent, ctx);
        }
    }

    private void addEmptyLineQuery(LcdpComponent lcdpComponent, Ctx ctx) {
        ctx.addMethod(lcdpComponent.getInstanceKey() + "LineQuery", "self." + lcdpComponent.getInstanceKey() + "Data.lineData = [{\n      coords: [\n        [111.009334, 32.109198], [112.60245, 31.032607], [110.274854, 31.332607],\n      ]\n    }]");
    }

    private void setShowPointQuery(DataSModelAnalysis datasModelAnalysis, LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        boolean methodAddFlag = false;
        if (ToolUtil.isNotEmpty((Object)datasModelAnalysis)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("instanceKey", lcdpComponent.getInstanceKey());
            DataSConditionAnalysis datasConditionAnalysis = datasModelAnalysis.getCondition();
            Map datasFieldAnalysisMap = datasModelAnalysis.getFields();
            String idField = "";
            String typeField = "";
            String nameField = "";
            String longitudeField = "";
            String latitudeField = "";
            if (ToolUtil.isNotEmpty((Object)datasFieldAnalysisMap)) {
                for (Map.Entry fieldList : datasFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis datasFieldAnalysis : fieldAnalyses) {
                        String dataItemValue;
                        List dataItemPath = datasFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath)) continue;
                        switch (dataItemValue = (String)dataItemPath.get(dataItemPath.size() - 1)) {
                            case "id": {
                                idField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "name": {
                                nameField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "type": {
                                typeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "longitude": {
                                longitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                            case "latitude": {
                                latitudeField = datasFieldAnalysis.getFieldName();
                                break;
                            }
                        }
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)idField) && ToolUtil.isNotEmpty((Object)latitudeField) && ToolUtil.isNotEmpty((Object)longitudeField)) {
                this.getQueryParams(datasModelAnalysis, ctx, params, datasConditionAnalysis);
                params.put("idCol", idField);
                params.put("nameCol", nameField);
                params.put("typeCol", typeField);
                params.put("longitudeCol", longitudeField);
                params.put("latitudeCol", latitudeField);
                ctx.addMethod(lcdpComponent.getInstanceKey() + "ShowPointQuery", RenderUtil.renderTemplate((String)"template/elementui/element/FaultMapEcharts/showPointQuery.ftl", params));
                methodAddFlag = true;
            }
        }
        if (!methodAddFlag) {
            this.addEmptyShowPointQuery(lcdpComponent, ctx);
        }
    }

    private void addEmptyShowPointQuery(LcdpComponent lcdpComponent, Ctx ctx) {
        ctx.addMethod(lcdpComponent.getInstanceKey() + "ShowPointQuery", "self." + lcdpComponent.getInstanceKey() + "Data.errorPointData = [\n        {\n        name: '\u6d4e\u5357\u9ad8\u65b0\u533a',\n        value: [110.274854,31.332607],\n        data:{},\n      },\n    ]");
    }

    private void getQueryParams(DataSModelAnalysis datasModelAnalysis, Ctx ctx, Map<String, Object> params, DataSConditionAnalysis datasConditionAnalysis) throws LcdpException {
        String sortConditionName;
        DataSortConditionAnalysis dataSortConditionAnalysis;
        String querySelectionName;
        List conditionList;
        String operationName = "hussarQuery";
        String apiFileName = "";
        String apiFilePath = "";
        String dataModelId = datasModelAnalysis.getDataModelId();
        if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
            apiFileName = this.fileMappingService.getFileName(dataModelId);
            apiFilePath = this.fileMappingService.getImportPath(dataModelId);
        }
        if (ToolUtil.isNotEmpty((Object)datasConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = datasConditionAnalysis.getQueryConditionModelList()))) {
            params.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
            params.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
        }
        if (ToolUtil.isNotEmpty((Object)(querySelectionName = datasConditionAnalysis.getSelectCondition()))) {
            operationName = operationName + querySelectionName;
        }
        if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = datasModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
            operationName = operationName + sortConditionName;
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
        }
        params.put("importName", apiFileName);
        params.put("importMethod", operationName);
    }
}

