<div
    <#list attributes!?keys as key>
        ${key}="${attributes[key]}"
    </#list>
    <#if (disabled??)>
        :class="[{'disabled':${instanceKey!}Disabled},{'isDisabled':${instanceKey!}Disabled && ${instanceKey!}Files.length>0}]"
    </#if>
    ref="${instanceKey!}ImgUpload"
>
    <#if setUpSecurityLevel?? && setUpSecurityLevel>
        <el-upload v-if="${instanceKey!}isOpenMj" class="jxd-upload-item" :action="${instanceKey!}UploadApi" list-type="picture-card"
                <#if isContain?? && isContain>
                    :on-change="${instanceKey!}_UploadChange"
                    :auto-upload=false
                    :show-file-list = "${instanceKey!}IsShowList"
                    :file-list="${instanceKey!}FileMap[${itemInsKey!}Index]"
                <#else>
                    :show-file-list = "${instanceKey!}IsShowList"
                    :on-change="${instanceKey!}_UploadChange"
                    :auto-upload=false
                    :file-list="${instanceKey!}Files"
                </#if>
                    <#if limit?? && limit! gt 0>
                        :limit="${limit!}" :on-exceed="${instanceKey!}HandleExceed"
                    </#if>
                    ref="${instanceKey!}ImgUploadRef"
                    :headers="Headers"
                   :on-success="${instanceKey!}UploadSuccess"
                   :before-upload="${instanceKey!}BeforeUpload"
                    <#if isExistBig?? && isExistBig!>
                        :on-preview="${instanceKey!}HandlePictureCardPreview"
                    </#if>

                   <#--:on-remove="${instanceKey!}HandleRemove"-->
                    :disabled="${instanceKey!}Disabled"
                multiple accept="image/jpeg,image/jpg,image/png">
        <i class="jxd-uploader-icon <#if iconClassName??>${iconClassName!}<#else>el-icon-plus</#if>"></i>
                <div slot="file" slot-scope="{ file }" class="el-upload-list-slot">
                    <blob-img class="el-upload-list__item-thumbnail" :file="file" :src="file.url"></blob-img>
                    <span class="el-upload-list__item-actions">
                         <#if isContain?? && isContain>
                             <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file, ${itemInsKey!}Item, ${itemInsKey!}Index)">
                         <#else>
                            <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file)">
                         </#if>
                            <i class="el-icon-delete"></i>
                        </span>
                    </span>
                </div>
        </el-upload>
        <el-upload v-if="!${instanceKey!}isOpenMj" class="jxd-upload-item" :action="${instanceKey!}UploadApi" list-type="picture-card"
                <#if isContain?? && isContain>
                    :http-request="(params)=>${instanceKey!}UploadMethod(params, ${itemInsKey!}Item, ${itemInsKey!}Index)"
                    :file-list="${instanceKey!}FileMap[${itemInsKey!}Index]"
                <#else>
                    :http-request="${instanceKey!}UploadMethod"
                    :file-list="${instanceKey!}Files"
                </#if>
                    <#if limit?? && limit! gt 0>
                        :limit="${limit!}" :on-exceed="${instanceKey!}HandleExceed"
                    </#if>
                    ref="${instanceKey!}Ref"
                    :headers="Headers"
                   :on-success="${instanceKey!}UploadSuccess"
                   :before-upload="${instanceKey!}BeforeUpload"
                    <#if isExistBig?? && isExistBig!>
                        :on-preview="${instanceKey!}HandlePictureCardPreview"
                    </#if>

                   <#--:on-remove="${instanceKey!}HandleRemove"-->
                    :disabled="${instanceKey!}Disabled"
                multiple accept="image/jpeg,image/jpg,image/png">
        <i class="jxd-uploader-icon <#if iconClassName??>${iconClassName!}<#else>el-icon-plus</#if>"></i>
                <div slot="file" slot-scope="{ file }" class="el-upload-list-slot">
                    <blob-img class="el-upload-list__item-thumbnail" :file="file" :src="file.url"></blob-img>
                    <span class="el-upload-list__item-actions">
                         <#if isContain?? && isContain>
                             <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file, ${itemInsKey!}Item, ${itemInsKey!}Index)">
                         <#else>
                            <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file)">
                         </#if>
                            <i class="el-icon-delete"></i>
                        </span>
                    </span>
                </div>
        </el-upload>

    <#else>
        <el-upload class="jxd-upload-item" :action="${instanceKey!}UploadApi" list-type="picture-card"
                <#if isContain?? && isContain>
                    :http-request="(params)=>${instanceKey!}UploadMethod(params, ${itemInsKey!}Item, ${itemInsKey!}Index)"
                    :file-list="${instanceKey!}FileMap[${itemInsKey!}Index]"
                <#else>
                    :http-request="${instanceKey!}UploadMethod"
                    :file-list="${instanceKey!}Files"
                </#if>
                    <#if limit?? && limit! gt 0>
                        :limit="${limit!}" :on-exceed="${instanceKey!}HandleExceed"
                    </#if>
                    ref="${instanceKey!}Ref"
                    :headers="Headers"
                   :on-success="${instanceKey!}UploadSuccess"
                   :before-upload="${instanceKey!}BeforeUpload"
                    <#if isExistBig?? && isExistBig!>
                        :on-preview="${instanceKey!}HandlePictureCardPreview"
                    </#if>

                   <#--:on-remove="${instanceKey!}HandleRemove"-->
                    :disabled="${instanceKey!}Disabled"
                multiple accept="image/jpeg,image/jpg,image/png">
        <i class="jxd-uploader-icon <#if iconClassName??>${iconClassName!}<#else>el-icon-plus</#if>"></i>
                <div slot="file" slot-scope="{ file }" class="el-upload-list-slot">
                    <blob-img class="el-upload-list__item-thumbnail" :file="file" :src="file.url"></blob-img>
                    <span class="el-upload-list__item-actions">
                         <#if isContain?? && isContain>
                             <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file, ${itemInsKey!}Item, ${itemInsKey!}Index)">
                         <#else>
                            <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file)">
                         </#if>
                            <i class="el-icon-delete"></i>
                        </span>
                    </span>
                </div>
        </el-upload>
    </#if>
            <#if isExistBig?? && isExistBig!>
                 <el-dialog :append-to-body="true" :visible.sync="dialogVisible">
                  <img width="100%" :src="dialogImageUrl" alt="">
                 </el-dialog>
            </#if>

    <input type="hidden" ${valueData!} />
<#--    <el-dialog class="jxd_ins_elDialog upload-img-dialog" :visible.sync="${instanceKey!}DialogVisible" :append-to-body=true>-->
<#--        <img :src="${instanceKey!}DialogUrl">-->
<#--    </el-dialog>-->
    <#if setUpSecurityLevel?? && setUpSecurityLevel>
        <el-dialog v-if="${instanceKey!}isOpenMj" ref="${instanceKey!}DialogRef" :visible.sync="${instanceKey!}Show" :before-close="${instanceKey!}_Close" :show-close="${instanceKey!}ShowClose" :modal-append-to-body=true :append-to-body=true :close-on-click-modal="${instanceKey!}IsClickClose" top="0" class="${instanceKey!}_Dialog fileUploadDialog">
            <div slot="title" class="dialog-header fileUploadDialogHeader">
                多图片上传
            </div>
            <div class="dialog-body fileUploadDialogBody">
                <div ref="${instanceKey!}BodyRef" class="${instanceKey!}_Table">
                    <vxe-table class="fileUploadTable" show-overflow row-key keep-source :height="'100%'" ref="${instanceKey!}TableRef" :edit-config="{trigger: 'click', mode: 'cell', activeMethod: ${instanceKey!}_ActiveCellMethod}" @checkbox-change="${instanceKey!}_SelectRow" @checkbox-all="${instanceKey!}_SelectAll" :edit-rules="${instanceKey!}EditRules" :data="${instanceKey!}Data">
                        <vxe-table-column align="center" type="checkbox" :width="50"></vxe-table-column>
                        <vxe-table-column width="60">
                            <template #default>
                                <span class="drag-btn">
                                  <i class="vxe-icon--menu"></i>
                                </span>
                            </template>
                            <template #header>
                                <vxe-tooltip v-model="${instanceKey!}showHelpTip" content="按住后可以上下拖动排序！" enterable>
                                    <i class="vxe-icon--question" @click="${instanceKey!}showHelpTip = !${instanceKey!}showHelpTip"></i>
                                </vxe-tooltip>
                            </template>
                        </vxe-table-column>
                        <vxe-table-column align="center" title="序号" type="seq" width="60"></vxe-table-column>
                        <vxe-table-column align="center" header-align="center" field="fileName" title="附件名" :min-width="180" :edit-render="{
                                        immediate: true,
                                        name: 'input',
                                        attrs: {type: 'text'},
                                      }">
                        </vxe-table-column>
                        <vxe-table-column align="center" header-align="" field="fileType" title="附件类型" :min-width="70" :edit-render="{
                                        immediate: true,
                                        name: 'input',
                                        attrs: {type: 'text'},
                                      }">
                        </vxe-table-column>
                        <vxe-table-column align="center" header-align="center" field="fileSize" title="附件大小" :min-width="70" :edit-render="{
                                        immediate: true,
                                        name: 'input',
                                        attrs: {type: 'text'},
                                      }">
                        </vxe-table-column>
                        <vxe-table-column align="center" header-align="center" field="fileTime" title="上传时间" :min-width="180" :edit-render="{
                                        immediate: true,
                                        name: 'input',
                                        attrs: {type: 'text'},
                                      }">
                            <template v-slot="{ row }">
                                <span class="vxe-cell--label">{{(row.fileTime) ? $moment(row.fileTime).format('YYYY-MM-DD HH:mm:ss') : '--'}}</span>
                            </template>
                        </vxe-table-column>
                        <vxe-table-column align="center" header-align="center" field="filePerson" title="上传人" :min-width="90" :edit-render="{
                                        immediate: true,
                                        name: 'input',
                                        attrs: {type: 'text'},
                                      }">
                        </vxe-table-column>
                        <vxe-table-column align="center" header-align="center" field="securityLevel" title="密级" :min-width="130" :edit-render="{
                                        immediate: true,
                                        name: '$select',
                                        props: {type: 'select'},
                                        options: ${instanceKey!}degreeList,
                                      }">
                        </vxe-table-column>
                    </vxe-table>
                </div>
                <el-button tabindex="" ref="${instanceKey!}UploadRef" class="${instanceKey!}Upload confirmUploadBtn" v-loading.fullscreen.lock="${instanceKey!}showLoading" @click="${instanceKey!}_ConfirmUpload">
                    <span>全部上传</span>
                </el-button>
                <el-button tabindex="" ref="${instanceKey!}CancelRef" class="${instanceKey!}Cancel cancelUploadBtn" @click="${instanceKey!}_CancelUpload">
                    <span>取消上传</span>
                </el-button>
                <el-button tabindex="" ref="${instanceKey!}DeleteRef" class="${instanceKey!}Delete deleteUploadBtn" @click="${instanceKey!}_DeleteUpload">
                    <span>删除文件</span>
                </el-button>
                <el-dropdown trigger="click" @command="${instanceKey!}SecurityUpload" class="piliangDrpdown">
                    <el-button tabindex="" ref="${instanceKey!}SecurityRef" class="${instanceKey!}Security securityUploadBtn">
                        <span>批量设置密级</span>
                    </el-button>
                    <el-dropdown-menu slot="dropdown">
                        <el-dropdown-item v-for="item in ${instanceKey!}degreeList" :key="item.value" :command="item">{{item.label}}</el-dropdown-item>
                        <el-dropdown-item v-if="${instanceKey!}degreeList.length === 0" style="pointer-events: none;">
                          暂无数据
                        </el-dropdown-item>
                    </el-dropdown-menu>
                </el-dropdown>
            </div>
        </el-dialog>
    </#if>
</div>
