const result = [];
const seriesResult = [];
<#assign  innerAxisLine = '${innerAxisLine!}'>
<#assign  axisLineWidth = '${axisLineWidth!}'>
<#--标题-->
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end)+'\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
textStyle: {
color: '${titleColor!}',
fontSize: '${titleFontSize!}',
fontFamily: '${fontFamily!}',
fontWeight: '${fontWeight!}',
},
text: newTitle,
left: '${titleAlign!}',
top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
borderRadius: 4,
padding: [6, 5, 3, 5],
offsetCenter: ['20%', '20%'],
};
<#--主题颜色-->
const colorValue = ${topicColorStr!};
<#--提示信息-->
const echatrsTooltip = {
trigger: 'item',
show:${toolShow?string!},
backgroundColor: '${tooltipBgColor!}',
textStyle: {
color: '${toolColor!}',
fontSize: '${toolFontSize!}',
fontFamily: '${toolFontFamily!}',
fontWeight: '${toolFontWeight!}',
fontStyle: '${toolFontStyle!}',
lineHeight: '${toolLineHeight!}',
},
formatter(param) {
if (param.value) {
if (param.seriesIndex === 0) {
return `${r'${'}param.seriesName${r'}'}</br>${r'${'}param.name${r'}'} : ${r'${'}param.value${r'}'}${detailUnitOne!}`;
}
if (param.seriesIndex === 2) {
return `${r'${'}param.seriesName${r'}'}</br>${r'${'}param.name${r'}'} : ${r'${'}param.value${r'}'}${detailUnitTwo!}`;
}
if (param.seriesIndex === 4) {
return `${r'${'}param.seriesName${r'}'}</br>${r'${'}param.name${r'}'} : ${r'${'}param.value${r'}'}${detailUnitThere!}`;
}
}
return '';
},
padding: ['${toolPaddingTop!}', '${toolPaddingLeft!}'],
extraCssText: 'box-shadow: ${toolShadow!};',
};
<#--分割线-->
const splitLine = {
length: '${splitLineLength!}',
show: ${splitLineShow?string!},
lineStyle:{
color: '${splitLineColor!}',
width: '${splitLineWidth!}',
type: '${splitLineType!}',
opacity: 1
}
};
<#--刻度-->
const axisTick = {
show: ${axisTickShow?string!},
splitNumber: '${axisTickSplitNumber!}',
length: '${axisTickLength!}',
lineStyle:{
color:'${axisTickColor!}',
width:'${axisTickWidth!}'
}
};
<#--刻度标签-->
const axisLabel = {
show: ${axisLabelShow?string!},
distance:'${axisLabelDistance!}',
color: '${axisLabelColor!}',
fontSize: '${axisLabelFontSize!}',
formatter(value) {
return parseFloat(value).toFixed(0);
},
};
<#--开始基础数据-->
const settingData  = [];
const startData = [
{
center: ['25%', '60%'],
radius: '35%',
radiusInner: '25%',
offsetCenter: [0, '85%'],
maxValue: '${maxValueOne!}' ,
unit: '${detailUnitOne!}' ,
order: 1,
},
{
center: ['50%', '40%'],
radius: '55%',
radiusInner: '43%',
offsetCenter: [0, '85%'],
maxValue: '${maxValueTwo!}' ,
unit: '${detailUnitTwo!}' ,
order: 2,
},
{
center: ['75%', '60%'],
radius: '35%',
radiusInner: '25%',
offsetCenter: [0, '85%'],
maxValue: '${maxValueThere!}' ,
unit: '${detailUnitThere!}' ,
order: 3,
},
];
${optionData!}.xAxisData.forEach((col,index)=>{
if (index < 3) {
startData[index].value = ${optionData!}.seriesData[index];
startData[index].title = col;
settingData.push(startData[index]);
}
});
<#--设置颜色循环-->
if (colorValue.length < settingData.length) {
for (let i = 0; colorValue.length < settingData.length; i++) {
colorValue.push(...colorValue);
}
}
settingData.forEach((e, index) => {
seriesResult.push({
name: '${pointerName!}',
type: 'gauge',
startAngle: 180,
endAngle: 0,
center: e.center,
radius: e.radius,
splitNumber: e.order === 2 ? ${splitNumber!} : ${splitNumberSmall!},
min: ${minValue!},
max: e.maxValue,
axisLine:  {
show: ${axisLineShow?string!},
lineStyle: {
color: [[e.value / e.maxValue, colorValue[index]], [1, '#F3F5F8']],
width: '${axisLineWidth!}',
<#if axisLineWidth =="0" >
    opacity: '0',
<#else>
    opacity: '${axisLineOpacity!}',
</#if>
}
},
splitLine:splitLine,
axisTick:axisTick,
axisLabel:axisLabel,
pointer:{
show: ${pointerShow?string!},
length: '${pointerLength!}%',
width: '${pointerWidth!}',
},
progress: {
show: false,
},
detail:{
show: ${detailShow?string!},
valueAnimation: true,
formatter(param) {
const unitDataB = e.unit;
return param + unitDataB;
},
backgroundColor: '${detailBackgroundColor!}',
shadowColor: '${detailShadowColor!}',
<#if detailShadowBlur??>
    shadowBlur: ${detailShadowBlur!},
</#if>
<#if detailShadowOffsetX??>
    shadowOffsetX: ${detailShadowOffsetX!},
</#if>
<#if detailShadowOffsetY??>
    shadowOffsetY: ${detailShadowOffsetY!},
</#if>
padding: [4, 5],
color: '${detailColor!}',
fontWeight: '${detailFontWeight!}',
fontSize: '${detailFontSize!}',
fontFamily: '${detailFontFamily!}',
borderRadius: 2,
},
title:{
color: '${gaugeTitleColor!}',
fontSize: '${gaugeTitleFontSize!}',
fontFamily: '${gaugeFontFamily!}',
fontWeight: '${gaugeFontWeight!}',
offsetCenter: e.offsetCenter,
},
data: [{
value: parseFloat(e.value).toFixed(0),
name: e.title,
}],
}, {
type: 'gauge',
startAngle: 180,
endAngle: 0,
center: e.center,
radius: e.radiusInner,
splitNumber: 8,
min: 0,
max: 100,
pointer: {
show: false,
},
axisLine: {
show: ${axisLineShow?string!},
lineStyle: {
color: [[e.value / e.maxValue, colorValue[index]], [1, '#F3F5F8']],
width: '${innerAxisLine!}',
<#if innerAxisLine =="0" >
    opacity: '0',
<#else>
    opacity: '${innerAxisLine!}',
</#if>
},
},
axisTick: {
show: false,
length: 5,
splitNumber: 5,
lineStyle: {
color: '#F3F5F8',
width: 10,
},
},
splitLine: {
length: 4,
show: false,
lineStyle: {
width: 10,
color: '#fff',
},
},
axisLabel: {
show: false,
},
detail: {
show: false,
},
});
});
return {
title: echatrsTitle,
tooltip: echatrsTooltip,
series: seriesResult,
}
