/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementuireact.visitor.element;

import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.style.DefaultStyleCacheServiceImpl;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ReactVoidVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FrameworkVoidVisitor
implements ReactVoidVisitor<ReactLcdpComponent, ReactCtx> {
    private static DefaultStyleCacheService defaultStyleCacheService = (DefaultStyleCacheService)SpringUtil.getBean(DefaultStyleCacheServiceImpl.class);
    private String frameworkUrl = "/template/elementuireact/element/framework/";

    public void visit(ReactLcdpComponent lcdpComponent, ReactCtx ctx) throws Exception {
        this.init(lcdpComponent, ctx);
        lcdpComponent.registerTemplatePath(this.frameworkUrl + "framework.ftl");
        lcdpComponent.addRenderParam("imports", (Object)ctx.getImports());
        lcdpComponent.addRenderParam("contexts", (Object)ctx.getContexts());
        lcdpComponent.addRenderParam("components", (Object)ctx.getComponents());
        lcdpComponent.addRenderParam("states", (Object)ctx.getStates());
        lcdpComponent.addRenderParam("vars", (Object)ctx.getStates());
        lcdpComponent.addRenderParam("hooks", (Object)ctx.getHooks());
        lcdpComponent.addRenderParam("effects", (Object)ctx.getEffects());
        lcdpComponent.addRenderParam("functions", (Object)ctx.getFunctions());
        lcdpComponent.addRenderParam("scripts", (Object)ctx.getScripts());
        lcdpComponent.addRenderParam("jsxs", (Object)ctx.getJsxs());
        lcdpComponent.addRenderParam("pageName", (Object)ctx.getPageName());
        this.renderStyles(lcdpComponent, ctx);
    }

    private void init(ReactLcdpComponent lcdpComponent, ReactCtx ctx) throws LcdpException {
        ctx.addImport("css", "@emotion/react");
        ctx.addStyle("page", ".is-hidden{display: none !important;}");
    }

    private void renderStyles(ReactLcdpComponent lcdpComponent, ReactCtx ctx) {
        ArrayList<String> styles = new ArrayList<String>();
        Map stylesMap = ctx.getStyles();
        for (String name : stylesMap.keySet()) {
            StringBuilder style = new StringBuilder(name + ": css`\n");
            List styleList = (List)stylesMap.get(name);
            for (String str : styleList) {
                style.append("            ").append(str).append("\n");
            }
            style.append("        `,");
            styles.add(style.toString());
        }
        lcdpComponent.addRenderParam("styles", styles);
    }
}

