<el-select
        @click.native="${instanceKey!}ClearInput"
        <#if (isClearable?? && isClearable!)>
            clearable
        </#if>
        <#if (tabindex??)>
            tabindex="${tabindex!}"
        </#if>
        <#if (placeholder??)>
             placeholder="${placeholder!}"
        </#if>
        <#if (allowCreate?? && allowCreate!)>
            allow-create default-first-option
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
        <#if isBlur?? && isBlur!>
            <#if select?? && multiple?? && select! && multiple!>
                @blur.native.capture="${instanceKey!}Blur"
            </#if>
        </#if>
        <#if loading?? && isBindData?? && loading! && isBindData!>
            :loading="${instanceKey!}Loading"
            :loading-text="${instanceKey!}LoadingText"
        </#if>
    >
    <div class="search-div">
        <el-input prefix-icon="el-icon-search" type="text" placeholder="搜索内容" clearable v-model="${instanceKey!}InputKey" @input="${instanceKey!}FilterSearch"></el-input>
    </div>
    <div class="search-div-empty" slot="empty" style="padding-top:5px">
        <el-input prefix-icon="el-icon-search" type="text" placeholder="搜索内容" clearable v-model="${instanceKey!}InputKey" @input="${instanceKey!}FilterSearch"></el-input>
        <p class="el-select-dropdown__empty">暂无数据</p>
    </div>
    <el-option v-for="option in ${instanceKey!}FilterSearch(${instanceKey!}InputKey)"
               :label="option.${cusLabelToTemplate!}" :key="option.${cusValueToTemplate!}"  :value="option.${cusValueToTemplate!}" :title="option.${cusLabelToTemplate!}"></el-option>
</el-select>
