/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementuireact.visitor.provide;

import com.jxdinfo.hussar.formdesign.basereact.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.basereact.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.basereact.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementuireact.JXDElLineBar.value")
@Scope(value="prototype")
public class LineBarEchartsValueProvide
implements ValueVisitor<ReactLcdpComponent, ReactCtx> {
    private ReactLcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private ReactCtx ctx;

    public void visit(ReactLcdpComponent lcdpComponent, ReactCtx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("label", "xAxisData");
        map.put("value", "yAxisData");
        map.put("legend", "legendData");
        map.put("type", "typeData");
        return map;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }

    public String getDefaultValue() {
        return "{\nxAxisData: [],\nyAxisData: [],\nlegendData: [],\ntypeData: [],\n}";
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            if ("data".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getOptionData();
                }
                return this.getItemValue(dataItems.get(1));
            }
            if ("clickData".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getOptionData();
                }
                return this.getQueryDataItemValue(dataItems.get(1));
            }
        }
        return this.getOptionData();
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    private ComponentData getItemValue(String data) throws LcdpException {
        ComponentData itemData = new ComponentData();
        itemData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        itemData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        switch (data) {
            case "label": {
                itemData.setRenderValue(this.getOptionData().getRenderValue() + ".xAxisData");
                break;
            }
            case "value": {
                itemData.setRenderValue(this.getOptionData().getRenderValue() + ".yAxisData");
                break;
            }
            case "legend": {
                itemData.setRenderValue(this.getOptionData().getRenderValue() + ".legendData");
                break;
            }
            case "type": {
                itemData.setRenderValue(this.getOptionData().getRenderValue() + ".typeData");
                break;
            }
            default: {
                itemData.setRenderValue("''");
            }
        }
        return itemData;
    }

    private ComponentData getOptionData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("data");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((ReactLcdpComponent)this.lcdpComponent, (ReactCtx)this.ctx, (String)CodeSuffix._OPTION_DATA.getType(), optionDataItem));
        return optionData;
    }

    private ComponentData getQueryDataItemValue(String data) throws LcdpException {
        ComponentData itemData = new ComponentData();
        switch (data) {
            case "name": {
                itemData.setRenderValue(this.getQueryData().getRenderValue() + ".name");
                break;
            }
            case "value": {
                itemData.setRenderValue(this.getQueryData().getRenderValue() + ".value");
                break;
            }
            case "legend": {
                itemData.setRenderValue(this.getQueryData().getRenderValue() + ".seriesName");
                break;
            }
            default: {
                itemData.setRenderValue("''");
            }
        }
        return itemData;
    }

    private ComponentData getQueryData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("QueryData");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((ReactLcdpComponent)this.lcdpComponent, (ReactCtx)this.ctx, (String)"QueryData", optionDataItem));
        return optionData;
    }
}

