/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementuireact.publish;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.common.annotation.ClientKind;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.CodePublisher;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.MergeResult;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeBaseConfig;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.reactcodegenerator.core.generate.front.ReactCodeGenerateService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.theme.config.service.IHussarThemeConfigService;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ClientKind(kind="com.jxdinfo.reactWebPage.publish")
public class ReactCodePublishImpl
implements CodePublisher {
    public static final String KIND = "com.jxdinfo.reactWebPage.publish";
    private final VersionManageService versionManageService = (VersionManageService)SpringContextHolder.getBean(VersionManageService.class);
    private final FilePublishService filePublishService = (FilePublishService)SpringContextHolder.getBean(FilePublishService.class);
    private final CodeMergeService codeMergeService = (CodeMergeService)SpringContextHolder.getBean(CodeMergeService.class);
    private final ReactCodeGenerateService reactCodeGenerateService = (ReactCodeGenerateService)SpringContextHolder.getBean(ReactCodeGenerateService.class);
    private final FileMappingService fileMappingService = (FileMappingService)SpringContextHolder.getBean(FileMappingService.class);
    private final FormDesignProperties formDesignProperties = (FormDesignProperties)SpringContextHolder.getBean(FormDesignProperties.class);
    private final IHussarThemeConfigService iHussarThemeConfigService = (IHussarThemeConfigService)SpringContextHolder.getBean(IHussarThemeConfigService.class);
    private final CodePublishTool codePublishTool = (CodePublishTool)SpringContextHolder.getBean(CodePublishTool.class);
    public static final String JS = ".js";
    private static final String PREFIX_COMMON_JS = "prefixCommon.js";
    private static final String PREFIX_PATH = "/src/pages/index";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(PublishCtx<CodeResult> publishCtx, ThemeVars themeVars) throws LcdpException, IOException {
        Integer strategy = this.formDesignProperties.isLocalUnReset() ? Integer.valueOf(2) : null;
        PageInfo pageInfo = (PageInfo)publishCtx.getBaseFile();
        String id = pageInfo.getId();
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        String pageName = pageInfo.getName();
        String pageInfoDataJson = pageInfo.getData();
        JSONObject pageInfoDataJsonObject = JSON.parseObject((String)pageInfoDataJson);
        StyleScheme styleScheme = this.iHussarThemeConfigService.getCurrentSysThemeInfo();
        ThemeBaseConfig themeBaseConfig = styleScheme.getThemeBase().getWebPage();
        Map scssVars = styleScheme.getScssVars().getWebPage();
        String newContent = this.reactCodeGenerateService.reactGenerate(pageInfoDataJsonObject, pageName, pageInfo, themeVars.getWebPage(), strategy, themeBaseConfig, scssVars);
        newContent = CodeSplitUtil.removeEmptyLines((String)newContent);
        this.filePublishService.writePublishSourceToCache(id, "web");
        if (strategy != null) {
            this.genWebCode(pageInfo, newContent, strategy, publishCtx);
            this.codePublishTool.delayWrite(id);
            this.compile(moduleRelatePath, pageInfo.getName(), strategy);
            strategy = null;
        }
        Optional<String> ancestorContent = Optional.ofNullable(this.versionManageService.getAncestorCodeById(id));
        String pagePath = this.webProjectVue(strategy, moduleRelatePath, pageName + ".jsx").getLocalPath();
        Optional<String> currentContent = Optional.ofNullable(this.filePublishService.readCurrentPublishedFile(pagePath));
        if (ancestorContent.isPresent() && currentContent.isPresent()) {
            MergeResult mergeResult = this.codeMergeService.structuralMerge(pagePath, ExtractFileType.VUE, ancestorContent.get(), currentContent.get(), newContent, true);
            boolean isConflict = mergeResult.isConflict();
            if (!isConflict) {
                try {
                    this.genWebCode(pageInfo, mergeResult.getMergedCode(), strategy, publishCtx);
                    this.codePublishTool.delayWrite(id);
                }
                finally {
                    this.versionManageService.saveLastPublishCode(id, newContent);
                    this.versionManageService.saveLastFileCode(id, mergeResult.getMergedCode());
                }
            } else {
                String projectPagePath = this.webProjectVue(strategy, this.fileMappingService.getFormatPath(id) + ".jsx").getLocalPath();
                this.codePublishTool.assembleCode(id, publishCtx, newContent, currentContent, mergeResult, projectPagePath);
                this.genWebCode(pageInfo, newContent, strategy, publishCtx);
            }
        } else {
            try {
                this.genWebCode(pageInfo, newContent, strategy, publishCtx);
            }
            finally {
                this.versionManageService.saveLastPublishCode(id, newContent);
                this.versionManageService.saveLastFileCode(id, newContent);
                this.codePublishTool.delayWrite(id);
            }
        }
    }

    private void genWebCode(PageInfo pageInfo, String code, Integer strategy, PublishCtx<CodeResult> publishCtx) throws LcdpException, IOException {
        String moduleRelatePath = this.fileMappingService.getFormatParentPath(pageInfo.getId());
        this.writeVueCode(code, moduleRelatePath, pageInfo.getName(), strategy, publishCtx.getBaseFile().getId());
        String pageId = pageInfo.getId();
        this.filePublishService.writePublishResourceToCache(pageId, pageInfo, publishCtx.getPublishDTO());
        this.getCommon(pageId);
    }

    public void writeVueCode(String fileContent, String modulePath, String pageName, Integer strategy, String pageId) throws IOException {
        String filePath = this.webProjectVue(strategy, modulePath, pageName + ".jsx").getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(fileContent, filePath, pageId);
    }

    private void getCommon(String pageId) throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String prefix = AppContextUtil.getUnionPrefix();
        prefix = ToolUtil.isNotEmpty((Object)prefix) ? FileUtil.posixPath((String[])new String[]{prefix}) : prefix;
        map.put("name", prefix);
        map.put("pathName", ToolUtil.isEmpty((Object)prefix) ? "" : FileUtil.posixPath((String[])new String[]{"/", prefix}));
        String newCode = RenderUtil.renderTemplate((String)"prefixCommon/prefixCommon.ftl", map);
        String filePath = this.webProject(PREFIX_PATH, AppContextUtil.posixFilePathPrefix(), PREFIX_COMMON_JS).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS((String)filePath);
        this.filePublishService.writeStringToFile(newCode, filePath, pageId);
    }

    private void compile(String moduleRelatePath, String pageName, Integer strategy) throws LcdpException {
        HashMap<String, String> compileParams = new HashMap<String, String>();
        String pageJSName = "__" + pageName;
        String tmpCompileJsPath = this.webProjectVue(strategy, moduleRelatePath, pageJSName + JS).getLocalPath();
        String publishVueRelativePath = FileUtil.posixPath((String[])new String[]{".", pageName});
        if (ToolUtil.isNotEmpty((Object)moduleRelatePath)) {
            moduleRelatePath = moduleRelatePath.substring(0, 1).equals("/") ? moduleRelatePath.substring(1) : moduleRelatePath;
        }
        String tmpCompileJs = ToolUtil.loadResource(this.getClass(), (String)"/template/compileTemplate.js");
        tmpCompileJs = tmpCompileJs.replace("${vuePath}", publishVueRelativePath);
        this.filePublishService.writeStringToFile(tmpCompileJs, tmpCompileJsPath);
        compileParams.put("entry", tmpCompileJsPath);
        compileParams.put("template", this.webProject(this.formDesignProperties.getFrontCompileHtmlPath()).getLocalPath());
        compileParams.put("output", FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getFrontCompilePath(), AppContextUtil.getUnionPrefix(), moduleRelatePath, File.separator}));
        compileParams.put("name", pageName);
        compileParams.put("path", moduleRelatePath);
        this.codePublishTool.compile(publishVueRelativePath, compileParams, this.formDesignProperties.getFrontCompileServer());
    }

    private ResourcePath webProjectVue(Integer strategy, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath((String[])new String[]{this.formDesignProperties.getFrontProjectPath(), this.formDesignProperties.getVueCodePath(strategy)});
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }

    private ResourcePath webProject(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getFrontProjectPath();
        return ResourcePath.of((String)FileUtil.posixPath((String[])pathSegments), (String)localPrefix, (String)"");
    }
}

