/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementuireact.visitor.provide;

import com.jxdinfo.hussar.formdesign.basereact.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.basereact.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.basereact.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementuireact.JXDElMultiChoice.value")
@Scope(value="prototype")
public class MultiChoiceValueProvide
implements ValueVisitor<ReactLcdpComponent, ReactCtx> {
    private ReactLcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private ReactCtx ctx;

    public String getDefaultValue() {
        return null;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        HashMap<String, String> multiChoiceMapping = new HashMap<String, String>();
        multiChoiceMapping.put("label", "label");
        multiChoiceMapping.put("value", "value");
        return multiChoiceMapping;
    }

    public void visit(ReactLcdpComponent lcdpComponent, ReactCtx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            if ("data".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getMultiData();
                }
                String data = dataItems.get(1);
                if ("value".equals(data)) {
                    return this.getMultiValueData();
                }
                return this.getMultiLabelData();
            }
            if ("value".equals(dataItem)) {
                return this.getMultiValueData();
            }
            return this.getMultiLabelData();
        }
        ArrayList<String> valueItem = new ArrayList<String>();
        valueItem.add("value");
        return new ComponentData(ComponentData.DataTypeEnum.ARRAY_PRIMARY, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((ReactLcdpComponent)this.lcdpComponent, (ReactCtx)this.ctx, (String)CodeSuffix._VALUE_DATA.getType(), valueItem));
    }

    public ComponentData getDefaultValueByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> dataItems) throws LcdpException {
        return null;
    }

    private ComponentData getMultiData() throws LcdpException {
        ComponentData multiData = new ComponentData();
        ArrayList<String> multiDataItem = new ArrayList<String>();
        multiDataItem.add("data");
        multiData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        multiData.setRenderValue(ComponentDataUtil.getComponentDataRender((ReactLcdpComponent)this.lcdpComponent, (ReactCtx)this.ctx, (String)CodeSuffix._MULTI_DATA.getType(), multiDataItem));
        return multiData;
    }

    private ComponentData getMultiValueData() throws LcdpException {
        ComponentData multiValueData = new ComponentData();
        multiValueData.setDataType(ComponentData.DataTypeEnum.STRING);
        multiValueData.setRenderValue(ComponentDataUtil.getComponentDataRender((ReactLcdpComponent)this.lcdpComponent, (ReactCtx)this.ctx, (String)CodeSuffix._VALUE_DATA.getType(), Collections.singletonList("value")));
        return multiValueData;
    }

    private ComponentData getMultiLabelData() throws LcdpException {
        ComponentData multiLabelData = new ComponentData();
        multiLabelData.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        multiLabelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        String multiData = this.getMultiData().getRenderValue();
        String valueData = this.getMultiValueData().getRenderValue();
        multiLabelData.setRenderValue("function(){\nconst result = [];\n" + multiData + ".forEach((item) => {if(" + valueData + ".indexOf(item.value) > -1){\nresult.push(item.label);}\n});\nreturn result;}()");
        return multiLabelData;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((ReactLcdpComponent)this.lcdpComponent, (ReactCtx)this.ctx, (String)CodeSuffix._MULTI_DATA.getType(), Collections.singletonList("value"))));
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }
}

