/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.elementuireact.visitor.element;

import com.jxdinfo.hussar.formdesign.basereact.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.formdesign.common.ctx.ReactCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.react.ReactComponent;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ReactLcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ReactVoidVisitor;
import java.util.ArrayList;
import java.util.Map;

public class ElFormatVisitor
implements ReactVoidVisitor<ReactLcdpComponent, ReactCtx> {
    private String frameworkUrl = "/template/elementuireact/element/framework/";

    public void visit(ReactLcdpComponent lcdpComponent, ReactCtx ctx) throws Exception {
        lcdpComponent.registerTemplatePath(this.frameworkUrl + "react.ftl");
        ReactComponent component = ctx.getCurrentReactComponent();
        this.renderImport(ctx);
        this.renderAttrs(lcdpComponent, ctx, component);
        this.renderState(lcdpComponent, ctx, component);
        this.renderFunction(lcdpComponent, ctx, component);
        this.renderClass(lcdpComponent, component);
        component.setJsx(RenderUtil.renderTemplate((String)"/template/elementuireact/element/format/format.ftl", (Map)component.getParams()));
    }

    private void renderImport(ReactCtx ctx) {
        ctx.addImport("Tooltip", "element-react");
    }

    private void renderClass(ReactLcdpComponent lcdpComponent, ReactComponent component) {
        component.addClass(lcdpComponent.getInstanceKey() + " jxd_ins_format jxd-format-element " + lcdpComponent.getStyleSchemeClassName(), false);
        component.addClass("hidden ? 'is-hidden' : ''");
        component.addClass("!hidden ? 'isFlex' : ''");
    }

    private void renderAttrs(ReactLcdpComponent lcdpComponent, ReactCtx ctx, ReactComponent component) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealHiddenAttr(lcdpComponent, ctx, component);
    }

    private void renderState(ReactLcdpComponent lcdpComponent, ReactCtx ctx, ReactComponent component) throws LcdpException {
        component.addState("data", "'" + lcdpComponent.getProps().get("text").toString() + "'");
        component.addState("tooltip", "false");
        component.setParam("bindData", (Object)"data");
        component.setParam("normal", lcdpComponent.getProps().get("normal"));
    }

    private void renderFunction(ReactLcdpComponent lcdpComponent, ReactCtx ctx, ReactComponent component) throws LcdpException {
        component.setParam("numberFmt", lcdpComponent.getProps().get("numberFmt"));
        component.setParam("dateFmt", lcdpComponent.getProps().get("dateFmt"));
        String pageName = ctx.getPageName();
        String insKey = lcdpComponent.getInstanceKey();
        String id = pageName + insKey;
        component.setParam("id", (Object)id);
        component.addAttr("onMouseOver", (Object)("() => selectStyle('" + lcdpComponent.getInstanceKey() + "', '" + id + "')"));
        ctx.addImport("formatSelectStyle", "@/pages/index/utils/lowcode/formatUtil");
        ArrayList<String> selectStyleArgs = new ArrayList<String>();
        selectStyleArgs.add("key");
        selectStyleArgs.add("insId");
        component.addFunction("selectStyle", selectStyleArgs, RenderUtil.renderTemplate((String)"/template/elementuireact/element/format/selectStyle.ftl", (Map)component.getParams()));
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("textOld")) && (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("numberFmt")) || ToolUtil.isNotEmpty(lcdpComponent.getProps().get("dateFmt")))) {
            component.setParam("text", lcdpComponent.getProps().get("textOld"));
        } else {
            component.setParam("text", lcdpComponent.getProps().get("text"));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getRenderParams().get("format"))) {
            component.setParam("format", (Object)(lcdpComponent.getRenderParams().get("format") + "|| format(data)"));
        } else {
            component.setParam("format", (Object)"|| format(data)");
        }
        ArrayList<String> formatArgs = new ArrayList<String>();
        formatArgs.add("value");
        formatArgs.add("that");
        component.addFunction("format", formatArgs, RenderUtil.renderTemplate((String)"template/elementui/element/format/format_filter.ftl", (Map)component.getParams()));
    }
}

