<el-upload
        :action="${instanceKey!}UploadApi"
        <#if singleUpload?? && !singleUpload>
        :multiple="true"
        </#if>
        <#if (multipleFile?? && multipleFile)>
            multipleFile
        </#if>
        :show-file-list="false"
        :file-list="${instanceKey!}FileList"
        :on-change="${instanceKey!}UploadChange"
        :auto-upload="false"
        :before-upload="${instanceKey!}HandleBeforeUpload"
        :class="{'is-disabled':${instanceKey!}Disabled}"
        <#if showProgress?? && showProgress!>
            :on-progress="${instanceKey!}OnUploadProgress"
        </#if>
>
    <span>
        <#if iconClassName?? && isRightActive?? && isRightActive == false>
            <i class="${iconClassName} fileUpload-icon"></i>
        </#if>
        <span class="fileUpload-span">${text!}</span>
        <#if (iconClassName??) && isRightActive?? && isRightActive == true>
            <i class="${iconClassName}"></i>
        </#if>
    </span>
    <#if showProgress?? && showProgress!>
        <div class="progress-loading el-loading-mask" v-show="${instanceKey!}ShowProgress">
            <div class="el-loading-spinner">
                <el-progress type="circle" :percentage="${instanceKey!}Percentage" :show-text="true"></el-progress>
            </div>
        </div>
    </#if>
    <el-dialog ref="${instanceKey!}DialogRef" :visible.sync="${instanceKey!}Show" :before-close="${instanceKey!}Close" :show-close="${instanceKey!}ShowClose" :modal-append-to-body=true :append-to-body=true :close-on-click-modal="${instanceKey!}IsClickClose" top="0" class="${instanceKey!}_Dialog fileUploadDialog">
        <div slot="title" class="dialog-header fileUploadDialogHeader">
            附件上传
        </div>
        <div class="dialog-body fileUploadDialogBody">
            <div ref="${instanceKey!}BodyRef" class="${instanceKey!}_Table">
                <vxe-table auto-resize class="fileUploadTable" show-overflow row-key keep-source :height="'100%'" ref="${instanceKey!}TableRef" :edit-config="{trigger: 'click', mode: 'cell', activeMethod: ${instanceKey!}ActiveCellMethod}" @checkbox-change="${instanceKey!}SelectRow" @checkbox-all="${instanceKey!}SelectAll" :data="${instanceKey!}Data" :edit-rules="${instanceKey!}EditRules">
                    <vxe-table-column align="center" type="checkbox" :width="50"></vxe-table-column>
                    <vxe-table-column width="60">
                        <template #default>
                        <span class="drag-btn">
                          <i class="vxe-icon--menu"></i>
                        </span>
                        </template>
                        <template #header>
                            <vxe-tooltip v-model="${instanceKey!}showHelpTip" content="按住后可以上下拖动排序！" enterable>
                                <i class="vxe-icon--question" @click="${instanceKey!}showHelpTip = !${instanceKey!}showHelpTip"></i>
                            </vxe-tooltip>
                        </template>
                    </vxe-table-column>
                    <vxe-table-column align="center" title="序号" type="seq" width="60"></vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="fileName" title="附件名" :min-width="180" :edit-render="{
                                immediate: true,
                                name: 'input',
                                attrs: {type: 'text'},
                              }">
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="" field="fileType" title="附件类型" :min-width="70" :edit-render="{
                                immediate: true,
                                name: 'input',
                                attrs: {type: 'text'},
                              }">
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="fileSize" title="附件大小" :min-width="70" :edit-render="{
                                immediate: true,
                                name: 'input',
                                attrs: {type: 'text'},
                              }">
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="fileTime" title="上传时间" :min-width="180" :edit-render="{
                                immediate: true,
                                name: 'input',
                                attrs: {type: 'text'},
                              }">
                        <template v-slot="{ row }">
                            <span class="vxe-cell--label">{{(row.fileTime) ? $moment(row.fileTime).format('YYYY-MM-DD HH:mm:ss') : '--'}}</span>
                        </template>
                    </vxe-table-column>
                    <vxe-table-column align="center" header-align="center" field="filePerson" title="上传人" :min-width="90" :edit-render="{
                                immediate: true,
                                name: 'input',
                                attrs: {type: 'text'},
                              }">
                    </vxe-table-column>
                    <#if setUpSecurityLevel?? && setUpSecurityLevel>
                    <vxe-table-column align="center" header-align="center" field="securityLevel" title="密级" :min-width="130" :edit-render="{
                                immediate: true,
                                name: '$select',
                                props: {type: 'select'},
                                options: ${instanceKey!}degreeList,
                              }">
                    </vxe-table-column>
                    </#if>
                </vxe-table>
            </div>
            <el-button tabindex="" ref="${instanceKey!}UploadRef" class="${instanceKey!}Upload confirmUploadBtn" @click="${instanceKey!}ConfirmUpload">
                <span>全部上传</span>
            </el-button>
            <el-button tabindex="" ref="${instanceKey!}CancelRef" class="${instanceKey!}Cancel cancelUploadBtn" @click="${instanceKey!}CancelUpload">
                <span>取消上传</span>
            </el-button>
            <el-button tabindex="" ref="${instanceKey!}DeleteRef" class="${instanceKey!}Delete deleteUploadBtn" @click="${instanceKey!}DeleteUpload">
                <span>删除文件</span>
            </el-button>
            <#if (setUpSecurityLevel?? && setUpSecurityLevel) && (singleUpload?? && !singleUpload)>
                <el-dropdown trigger="click" @command="${instanceKey!}SecurityUpload">
                    <el-button tabindex="" ref="${instanceKey!}SecurityRef" class="${instanceKey!}Security securityUploadBtn" style="width: auto">
                        <span>批量设置密级</span>
                    </el-button>
                    <el-dropdown-menu slot="dropdown">
                        <el-dropdown-item v-for="item in ${instanceKey!}degreeList" :key="item.value" :command="item">{{item.label}}</el-dropdown-item>
                    </el-dropdown-menu>
                </el-dropdown>
            </#if>
        </div>
    </el-dialog>
</el-upload>