/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.spacedigital.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.factory.InteractiveClassFactory;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.spacedigital.utils.TextAlignForVertical;
import com.jxdinfo.hussar.formdesign.spacedigital.visitor.element.UpgradedFileUploadVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.formdesign.spacedigital.element.UpgradedFileUpload")
public class UpgradedFileUpload
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.spacedigital.JXDElUpgradedFileUpload";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)".is-disabled");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elErYuanFileUpload");
    }

    public VoidVisitor visitor() {
        return new UpgradedFileUploadVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("disabled", "${prefix}.is-disabled .el-upload{cursor: ${val};}");
        map.put("allowed", "${prefix}{cursor: ${val}}");
        map.put("uploadWidth", "${prefix} .el-upload{width: ${val}}");
        map.put("uploadHeight", "${prefix} .el-upload{height: ${val}}");
        map.put("wordBreak", "${prefix} .el-upload{word-break: ${val}}");
        map.put("overflow", "${prefix}{overflow: ${val}}");
        map.put("textDecoration", "${prefix} .el-upload{text-decoration: ${val}}");
        map.put("textAlign", "${prefix} .el-upload{text-align: ${val};}");
        map.put("progressLoading", "${prefix} .progress-loading{position: ${val};}");
        map.put("itemDisplay", "${prefix}.jxd_ins_elFileUpload .el-upload{display: ${val};}");
        map.put("itemJustifyContent", "${prefix}.jxd_ins_elFileUpload .el-upload{justify-content:${val};}");
        map.put("itemAlign", "${prefix}.jxd_ins_elFileUpload .el-upload{align-items:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> "${prefix} {box-shadow: none}");
        return (Function)map.get(key);
    }

    public static UpgradedFileUpload newComponent(JSONObject jsonObject) {
        Boolean showProgress;
        UpgradedFileUpload multiFileUpload = (UpgradedFileUpload)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)UpgradedFileUpload.class.getName()));
        Object backgroundImg = multiFileUpload.getStyles().get("backgroundImageBack");
        Object disabled = multiFileUpload.getStyles().get("disabled");
        Object allowed = multiFileUpload.getStyles().get("allowed");
        Object uploadWidth = multiFileUpload.getStyles().get("width");
        multiFileUpload.getStyles().remove("backgroundImageBack");
        TextAlignForVertical.setTextAlign(multiFileUpload, "styles");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            multiFileUpload.getStyles().put("backgroundImage", backgroundImg);
        }
        if (ToolUtil.isEmpty(disabled)) {
            multiFileUpload.getInnerStyles().put("disabled", "no-drop !important");
        }
        if (ToolUtil.isEmpty(allowed)) {
            multiFileUpload.getInnerStyles().put("allowed", "pointer");
        }
        if (ToolUtil.isEmpty(uploadWidth)) {
            multiFileUpload.getInnerStyles().put("uploadWidth", "100%");
        }
        multiFileUpload.getInnerStyles().put("textDecoration", "inherit");
        multiFileUpload.getInnerStyles().put("uploadHeight", "100%");
        multiFileUpload.getStyles().remove("vertical");
        Object textAlign = multiFileUpload.getStyles().get("textAlign");
        multiFileUpload.getInnerStyles().put("textAlign", textAlign);
        if (ToolUtil.isNotEmpty(multiFileUpload.getProps().get("showProgress")) && (showProgress = (Boolean)multiFileUpload.getProps().get("showProgress")).booleanValue()) {
            multiFileUpload.getInnerStyles().put("progressLoading", "fixed");
        }
        return multiFileUpload;
    }
}

