/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.provide;

import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.ValueVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.ComponentDataUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.elementui.JXDElSelect.value")
@Scope(value="prototype")
public class SelectValueProvide
implements ValueVisitor {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        Map<String, String> customParams = this.setParamValue(this.lcdpComponent);
        String customLabel = customParams.get("customLabel");
        String customValue = customParams.get("customValue");
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("label", customLabel);
        map.put("value", customValue);
        return map;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "''";
    }

    public Map<String, String> setParamValue(LcdpComponent lcdpComponent) {
        Map maps = lcdpComponent.getProps();
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        String customLabel = "label";
        String customValue = "value";
        if (ToolUtil.isNotEmpty(maps.get("customLabel"))) {
            customLabel = String.valueOf(maps.get("customLabel"));
        }
        if (ToolUtil.isNotEmpty(maps.get("customValue"))) {
            customValue = String.valueOf(maps.get("customValue"));
        }
        customParams.put("customLabel", customLabel);
        customParams.put("customValue", customValue);
        return customParams;
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        Map<String, String> customParams = this.setParamValue(this.lcdpComponent);
        String customLabel = customParams.get("customLabel");
        String customValue = customParams.get("customValue");
        if (ToolUtil.isNotEmpty(dataItems)) {
            String dataItem = dataItems.get(0);
            if ("data".equals(dataItem)) {
                if (dataItems.size() == 1) {
                    return this.getOptionData();
                }
                String data = dataItems.get(1);
                return this.getValueLabelData(data);
            }
            if ("value".equals(dataItem)) {
                return this.getValueData();
            }
            if ("label".equals(dataItem)) {
                ComponentData labelData = new ComponentData();
                Object multiple = this.lcdpComponent.getProps().get("multiple");
                boolean isMultiple = ToolUtil.isNotEmpty(multiple) && (Boolean)multiple != false;
                labelData.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
                labelData.setDataType(isMultiple ? ComponentData.DataTypeEnum.ARRAY_PRIMARY : ComponentData.DataTypeEnum.STRING);
                String optionData = this.getOptionData().getRenderValue();
                if (isMultiple) {
                    labelData.setRenderValue("function() {\n const labelArray = [];const selectArray = " + this.getValueData().getRenderValue() + ".split(\",\");if(selectArray.length > 0) {selectArray.forEach((item) => {const flag = " + optionData + ".find((data) => data.value === item);if(flag) {labelArray.push(flag.label)}});}return labelArray;}()");
                } else {
                    labelData.setRenderValue("function() {\n for(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nif(" + optionData + "[i]." + customValue + " === " + this.getValueData().getRenderValue() + "){\nreturn " + optionData + "[i]." + customLabel + ";\n}\n}\nreturn '';}()");
                }
                return labelData;
            }
        }
        return this.getValueData();
    }

    private ComponentData getOptionData() throws LcdpException {
        ComponentData optionData = new ComponentData();
        ArrayList<String> optionDataItem = new ArrayList<String>();
        optionDataItem.add("data");
        optionData.setDataItemSource(ComponentData.DataItemSourceEnum.DATA);
        optionData.setDataType(ComponentData.DataTypeEnum.ARRAY_OBJECT);
        optionData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._OPTION.getType(), optionDataItem));
        return optionData;
    }

    private ComponentData getValueLabelData(String dataItem) throws LcdpException {
        Map<String, String> customParams = this.setParamValue(this.lcdpComponent);
        String customLabel = customParams.get("customLabel");
        String customValue = customParams.get("customValue");
        ComponentData data = new ComponentData();
        data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
        data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
        String optionData = this.getOptionData().getRenderValue();
        if ("label".equals(dataItem)) {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i]." + customLabel + ");\n}\nreturn flag;}()");
        } else {
            data.setRenderValue("function() {\n let flag = [];\nfor(let i= 0,valLen = " + optionData + ".length;i < valLen;i++){\nflag.push(" + optionData + "[i]." + customValue + ");\n}\nreturn flag;}()");
        }
        return data;
    }

    private ComponentData getValueData() throws LcdpException {
        ComponentData valueData = new ComponentData();
        ArrayList<String> valueDataItem = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(this.lcdpComponent.getProps().get("selectType")) && "number".equals(this.lcdpComponent.getProps().get("selectType"))) {
            valueData.setDataType(ComponentData.DataTypeEnum.INTEGER);
        } else {
            valueData.setDataType(ComponentData.DataTypeEnum.STRING);
        }
        valueDataItem.add("value");
        valueData.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), valueDataItem));
        return valueData;
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return Collections.singletonList(new ComponentData(ComponentData.DataTypeEnum.STRING, ComponentData.DataItemSourceEnum.DATA, ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._DATA.getType(), Collections.singletonList("value"))));
    }
}

