<div
    <#list attributes!?keys as key>
        ${key}="${attributes[key]}"
    </#list>
    <#if (disabled??)>
        :class="{'disabled':${instanceKey!}Disabled}"
    </#if>
>
    <el-upload class="jxd-upload-item" :action="${instanceKey!}UploadApi" list-type="picture-card"
               <#if isReferData?? && isReferData!>:file-list="${instanceKey!}Files"</#if>
                <#if limit?? && limit! gt 0>
                    :limit="${limit!}" :on-exceed="${instanceKey!}HandleExceed"
                </#if>
               ref="${instanceKey!}Ref"
                :headers="${instanceKey!}Headers"
               :on-success="${instanceKey!}UploadSuccess"
               :before-upload="${instanceKey!}BeforeUpload"
                <#if isExistBig?? && isExistBig!>
                    :on-preview="${instanceKey!}HandlePictureCardPreview"
                </#if>

               <#--:on-remove="${instanceKey!}HandleRemove"-->
                :disabled="${instanceKey!}Disabled"
            multiple accept="image/jpeg,image/jpg,image/png">
    <i class="jxd-uploader-icon <#if iconClassName??>${iconClassName!}<#else>el-icon-plus</#if>"></i>
            <div slot="file" slot-scope="{ file }">
                <img-with-token class="el-upload-list__item-thumbnail" :authsrc="file.url"></img-with-token>
                <span class="el-upload-list__item-actions">
                    <span v-if="!${instanceKey!}Disabled" class="el-upload-list__item-delete" @click="${instanceKey!}HandleRemove(file)">
                        <i class="el-icon-delete"></i>
                    </span>
                </span>
            </div>
    </el-upload>
            <#if isExistBig?? && isExistBig!>
                 <el-dialog :append-to-body="true" :visible.sync="dialogVisible">
                  <img width="100%" :src="dialogImageUrl" alt="">
                 </el-dialog>
            </#if>

    <input type="hidden" v-model="${referData!}" />
<#--    <el-dialog class="jxd_ins_elDialog upload-img-dialog" :visible.sync="${instanceKey!}DialogVisible" :append-to-body=true>-->
<#--        <img :src="${instanceKey!}DialogUrl">-->
<#--    </el-dialog>-->
</div>
