<template>
    <#if isProduce?? && isProduce>
    <div class="lcdp_axe_main" v-show="alreadyLoad">
    <#else>
    <div class="lcdp_axe_main">
    </#if>
    <div class="lcdp_axe jxd_ins_elBaseWebPage jxd_additional ${pageName} ${rootInstanceKey}">
        ${body!}
        <#if showFlowFileDialog?? && showFlowFileDialog>
            <el-dialog class="flowchart-dialog"
                   :visible="${instanceKey!}ShowFlowFileDialog"
                   :show-close="false"
                   :append-to-body="true"
                   :close-on-click-modal="false"
                   :close-on-press-escape="false">
                <flowfile
                        v-if="${instanceKey!}ShowFlowFileDialog"
                        class="workflow"
                        :businessId="${instanceKey!}ShowPicProcessKey"
                        :show="${instanceKey!}ShowFlowFileDialog"
                        @close="${instanceKey!}ShowFlowFileDialog=false">
                </flowfile>
            </el-dialog>
        </#if>
        <#if showFlowFile?? && showFlowFile>
            <flowfile
                    v-if="${instanceKey!}ShowFlowFile"
                    class="workflow"
                    :businessId="${instanceKey!}ShowPicProcessKey"
                    :show="${instanceKey!}ShowFlowFile"
                    @close="${instanceKey!}ShowFlowFile=false">
            </flowfile>
        </#if>
        <#if participantDialog?? && participantDialog>
            <participantDialog @close="${instanceKey!}ParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmParticipant" :selectionBackup='${instanceKey!}SelectionBackup' :tableData ='${instanceKey!}ParticipantData'  :participantDialogVisible='${instanceKey!}ParticipantDialogVisible'>
            </participantDialog>
        </#if>
        <#if assignParticipantDialog?? && assignParticipantDialog>
            <assignParticipantDialog @close="${instanceKey!}AssignParticipantDialogVisible = false" @comfirm="${instanceKey!}ComfirmAssignParticipant" :selectionBackup='${instanceKey!}AssignSelectionBackup' :assignParticipantData ='${instanceKey!}AssignParticipantData' :assignParticipantDialogVisible='${instanceKey!}AssignParticipantDialogVisible'>
            </assignParticipantDialog>
        </#if>
        <#if consignorDialog?? && consignorDialog>
            <consignorDialog @close="${instanceKey!}ConsignorDialogVisible = false" @comfirm="${instanceKey!}ComfirmConsignor" :selectionBackup='${instanceKey!}SelectedConsignorBackup' :tableData ='${instanceKey!}ConsignorData'  :consignorDialogVisible='${instanceKey!}ConsignorDialogVisible'>
            </consignorDialog>
        </#if>
        <#if customFlowNode??>
            <#list customFlowNode as currentKey>
                <customFlowNode @addCustomNodeExecuteFunction="${instanceKey!}${currentKey!}AddCustomNodeExecuteFunction" @close="${instanceKey!}${currentKey!}CustomFlowNodeVisible = false" :customFlowNodeVisible="${instanceKey!}${currentKey!}CustomFlowNodeVisible" :taskId="${instanceKey!}${currentKey!}CustomFlowNodeTaskId" <#if customFlowNodeStrategy??>:strategy="true"<#else>:strategy="false"</#if>>
                </customFlowNode>
            </#list>
        </#if>
        <#if customFlowNodeSingle??>
            <#list customFlowNodeSingle as currentKey>
                <customFlowNodeSingle @addCustomNodeSignalExecuteFunction="${instanceKey!}${currentKey!}AddCustomNodeSignalExecuteFunction" @close="${instanceKey!}${currentKey!}CustomFlowNodeSingleVisible = false" :customFlowNodeVisible="${instanceKey!}${currentKey!}CustomFlowNodeSingleVisible" :taskId="${instanceKey!}${currentKey!}CustomFlowNodeSingleTaskId" <#if customFlowNodeSingleStrategy??>:strategy="true"<#else>:strategy="false"</#if>>
                </customFlowNodeSingle>
            </#list>
        </#if>
        <#if showSelectParticipant??>
            <#list showSelectParticipant as currentKey>
                <selectParticipant @close="${instanceKey!}${currentKey!}SelectParticipantShow = false" :selectParticipantShow="${instanceKey!}${currentKey!}SelectParticipantShow" @save="${instanceKey!}${currentKey!}FlowFormSubmitSave" :taskId="${instanceKey!}${currentKey!}TaskId" :processDefinitionKey="${instanceKey!}${currentKey!}ProcessDefinitionKey" :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'" <#if flowFormSubmitStrategy??>:strategy="true"<#else>:strategy="false"</#if>>
                </selectParticipant>
            </#list>
        </#if>
        <#if showSelectEntrust??>
            <#list showSelectEntrust as currentKey>
                <selectEntrust @close="${instanceKey!}${currentKey!}SelectEntrustShow = false" :selectEntrustShow="${instanceKey!}${currentKey!}SelectEntrustShow" @save="${instanceKey!}${currentKey!}TaskEntrustSave">
                </selectEntrust>
            </#list>
        </#if>
        <#if showSelectRejectNode??>
            <#list showSelectRejectNode as currentKey>
                <selectRejectNode @close="${instanceKey!}${currentKey!}SelectRejectNodeShow = false" :selectRejectNodeShow="${instanceKey!}${currentKey!}SelectRejectNodeShow" @save="${instanceKey!}${currentKey!}AnyNodeRejectSave" :taskId="${instanceKey!}${currentKey!}TaskId" :doneListIdentification="${instanceKey!}${currentKey!}DoneListIdentification ? ${instanceKey!}${currentKey!}DoneListIdentification : '0'" <#if anyNodeRejectStrategy??>:strategy="true"<#else>:strategy="false"</#if>>
                </selectRejectNode>
            </#list>
        </#if>
        <#if showFreeReject??>
            <#list showFreeReject as currentKey>
                <freeReject @freeRejectExecuteFunction="${instanceKey!}${currentKey!}FreeRejectExecuteFunction" @close="${instanceKey!}${currentKey!}FreeRejectShow = false" :freeRejectShow="${instanceKey!}${currentKey!}FreeRejectShow" :taskId="${instanceKey!}${currentKey!}FreeRejectTaskId" <#if freeRejectStrategy??>:strategy="true"<#else>:strategy="false"</#if> :flowEventData="${instanceKey!}${currentKey!}FlowEventData">
                </freeReject>
            </#list>
        </#if>
        <#if showCheckFlowSheetForm?? && showCheckFlowSheetForm>
            <showflow v-if="${rootInstanceKey!}ShowFlowDialog" class="workflow" :data1="${rootInstanceKey!}ProcessKey" :processKey="${rootInstanceKey!}ProcessKey" :show="${rootInstanceKey!}ShowFlowDialog" @close="${rootInstanceKey!}ShowFlowDialog=false">
            </showflow>
        </#if>
        ${slotCodes.default!}
        ${slot_title!}
        ${slotCodes.treeContextMenu!}
    </div>
    </div>
</template>

<script>
    <#list importScripts! as imp>
        ${imp};
    </#list>
    /* ${directives.definitionsBegin} */
    /* ${directives.definitionsEnd} */
    export default {
        name: "${pageName!}",
        components: {
                <#list components as component>
                ${component},
                </#list>
        },
        <#if props?? && (props?size>0)>
            props: {
            <#list props as prop>
                ${prop.paramName}: ${prop.paramDataType?cap_first},
            </#list>
                },
        </#if>
        data() {
            return {
                <#list datas as data>
                ${data},
                </#list>
                /* ${directives.dataBegin} */
                /* ${directives.dataEnd} */
            }
        },
        computed: {
            <#list computeds?keys as key>
                <#assign computed=computeds[key]>
                ${key}(${computed.argBody!}){
                    const self = this;
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            <#list computedWithGetSets?keys as key>
                <#assign computed=computedWithGetSets[key]>
                ${key}:{
                    <#list computed.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            /* ${directives.computedBegin} */
            /* ${directives.computedEnd} */
        },
        watch: {
            <#list watches?keys as key>
            <#assign watch=watches[key]>
                <#if (key!?index_of('\'') > -1)>
                    ${key}:{
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                <#else>
                    ${key}(${watch.argBody!}){
                        <#list watch.bodies as body>
                            ${body}
                        </#list>
                    },
                </#if>
            </#list>
            /* ${directives.watchBegin} */
            /* ${directives.watchEnd} */
        },
        methods: {
            <#list methods?keys as key>
                <#assign method=methods[key]>
                <#assign importName=key>
            <#if async?? && async?size gt 0>
            <#list async! as async_importName>
            <#if async_importName == key>
            <#assign importName=("async " + key)?string>
            </#if>
            </#list>
            </#if>
            ${importName}(${method.argBody!}){
                    const self = this;
                    <#list method.bodies as body>
                    ${body}
                    </#list>
                },
            </#list>
            /* ${directives.methodsBegin} */
            /* ${directives.methodsEnd} */
        },
        created() {
            const self = this;
            // ${directives.createdBeforeBegin}
            // ${directives.createdBeforeEnd}
            <#list createds! as created>
            ${created}
            </#list>
            // ${directives.createdAfterBegin}
            // ${directives.createdAfterEnd}
        },
        mounted() {
            const self = this;
            // ${directives.mountedBeforeBegin}
            // ${directives.mountedBeforeEnd}
            <#list mounteds! as mounted>
                ${mounted}
            </#list>
            <#if isOnload?? && isOnload>
                self.${rootInstanceKey!}Onload();
            </#if>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if polls?? && (polls?size>0)>
                    <#list polls as poll>
                        <#assign str = poll.eventName?cap_first/>
                        <#list methods?keys as key>
                            <#if key == rootInstanceKey + str>
                            self.${key}Destroy = setInterval(() => {
                            const self = this;
                                self.${key}();
                                },<#if poll.pollTime??>${poll.pollTime?c}</#if>);
                            </#if>
                        </#list>
                    </#list>
                </#if>
            </#if>
            <#if strategy??>
                window.curPageSelfFresh = function () {
                    if (_.has(self, 'jxd_0Activated')) {
                        self.jxd_0Activated();
                    }
                };
            </#if>
            // ${directives.mountedAfterBegin}
            // ${directives.mountedAfterEnd}
        },
        filters: {
            <#list filters?keys as key>
            <#assign filter=filters[key]>
            ${key}(${filter.argBody!}){
                <#list filter.bodies as body>
                ${body}
                </#list>
            },
            </#list>
        },
        destroyed() {
            const self = this;
            // ${directives.destroyedBeforeBegin}
            // ${directives.destroyedBeforeEnd}
            <#list destroyeds! as destroyed>
                ${destroyed}
            </#list>
            <#if pollSwitchMethod && pollSwitch?? && pollSwitch>
                <#if destroyPolls?? && (destroyPolls?size>0)>
                    <#list destroyPolls! as destroyPoll>
                        clearInterval(self.${destroyPoll});
                    </#list>
                </#if>
            </#if>
            // ${directives.destroyedAfterBegin}
            // ${directives.destroyedAfterEnd}
        },
        activated() {
            const self = this;
            // ${directives.activatedBeforeBegin}
            // ${directives.activatedBeforeEnd}
            <#list activateds! as activated>
            ${activated}
            </#list>
            <#if isActivated?? && isActivated>
                if(HussarRouter.query(self, 'refresh', <#if strategy??>true<#else>false</#if>)){
                    self.${rootInstanceKey!}Activated();
                }
            </#if>
            // ${directives.activatedAfterBegin}
            // ${directives.activatedAfterEnd}
        },
        <#if !strategy??>
            beforeRouteUpdate(to, from, next){
                const self = this;
                next();
                if (to.query && to.query.systemParams && JSON.parse(to.query.systemParams).refresh === 1) {
                    self.jxd_0Activated();
                }
            },
        </#if>
        deactivated() {
            const self = this;
            // ${directives.deactivatedBeforeBegin}
            // ${directives.deactivatedBeforeEnd}
            <#list deactivateds! as deactivated>
            ${deactivated}
            </#list>
            // ${directives.deactivatedAfterBegin}
            // ${directives.deactivatedAfterEnd}
        },
        /* ${directives.optionsBegin} */
        /* ${directives.optionsEnd} */
}
</script>

<!-- ${directives.styleBeforeBegin} -->
<!-- ${directives.styleBeforeEnd} -->

<style scoped>
    /*公共，用于固定*/
    .lcdp_axe_main{transform: scale(1);height: 100%;overflow: auto}
    /*公共，用于设置文字提示的最大宽度*/
    .el-tooltip__popper{
        max-width: 500px;
    }
    ${styles!}
    ${hyperlinksSpan}
</style>

<#if hasNonScopedStyles>
<style>
    ${nonScopedStyles!}
</style>
</#if>

<!-- ${directives.styleAfterBegin} -->
<!-- ${directives.styleAfterEnd} -->
