/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.codegenerator.core.data.model.ComponentReference;
import com.jxdinfo.hussar.speedcode.codegenerator.core.model.ComponentData;
import com.jxdinfo.hussar.speedcode.codegenerator.core.util.DataConfigUtil;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.showconfig.ShowConfigAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.table.TableOptColsAnalysis;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.speedcode.common.utils.ReplaceDataUtil;
import com.jxdinfo.hussar.speedcode.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.speedcode.datasource.model.meta.dataset.DataSet;
import com.jxdinfo.hussar.speedcode.generate.dto.DataModelDto;
import com.jxdinfo.hussar.speedcode.util.datamodel.DataModelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class TicketVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/ticket/ticket.ftl");
        lcdpComponent.addRenderParam("instanceKey", (Object)lcdpComponent.getInstanceKey());
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderComputed(lcdpComponent, ctx);
        ctx.addComponent("ImgWithToken");
        ctx.addImports("import { ImgWithToken } from 'hussar-base'");
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) {
        String instanceKey = lcdpComponent.getInstanceKey();
        ctx.addData(instanceKey + "Visible: false");
        ctx.addData(instanceKey + "ImageUrl: ''");
        ctx.addData(instanceKey + "ImageList: []");
        ctx.addData(instanceKey + "ImageUrlList: []");
        ctx.addData(instanceKey + "Loading: false");
        ctx.addData(instanceKey + "Exists: true");
        ctx.addData(instanceKey + "UploadApi: process.env.VUE_APP_HUSSAR_DEFAULT_API + '/attachment/uploadfilewithdrag'");
        ctx.addData("httpApi: process.env.VUE_APP_HUSSAR_DEFAULT_API");
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        JSONObject bindFileId;
        HashMap<String, Object> params = new HashMap<String, Object>();
        List showConfigAnalyses = ReplaceDataUtil.getReplaceDataInfo((LcdpComponent)lcdpComponent, (String)"showConfigs");
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        if (ToolUtil.isNotEmpty(lcdpComponent.getProps().get("bindFileId")) && ToolUtil.isNotEmpty((Object)(bindFileId = (JSONObject)lcdpComponent.getProps().get("bindFileId")).get((Object)"setReference"))) {
            ArrayList<String> tableItem = new ArrayList<String>();
            tableItem.add("value");
            JSONObject referObj = (JSONObject)bindFileId.get((Object)"setReference");
            ComponentReference tableRefer = new ComponentReference(referObj.getString("instanceKey"), tableItem);
            if (ToolUtil.isNotEmpty((Object)tableRefer.getInstanceKey())) {
                LcdpComponent bindTable = (LcdpComponent)ctx.getComponentMap().get(String.valueOf(referObj.getString("instanceKey")));
                params.put("attachId", tableRefer.getInstanceKey());
                ComponentData data = DataConfigUtil.getDataConfigValue((Ctx)ctx, (ComponentReference)tableRefer);
                if (null != data) {
                    params.put("tableData", data.getRenderValue());
                    params.putAll(this.getMapping(referObj, bindTable));
                }
            }
        }
        params.putAll(this.getTicketApi(lcdpComponent, ctx, showConfigAnalyses));
        Boolean isUploadSize = (Boolean)lcdpComponent.getProps().get("isUploadSize");
        Integer fileUploadSize = (Integer)lcdpComponent.getProps().get("fileUploadSize");
        String fileUploadUnit = (String)lcdpComponent.getProps().get("fileUploadUnit");
        params.put("isUploadSize", isUploadSize);
        params.put("fileUploadSize", fileUploadSize);
        params.put("fileUploadUnit", fileUploadUnit);
        ctx.addImports("import hussarRequest from '@/pages/index/utils/hussar-default-request'");
        ctx.addMethod(lcdpComponent.getInstanceKey() + "BeforeUpload", Collections.singletonList("file"), RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_beforeUpload.ftl", params));
        ctx.addMethod(lcdpComponent.getInstanceKey() + "UploadSuccess", Collections.singletonList("param"), RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_uploadSuccess.ftl", params));
        ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleRemove", Collections.singletonList("index"), RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_handleRemove.ftl", params));
        ctx.addMethod(lcdpComponent.getInstanceKey() + "ImageView", Collections.singletonList("item"), RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_imageView.ftl", params));
        ctx.addMethod(lcdpComponent.getInstanceKey() + "CloseView", RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_closeView.ftl", params));
        ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleChange", Collections.singletonList("file, fileList"), RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_handleChange.ftl", params));
        ctx.addMethod(lcdpComponent.getInstanceKey() + "HandlePreview", Collections.singletonList("index"), RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_handlePreview.ftl", params));
        Integer limit = (Integer)lcdpComponent.getProps().get("limit");
        if (ToolUtil.isNotEmpty((Object)limit) && limit > 0) {
            params.put("limit", limit);
            ctx.addMethod(lcdpComponent.getInstanceKey() + "HandleExceed", Collections.singletonList("files, fileList"), RenderUtil.renderTemplate((String)"/template/elementui/element/ticket/ticket_handleExceed.ftl", params));
        }
    }

    private void renderComputed(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        if (!ctx.getComputeds().containsKey("headers")) {
            String headers = RenderUtil.renderTemplate((String)"template/elementui/element/ticket/ticket_computed.ftl", new HashMap(1));
            ctx.addComputed("headers", headers);
        }
    }

    private Map<String, Object> getTicketApi(LcdpComponent lcdpComponent, Ctx ctx, List<ShowConfigAnalysis> showConfigAnalyses) throws Exception {
        String formDataModelID;
        DataSModelAnalysis formDataModel;
        HashMap<String, Object> params = new HashMap<String, Object>();
        DataSAnalysis ticketDataS = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        if (ToolUtil.isNotEmpty((Object)ticketDataS) && ToolUtil.isNotEmpty((Object)(formDataModel = ticketDataS.getDatamodel())) && ToolUtil.isNotEmpty((Object)(formDataModelID = formDataModel.getDataModelId())) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)formDataModelID))) {
            DataModelDto dataModelDto = DataModelUtil.getDataModelDto((String)formDataModelID);
            String Url = Optional.ofNullable(DataModelUtil.getDataSourceConfigByName((String)dataModelDto.getDataSourceName())).map(DatasourceConfigDTO::getUrl).orElse("");
            List list = new ArrayList();
            list = DataModelUtil.getDataModelBase((String)formDataModelID).getOperations();
            String dataModelId = "";
            AtomicReference<String> apiName = new AtomicReference<String>("");
            AtomicReference<String> paramName = new AtomicReference<String>("");
            JSONObject datas = JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()));
            if (ToolUtil.isNotEmpty((Object)datas) && ToolUtil.isNotEmpty((Object)datas.get((Object)"datamodel"))) {
                Map datamodel = (Map)datas.get((Object)"datamodel");
                String finalDataModelId = dataModelId = (String)datamodel.get("operationName");
                Map dataSetMap = dataModelDto.getDataSetMap();
                list.forEach(item -> {
                    if (finalDataModelId.equals(item.getId())) {
                        apiName.set(item.getApi().getUrl());
                        String enterParam = item.getEnterParam();
                        if (ToolUtil.isNotEmpty(dataSetMap.get(enterParam))) {
                            paramName.set(((DataSet)dataSetMap.get(enterParam)).getName());
                        }
                    }
                });
            }
            params.put("apiName", apiName);
            params.put("paramName", paramName);
            params.put("api", Url);
        }
        return params;
    }

    private Map<String, Object> getMapping(JSONObject referObj, LcdpComponent bindValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONObject mapping = (JSONObject)referObj.get((Object)"mapping");
        if (ToolUtil.isNotEmpty((Object)mapping)) {
            JSONArray formColsJSONArray;
            JSONArray fromHiddenColsJSONArray;
            Map m = (Map)JSON.parseObject((String)mapping.toJSONString(), (TypeReference)new TypeReference<Map<String, ArrayList<String>>>(){}, (Feature[])new Feature[0]);
            List listFrom = new ArrayList();
            JSONArray fromColsJSONArray = (JSONArray)bindValue.getProps().get("opt_cols");
            if (ToolUtil.isNotEmpty((Object)fromColsJSONArray)) {
                listFrom = JSON.parseArray((String)fromColsJSONArray.toJSONString(), TableOptColsAnalysis.class);
                params.put("isTable", "true");
            }
            if (ToolUtil.isNotEmpty((Object)(fromHiddenColsJSONArray = (JSONArray)bindValue.getProps().get("hidden_cols")))) {
                List listHiddenFrom = JSON.parseArray((String)fromHiddenColsJSONArray.toJSONString(), TableOptColsAnalysis.class);
                listFrom.addAll(listHiddenFrom);
            }
            if (ToolUtil.isNotEmpty((Object)(formColsJSONArray = (JSONArray)bindValue.getProps().get("component_cols")))) {
                listFrom = JSON.parseArray((String)formColsJSONArray.toJSONString(), TableOptColsAnalysis.class);
                params.put("isForm", "true");
            }
            ArrayList<String> list = new ArrayList<String>();
            HashMap<String, String> bindParam = new HashMap<String, String>();
            ArrayList<String> unbindParam = new ArrayList<String>();
            block0: for (Map.Entry entry : m.entrySet()) {
                String key = (String)entry.getKey();
                if (((ArrayList)m.get(key)).size() <= 1) continue;
                String fromId = (String)((ArrayList)m.get(key)).get(1);
                list.add(fromId);
                for (TableOptColsAnalysis tableOptColsAnalysis : listFrom) {
                    if (!tableOptColsAnalysis.getId().equals(fromId)) continue;
                    if ("invoiceID".equals(key)) {
                        params.put(key, tableOptColsAnalysis.getField());
                        continue block0;
                    }
                    bindParam.put(key, tableOptColsAnalysis.getField());
                    continue block0;
                }
            }
            block2: for (TableOptColsAnalysis tableOptColsAnalysis : listFrom) {
                for (String s : list) {
                    if (tableOptColsAnalysis.getId().equals(s)) continue block2;
                    if (!s.equals(list.get(list.size() - 1))) continue;
                    unbindParam.add(tableOptColsAnalysis.getField());
                }
            }
            params.put("bindParam", bindParam);
            params.put("unbindParam", unbindParam);
        }
        return params;
    }
}

