/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.speedcode.codegenerator.core.action.EventConfig;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.file.FileMappingService;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.SpringUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.speedcode.common.utils.EventUtil;
import com.jxdinfo.hussar.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IoTVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("/template/elementui/element/IoT/el_IoT.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderWatch(lcdpComponent, ctx);
        this.renderDataLoad(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        lcdpComponent.addAttr(":type", lcdpComponent.getInstanceKey() + "Type");
        ctx.addData(lcdpComponent.getInstanceKey() + "Type:'" + lcdpComponent.getProps().get("select") + "'");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) {
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormMounted(lcdpComponent, ctx);
        if (lcdpComponent.getProps().get("readonly") != null) {
            String instanceKey = lcdpComponent.getInstanceKey();
            String isReadonly = instanceKey + "Readonly";
            lcdpComponent.addAttr(":class", isReadonly + " ? 'jxd_ins_elIoTReadonly' : ''");
        }
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String valueData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._DATA.getType(), null, (String)String.valueOf(37.2));
        lcdpComponent.addRenderParam("valueData", (Object)valueData);
        ctx.addData(lcdpComponent.getInstanceKey() + "ThresholdList: " + lcdpComponent.getProps().get("thresholdList"));
        ctx.addData(lcdpComponent.getInstanceKey() + "Gauge: null");
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map props = lcdpComponent.getProps();
        String str = (String)lcdpComponent.getStyles().get("width");
        Integer width = Integer.parseInt(str.substring(0, str.indexOf("px")));
        params.put("width", width);
        params.put("value", lcdpComponent.getRenderParams().get("valueData"));
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        params.put("progressMax", props.get("progressMax"));
        params.put("progressMin", props.get("progressMin"));
        params.put("progressColor", props.get("progressColor"));
        params.put("unit", props.get("unit"));
        params.put("toFixed", props.get("toFixed"));
        params.put("name", props.get("name"));
        params.put("axisLabelDistance", props.get("axisLabelDistance"));
        params.put("axisLabelColor", props.get("axisLabelColor"));
        params.put("axisLabelSize", props.get("axisLabelSize"));
        params.put("gaugeTitleColor", props.get("gaugeTitleColor"));
        params.put("gaugeTitleFontSize", props.get("gaugeTitleFontSize"));
        params.put("gaugeTitleFontWeight", props.get("gaugeTitleFontWeight"));
        params.put("gaugeTitleFontFamily", props.get("gaugeTitleFontFamily"));
        params.put("gaugeValueFontSize", props.get("gaugeValueFontSize"));
        params.put("gaugeValueFontWeight", props.get("gaugeValueFontWeight"));
        params.put("gaugeValueFontFamily", props.get("gaugeValueFontFamily"));
        params.put("isThreshold", props.get("isThreshold"));
        if ("progressBarStyle".equals(props.get("changeStyle"))) {
            ctx.addMethod(lcdpComponent.getInstanceKey() + "InitStatus", Collections.singletonList("cubeCount"), RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/ioT_initProgress.ftl", params));
            ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "InitStatus(100);");
        }
        if ("gaugeStyle".equals(props.get("changeStyle"))) {
            ctx.addImports("import Echarts5 from '../../utils/echartsUi'");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "Option", RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/ioT_option.ftl", params));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "DrawGauge", Collections.singletonList("cubeCount"), RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/ioT_drawGauge.ftl", params));
            ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "DrawGauge();");
        }
    }

    private void renderWatch(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map props = lcdpComponent.getProps();
        params.put("instanceKey", lcdpComponent.getInstanceKey());
        params.put("gaugeValueColor", props.get("gaugeValueColor"));
        params.put("gaugeStyle", props.get("changeStyle"));
        List eventConfigs = lcdpComponent.getEvents();
        if (lcdpComponent.haveTriggerByTriggerName("threshold")) {
            params.put("isThresholdEvent", true);
            if (ToolUtil.isNotEmpty((Object)eventConfigs)) {
                for (EventConfig eventConfig : eventConfigs) {
                    if (!"threshold".equals(eventConfig.getTrigger())) continue;
                    lcdpComponent.getTriggers().remove("threshold");
                }
            }
        }
        if ("gaugeStyle".equals(props.get("changeStyle"))) {
            ctx.addData(lcdpComponent.getInstanceKey() + "Color:'" + props.get("gaugeValueColor") + "'");
        }
        ctx.addWatch(lcdpComponent.getInstanceKey() + "Data", Collections.singletonList("n"), RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/ioT_watch.ftl", params));
    }

    private void renderDataLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Map props = lcdpComponent.getProps();
        DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
        DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
        if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
            DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
            Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
            String valueField = "";
            if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                    List fieldAnalyses = (List)fieldList.getValue();
                    for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                        List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                        if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"value".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                        valueField = dataSFieldAnalysis.getFieldName();
                    }
                }
            }
            if (ToolUtil.isNotEmpty((Object)valueField)) {
                String sortConditionName;
                DataSortConditionAnalysis dataSortConditionAnalysis;
                String querySelectionName;
                List conditionList;
                String operationName = "hussarQuery";
                String apiFileName = "";
                String apiFilePath = "";
                String dataModelId = dataSModelAnalysis.getDataModelId();
                if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                    apiFileName = this.fileMappingService.getFileName(dataModelId);
                    apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                }
                if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                    param.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                    param.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                }
                if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                    operationName = operationName + querySelectionName;
                }
                if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                    operationName = operationName + sortConditionName;
                }
                if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                    EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                }
                param.put("importName", apiFileName);
                param.put("importMethod", operationName);
                param.put("ioTValue", valueField);
                param.put("strategy", ctx.getStrategy());
                param.put("toFixed", props.get("toFixed"));
                param.put("changeStyle", props.get("changeStyle"));
                param.put("instanceKey", lcdpComponent.getInstanceKey());
                param.put("valueData", lcdpComponent.getRenderParams().get("valueData"));
                ctx.addMethod(lcdpComponent.getInstanceKey() + "IoTDataLoad", RenderUtil.renderTemplate((String)"/template/elementui/element/IoT/el_IoT_data.ftl", param));
                ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "IoTDataLoad();");
                ctx.addMounted("self." + lcdpComponent.getInstanceKey() + "PollNameDestroy = setInterval(() => {const self = this;self." + lcdpComponent.getInstanceKey() + "IoTDataLoad();}, " + props.get("refreshFrequency") + "000);");
                ctx.addDestroyeds("clearInterval(self." + lcdpComponent.getInstanceKey() + "PollNameDestroy);");
            }
        }
    }
}

