/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSFieldAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSModelAnalysis;
import com.jxdinfo.hussar.speedcode.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.speedcode.common.constant.CodePrefix;
import com.jxdinfo.hussar.speedcode.common.constant.CodeSuffix;
import com.jxdinfo.hussar.speedcode.common.exception.LcdpException;
import com.jxdinfo.hussar.speedcode.common.file.FileMappingService;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.SpringUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.speedcode.common.utils.DealFormDataVisitor;
import com.jxdinfo.hussar.speedcode.common.utils.EventUtil;
import com.jxdinfo.hussar.speedcode.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.speedcode.common.utils.RenderVModelUtil;
import com.jxdinfo.hussar.speedcode.util.datamodel.DataModelUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DoughnutEchartsVisitor
implements VoidVisitor {
    private FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);

    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        lcdpComponent.registerTemplatePath("/template/elementui/element/doughnutEcharts/doughnut_echarts.ftl");
        this.renderAttrs(lcdpComponent, ctx);
        this.renderMounted(lcdpComponent, ctx);
        this.renderMethod(lcdpComponent, ctx);
        this.renderData(lcdpComponent, ctx);
    }

    private void renderAttrs(LcdpComponent lcdpComponent, Ctx ctx) {
        lcdpComponent.addAttr("ref", lcdpComponent.getInstanceKey() + "Ref");
        DealFormDataVisitor dealFormDataVisitor = new DealFormDataVisitor();
        dealFormDataVisitor.dealRelateFormAttr(lcdpComponent, ctx);
    }

    private void renderMounted(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        HashMap<String, String> instanceKey = new HashMap<String, String>();
        instanceKey.put("instanceKey", lcdpComponent.getInstanceKey());
        if (lcdpComponent.isVerticalFill() || lcdpComponent.isHorizontalFill()) {
            ctx.addMounted(RenderUtil.renderTemplate((String)"/template/elementui/element/eChartsResize/echarts_resize.ftl", instanceKey));
        }
    }

    private void renderData(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException {
        String instanceKey = lcdpComponent.getInstanceKey();
        Integer height = lcdpComponent.getHeight();
        Integer width = lcdpComponent.getWidth();
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderTop"))) {
            String borderTop = String.valueOf(lcdpComponent.getStyles().get("borderTop"));
            ctx.addData(instanceKey + "BorderTop: " + borderTop.substring(0, borderTop.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderBottom"))) {
            String borderBottom = String.valueOf(lcdpComponent.getStyles().get("borderBottom"));
            ctx.addData(instanceKey + "BorderBottom: " + borderBottom.substring(0, borderBottom.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderLeft"))) {
            String borderLeft = String.valueOf(lcdpComponent.getStyles().get("borderLeft"));
            ctx.addData(instanceKey + "BorderLeft: " + borderLeft.substring(0, borderLeft.indexOf("px")));
        }
        if (ToolUtil.isNotEmpty(lcdpComponent.getStyles().get("borderRight"))) {
            String borderRight = String.valueOf(lcdpComponent.getStyles().get("borderRight"));
            ctx.addData(instanceKey + "BorderRight: " + borderRight.substring(0, borderRight.indexOf("px")));
        }
        ctx.addData(instanceKey + "Height: " + height);
        ctx.addData(instanceKey + "Width: " + width);
        ctx.addData(instanceKey + "Data: null");
        ctx.addData(instanceKey + "QueryData: {name: '',value: '',}");
    }

    private void renderMethod(LcdpComponent lcdpComponent, Ctx ctx) throws LcdpException, IOException {
        Map echartsMaps;
        HashMap<String, Object> echartsParams = new HashMap<String, Object>();
        echartsParams.put("instanceKey", lcdpComponent.getInstanceKey());
        echartsParams.put("strategy", ctx.getStrategy());
        String optionData = RenderVModelUtil.renderDataItemDataOrComputed((LcdpComponent)lcdpComponent, (Ctx)ctx, (String)CodeSuffix._OPTION_DATA.getType(), Collections.singletonList("data"), (String)"{\nseriesResult: [],\nlegendEchart: [],\n}");
        echartsParams.put("optionData", CodePrefix._SELF.getType() + optionData);
        if (!ComponentDataUtil.ComponentValueStatusEnum.NONE.equals((Object)ComponentDataUtil.getComponentValueStatus((LcdpComponent)lcdpComponent, (Ctx)ctx, Collections.singletonList("data")))) {
            echartsParams.put("isQuoteOrGetValue", "true");
        }
        if (ToolUtil.isNotEmpty((Object)(echartsMaps = lcdpComponent.getProps()))) {
            echartsParams.put("titleText", echartsMaps.get("title"));
            echartsParams.put("titleColor", ToolUtil.isNotEmpty(echartsMaps.get("titleColor")) ? echartsMaps.get("titleColor") : "#000");
            echartsParams.put("titleFontSize", ToolUtil.isNotEmpty(echartsMaps.get("titleFontSize")) ? echartsMaps.get("titleFontSize") : "18");
            echartsParams.put("fontFamily", echartsMaps.get("fontFamily"));
            echartsParams.put("fontStyle", echartsMaps.get("fontStyle"));
            echartsParams.put("fontWeight", echartsMaps.get("fontWeight"));
            echartsParams.put("titleAlign", ToolUtil.isNotEmpty(echartsMaps.get("titleAlign")) ? echartsMaps.get("titleAlign") : "center");
            echartsParams.put("numberOfRow", ToolUtil.isNotEmpty(echartsMaps.get("numberOfRow")) ? echartsMaps.get("numberOfRow") : "10");
            echartsParams.put("titleTop", echartsMaps.get("titleTop"));
            echartsParams.put("titleBackgroundColor", ToolUtil.isNotEmpty(echartsMaps.get("titleBackgroundColor")) ? echartsMaps.get("titleBackgroundColor") : "transparent");
            String topicColorStr = "";
            String colorSystem = echartsMaps.get("colorSystem").toString();
            if ("colour".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("colourColor").toString();
            } else if ("green".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("greenColor").toString();
            } else if ("blue".equals(colorSystem)) {
                topicColorStr = echartsMaps.get("blueColor").toString();
            }
            echartsParams.put("topicColorStr", topicColorStr);
            echartsParams.put("withinRadius", echartsMaps.get("withinRadius").toString());
            echartsParams.put("outsideRadius", echartsMaps.get("outsideRadius").toString());
            echartsParams.put("topicSize", echartsMaps.get("topicSize").toString());
            echartsParams.put("tooltipBgColor", echartsMaps.get("tooltipBgColor"));
            echartsParams.put("toolColor", echartsMaps.get("toolColor"));
            echartsParams.put("toolFontSize", ToolUtil.isNotEmpty(echartsMaps.get("toolFontSize")) ? echartsMaps.get("toolFontSize") : "18");
            echartsParams.put("toolFontFamily", echartsMaps.get("toolFontFamily"));
            echartsParams.put("toolFontWeight", echartsMaps.get("toolFontWeight"));
            echartsParams.put("toolFontStyle", echartsMaps.get("toolFontStyle"));
            echartsParams.put("toolLineHeight", echartsMaps.get("toolLineHeight"));
            echartsParams.put("isShowFlag", echartsMaps.get("isShowFlag"));
            echartsParams.put("legendLocation", ToolUtil.isNotEmpty(echartsMaps.get("legendLocation")) ? echartsMaps.get("legendLocation") : "center");
            echartsParams.put("legendIcon", echartsMaps.get("legendIcon"));
            echartsParams.put("legendColor", ToolUtil.isNotEmpty(echartsMaps.get("legendColor")) ? echartsMaps.get("legendColor") : "#000000");
            echartsParams.put("legendFontSize", ToolUtil.isNotEmpty(echartsMaps.get("legendFontSize")) ? echartsMaps.get("legendFontSize") : "14");
            echartsParams.put("legendFontFamily", echartsMaps.get("legendFontFamily"));
            echartsParams.put("legendFontWeight", echartsMaps.get("legendFontWeight"));
            echartsParams.put("legendFontStyle", echartsMaps.get("legendFontStyle"));
            DataSAnalysis dataSAnalysis = (DataSAnalysis)JSON.parseObject((String)JSON.toJSONString((Object)lcdpComponent.getDatas()), DataSAnalysis.class);
            DataSModelAnalysis dataSModelAnalysis = dataSAnalysis.getDatamodel();
            if (ToolUtil.isNotEmpty((Object)dataSModelAnalysis)) {
                DataSConditionAnalysis dataSConditionAnalysis = dataSModelAnalysis.getCondition();
                Map dataSFieldAnalysisMap = dataSModelAnalysis.getFields();
                String valueField = "";
                String legendField = "";
                if (ToolUtil.isNotEmpty((Object)dataSFieldAnalysisMap)) {
                    for (Map.Entry fieldList : dataSFieldAnalysisMap.entrySet()) {
                        List fieldAnalyses = (List)fieldList.getValue();
                        for (DataSFieldAnalysis dataSFieldAnalysis : fieldAnalyses) {
                            List dataItemPath = dataSFieldAnalysis.getDataItemPath();
                            if (ToolUtil.isNotEmpty((Object)dataItemPath) && "value".equals(dataItemPath.get(dataItemPath.size() - 1))) {
                                valueField = dataSFieldAnalysis.getFieldName();
                            }
                            if (!ToolUtil.isNotEmpty((Object)dataItemPath) || !"legend".equals(dataItemPath.get(dataItemPath.size() - 1))) continue;
                            legendField = dataSFieldAnalysis.getFieldName();
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)legendField) && ToolUtil.isNotEmpty((Object)valueField)) {
                    String sortConditionName;
                    DataSortConditionAnalysis dataSortConditionAnalysis;
                    String querySelectionName;
                    List conditionList;
                    String operationName = "hussarQuery";
                    String dataSelectId = lcdpComponent.getInstanceKey();
                    String apiFileName = "";
                    String apiFilePath = "";
                    String dataModelId = dataSModelAnalysis.getDataModelId();
                    if (ToolUtil.isNotEmpty((Object)dataModelId) && ToolUtil.isNotEmpty((Object)DataModelUtil.getDataModelBase((String)dataModelId))) {
                        apiFileName = this.fileMappingService.getFileName(dataModelId);
                        apiFilePath = this.fileMappingService.getImportPath(dataModelId);
                    }
                    if (ToolUtil.isNotEmpty((Object)dataSConditionAnalysis) && ToolUtil.isNotEmpty((Object)(conditionList = dataSConditionAnalysis.getQueryConditionModelList()))) {
                        echartsParams.put("queryAttr", QueryAttrUtil.getQueryAttr((List)conditionList, (Ctx)ctx));
                        echartsParams.put("queryCheck", QueryAttrUtil.getQueryCheck((List)conditionList, (String)apiFileName).toString());
                    }
                    if (ToolUtil.isNotEmpty((Object)(querySelectionName = dataSConditionAnalysis.getSelectCondition()))) {
                        operationName = operationName + querySelectionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = dataSModelAnalysis.getSortCondition())) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
                        operationName = operationName + sortConditionName;
                    }
                    if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
                        EventUtil.addCtxImport((Ctx)ctx, (String)apiFileName, (String)apiFilePath);
                    }
                    echartsParams.put("importName", apiFileName);
                    echartsParams.put("importMethod", operationName);
                    echartsParams.put("xAxisCols", legendField);
                    echartsParams.put("seriesCols", valueField);
                }
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("n");
            ctx.addComputed(lcdpComponent.getInstanceKey() + "EchartsData", RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_computed.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "EchartsData", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch_query.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderBottom", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderRight", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderLeft", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "BorderTop", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Height", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "Width", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch.ftl", echartsParams));
            ctx.addWatch(lcdpComponent.getInstanceKey() + "OptionData", args, RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_watch.ftl", echartsParams));
            ctx.addMethod(lcdpComponent.getInstanceKey() + "OptionItem", RenderUtil.renderTemplate((String)"/template/elementui/element/doughnutEcharts/doughnut_echarts_success.ftl", echartsParams));
            ctx.addMounted("this." + lcdpComponent.getInstanceKey() + "OptionItem();");
        }
    }
}

