/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.ClassAdapter;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.ClazzFactory;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.InteractiveClassFactory;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.StyleFactory;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.elementui.common.utils.TextAlignForVertical;
import com.jxdinfo.hussar.speedcode.elementui.visitor.element.ButtonVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class Button
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.elementui.JXDElButton";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"hover", (String)":hover:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"focus", (String)".button_additional:focus:not(.is-disabled)");
        InteractiveClassFactory.addComponentSceneClass((String)name, (String)"disabled", (String)":disabled");
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_elButton");
    }

    public VoidVisitor visitor() {
        return new ButtonVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("iconFontWeight", "${prefix} span i{font-weight:${val};}");
        map.put("buttonMarginLeft", "${prefix} {margin-left:${val};}");
        map.put("iconFontSize", "${prefix} span i{font-size:${val};}");
        map.put("itemAlign", "${prefix} > span {align-items:${val};}");
        map.put("itemJustifyContent", "${prefix} > span {justify-content:${val};}");
        map.put("itemDisplay", "${prefix} > span {display:${val};}");
        return map;
    }

    public static Button newComponent(JSONObject jsonObject) {
        Button button = (Button)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)Button.class.getName()));
        Object backgroundImg = button.getStyles().get("backgroundImageBack");
        button.getStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            button.getStyles().put("backgroundImage", backgroundImg);
        }
        TextAlignForVertical.setTextAlign(button, "styles");
        button.getStyles().remove("vertical");
        button.getInnerStyles().put("iconFontWeight", "normal");
        button.getInnerStyles().put("buttonMarginLeft", "0");
        Object fontSize = button.getStyles().get("fontSize");
        button.getInnerStyles().put("iconFontSize", fontSize);
        button.addClassName("button_additional");
        return button;
    }
}

