const resultSeries = [];
const xPaddingTop = parseInt('${xPaddingTop!}', 10);
const xPaddingRight = parseInt('${xPaddingRight!}', 10);
const xPaddingBottom = parseInt('${xPaddingBottom!}', 10);
const xPaddingLeft = parseInt('${xPaddingLeft!}', 10);
const yBarPaddingTop = parseInt('${yBarPaddingTop!}', 10);
const yBarPaddingRight = parseInt('${yBarPaddingRight!}', 10);
const yBarPaddingBottom = parseInt('${yBarPaddingBottom!}', 10);
const yBarPaddingLeft = parseInt('${yBarPaddingLeft!}', 10);
const yLinePaddingTop = parseInt('${yLinePaddingTop!}', 10);
const yLinePaddingRight = parseInt('${yLinePaddingRight!}', 10);
const yLinePaddingBottom = parseInt('${yLinePaddingBottom!}', 10);
const yLinePaddingLeft = parseInt('${yLinePaddingLeft!}', 10);
const type = [];
const seriesLineWidth = parseInt('${seriesLineWidth!}', 10);
const numberOfRow = (parseInt('${numberOfRow!}', 10) <= 0 ? 1 : parseInt('${numberOfRow!}', 10));
const oldTitle = '${titleText!}';
let newTitle = '';
if (oldTitle) {
    const titleLength = oldTitle.length;
    const provideLength = numberOfRow;
    const rowNumber = Math.ceil(titleLength / provideLength);
    if (titleLength > provideLength) {
        for (let i = 0; i < rowNumber; i++) {
            let tempStr = ' ';
            const start = i * provideLength;
            const end = start + provideLength;
            if (i === rowNumber - 1) {
                tempStr = oldTitle.substring(start, titleLength);
            } else {
                tempStr = oldTitle.substring(start, end) + '\n';
            }
            newTitle += tempStr;
        }
    } else {
        newTitle = oldTitle;
    }
}
const echatrsTitle = {
    text: newTitle,
    textStyle: {
        color: '${titleColor!}',
        fontSize: '${titleFontSize!}',
        fontFamily: '${fontFamily!}',
        fontWeight: '${fontWeight!}',
        fontStyle: '${fontStyle!}',
    },
    left: '${titleAlign!}',
    top: '${titleTop!}',
<#if (titleBackgroundColor?? && titleBackgroundColor != "")>
    backgroundColor: '${titleBackgroundColor!}',
</#if>
};
const echatrsTooltip = {
    trigger: 'axis',
    backgroundColor: '${tooltipBgColor!}',
    axisPointer: {
        type: 'cross',
        crossStyle: {
            color: '#999'
        }
    },
    textStyle: {
        color: '${toolColor!}',
        fontSize: '${toolFontSize!}',
        fontFamily: '${toolFontFamily!}',
        fontWeight: '${toolFontWeight!}',
        fontStyle: '${toolFontStyle!}',
    },
};
<#--网格-->
const grid = {
    left: '${gridLeft!}',
    top: '${gridTop!}',
    right: '${gridRight!}',
    bottom: '${gridBottom!}',
    containLabel: ${containLabel?string!},
};
const textStyle = {
    color: '${legendColor!}',
    fontSize: '${legendFontSize!}',
    fontFamily: '${legendFontFamily!}',
    fontWeight: '${legendFontWeight!}',
    fontStyle: '${legendFontStyle!}',
};
const nameTextStyle = {
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
    padding: [xPaddingTop, xPaddingRight, xPaddingBottom, xPaddingLeft],
};
const axisLine = {
    show: false,
    type: 'solid',
    lineStyle: {
        width: '${lineWidth!}',
        color: '${lineColor!}',
    },
};
const axisLabel = {
    show: true,
    color: '${xyColor!}',
    fontSize: '${xyFontSize!}',
    fontFamily: '${xyFontFamily!}',
    fontWeight: '${xyFontWeight!}',
    fontStyle: '${xyFontStyle!}',
};
const yAxis = [{
    type: 'value',
    name: '${yBarAxisName!}',
    nameGap: '${yNameGap!}',
<#if barMin??>
    min: '${barMin}',
</#if>
<#if barMax??>
    max: '${barMax}',
</#if>
    nameLocation: '${nameLocation!}',
    nameTextStyle: {
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        fontStyle: '${xyFontStyle!}',
        padding: [yBarPaddingTop, yBarPaddingRight, yBarPaddingBottom, yBarPaddingLeft],
    },
    axisLine: {
        show: false,
        type: 'solid',
        lineStyle: {
            width: '${lineWidth!}',
            color: '${lineColor!}',
        },
    },
    axisLabel: {
        show: true,
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        fontStyle: '${xyFontStyle!}',
        formatter: `{value}${barUnit!}`,
    },
}, {
    type: 'value',
    name: '${yLineAxisName!}',
    nameGap: '${yNameGap!}',
<#if lineMin??>
    min: '${lineMin!}',
</#if>
<#if lineMax??>
    max: '${lineMax!}',
</#if>
    nameLocation: '${nameLocation!}',
    nameTextStyle: {
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        fontStyle: '${xyFontStyle!}',
        padding: [yLinePaddingTop, yLinePaddingRight, yLinePaddingBottom, yLinePaddingLeft],
    },
    axisLine: {
        show: false,
        type: 'solid',
        lineStyle: {
            width: '${lineWidth!}',
            color: '${lineColor!}',
        },
    },
    axisLabel: {
        show: true,
        color: '${xyColor!}',
        fontSize: '${xyFontSize!}',
        fontFamily: '${xyFontFamily!}',
        fontWeight: '${xyFontWeight!}',
        formatter: `{value}${lineUnit!}`,
        fontStyle: '${xyFontStyle!}',
    },
}];
const topicColorStr = ${topicColorStr!};
${optionData!}.legendData.forEach((col, index) => {
    if(self.${typeData!}[index] === 'bar') {
    resultSeries.push({
        name: col,
        data: ${optionData!}.yAxisData[index] || [],
        type: 'bar'
    });
} else {
    resultSeries.push({
        lineStyle: {
            width: seriesLineWidth,
        },
        name: col,
        data: ${optionData!}.yAxisData[index] || [],
        yAxisIndex: 1,
        type: 'line'
    });
}
});
return {
    color: topicColorStr,
    title: echatrsTitle,
    tooltip: echatrsTooltip,
    grid: grid,
    legend: {
        itemGap: 20,
        itemWidth: 15,
        itemHeight: 15,
<#if (isShowFlag?? && isShowFlag)>
    show: true,
<#elseif (!isShowFlag?? || !isShowFlag)>
    show: false,
</#if>
        left: '${legendLocation!}',
        textStyle: textStyle,
        data: ${optionData!}.legendData || []
    },
    xAxis: {
        type: 'category',
        name: '${xAxisName!}',
        nameGap: '${xNameGap!}',
        nameLocation: '${nameLocation!}',
        nameTextStyle: nameTextStyle,
        axisLine: axisLine,
        axisLabel: axisLabel,
        data: ${optionData!}.xAxisData || []
    },
    yAxis: yAxis,
    series: resultSeries
}