/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.elementui.visitor.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.LcdpComponent;
import com.jxdinfo.hussar.speedcode.codegenerator.core.component.visitor.VoidVisitor;
import com.jxdinfo.hussar.speedcode.codegenerator.core.ctx.Ctx;
import com.jxdinfo.hussar.speedcode.common.analysismodel.dataset.MethodConfigAnalysis;
import com.jxdinfo.hussar.speedcode.common.util.RenderUtil;
import com.jxdinfo.hussar.speedcode.common.util.ToolUtil;
import com.jxdinfo.hussar.speedcode.common.utils.VoidComponentCodeUtil;
import com.jxdinfo.hussar.speedcode.datasource.model.code.DataModelOperation;
import com.jxdinfo.hussar.speedcode.datasource.model.meta.DataModelBase;
import com.jxdinfo.hussar.speedcode.datasource.model.meta.websocket.WebsocketSetting;
import com.jxdinfo.hussar.speedcode.util.datamodel.DataModelUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebsocketVisitor
implements VoidVisitor {
    public void visit(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        lcdpComponent.registerTemplatePath("template/elementui/element/ApiComponent/apiComponent.ftl");
        this.renderTableLoad(lcdpComponent, ctx);
        VoidComponentCodeUtil.renderData((LcdpComponent)lcdpComponent, (Ctx)ctx);
    }

    public void renderTableLoad(LcdpComponent lcdpComponent, Ctx ctx) throws Exception {
        String dataModelId;
        DataModelBase dataModelBase;
        HashMap<String, String> websocketMap = new HashMap<String, String>();
        JSONObject methodObj = JSONObject.parseObject((String)JSONObject.toJSONString((Object)lcdpComponent.getDatas()));
        if (ToolUtil.isEmpty((Object)methodObj) || ToolUtil.isEmpty((Object)methodObj.get((Object)"datamodel"))) {
            return;
        }
        MethodConfigAnalysis methodConfigAnalysis = (MethodConfigAnalysis)JSONObject.parseObject((String)methodObj.get((Object)"datamodel").toString(), MethodConfigAnalysis.class);
        if (ToolUtil.isNotEmpty((Object)methodConfigAnalysis) && ToolUtil.isNotEmpty((Object)(dataModelBase = DataModelUtil.getDataModelBase((String)(dataModelId = methodConfigAnalysis.getDataModelId())))) && ToolUtil.isNotEmpty((Object)dataModelId)) {
            DataModelOperation operation = dataModelBase.getOperationById(methodConfigAnalysis.getOperationName());
            String operationName = operation.getName();
            Map operationParams = operation.getParams();
            Object websocketObj = operationParams.get("websocket");
            if (ToolUtil.isNotEmpty(websocketObj)) {
                String websocketName = websocketObj.toString();
                List websocketSettingS = dataModelBase.getWebsocket();
                for (WebsocketSetting websocketSetting : websocketSettingS) {
                    if (!websocketSetting.getName().equals(websocketName)) continue;
                    websocketMap.put("name", websocketSetting.getName());
                    websocketMap.put("server", websocketSetting.getServer());
                    websocketMap.put("interfaceUrl", websocketSetting.getInterfaceUrl());
                    break;
                }
                websocketMap.put("instanceKey", lcdpComponent.getInstanceKey());
                ctx.addImports("import SockJS from 'sockjs-client'");
                ctx.addImports(" import Stomp from 'webstomp-client'");
                ctx.addMounted("self." + lcdpComponent.getInstanceKey() + operationName + "();");
                ctx.addMethod(lcdpComponent.getInstanceKey() + operationName, RenderUtil.renderTemplate((String)"/template/elementui/element/websocket/websocket_method.ftl", websocketMap));
            }
        }
    }
}

