<#if (type! == "time")>
    <el-time-picker
        v-model="${vmodel!}"
        format="HH:mm:ss"
        <#if valueType! == "string">
            value-format="HH:mm:ss"
        </#if>
        prefix-icon="el-icon-date"
        <#if (tabindex??)>
            tabindex="${tabindex!}"
        </#if>
        <#if (placeholder??)>
            placeholder="${placeholder!}"
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
        <#if isRange?? && isRange>
            is-range
            :range-separator="'${rangeSeparator!}'"
            :start-placeholder="'${startPlaceholder!}'"
            :end-placeholder="'${endPlaceholder!}'"
        </#if>
    ></el-time-picker>
<#elseif (type! == "year")>
    <el-date-picker
        v-model="${vmodel!}"
        type="${type!}"
        format="yyyy"
    <#if valueType! == "string">
        value-format="yyyy"
    </#if>
        prefix-icon="el-icon-date"
        <#if (tabindex??)>
            tabindex="${tabindex!}"
        </#if>
        <#if (placeholder??)>
            placeholder="${placeholder!}"
        </#if>
        <#if (attributes??)>
            <#list attributes! as attribute>
                ${attribute}
            </#list>
        </#if>
    ></el-date-picker>
<#elseif (type! == "month")>
    <el-date-picker
    v-model="${vmodel!}"
    type="<#if isRange?? && isRange>monthrange<#else>${type!}</#if>"
    <#if !(linkPanels?? && linkPanels)>
        unlink-panels
    </#if>
    format="yyyy-MM"
    <#if valueType! == "string">
        value-format="yyyy-MM"
    </#if>
    prefix-icon="el-icon-date"
    <#if (tabindex??)>
        tabindex="${tabindex!}"
    </#if>
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></el-date-picker>
<#elseif (type! == "date")>
    <el-date-picker
    v-model="${vmodel!}"
    type="<#if isRange?? && isRange>daterange<#else>${type!}</#if>"
    <#if !(linkPanels?? && linkPanels)>
        unlink-panels
    </#if>
    format="yyyy-MM-dd"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd"
    </#if>
    prefix-icon="el-icon-date"
    <#if (tabindex??)>
        tabindex="${tabindex!}"
    </#if>
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></el-date-picker>
<#elseif (type! == "datetime")>
    <el-date-picker
    v-model="${vmodel!}"
    type="<#if isRange?? && isRange>datetimerange<#else>${type!}</#if>"
    <#if !(linkPanels?? && linkPanels)>
        unlink-panels
    </#if>
    format="yyyy-MM-dd HH:mm:ss"
    <#if valueType! == "string">
        value-format="yyyy-MM-dd HH:mm:ss"
    </#if>
    prefix-icon="el-icon-date"
    <#if (tabindex??)>
        tabindex="${tabindex!}"
    </#if>
    <#if (placeholder??)>
        placeholder="${placeholder!}"
    </#if>
    <#if (attributes??)>
        <#list attributes! as attribute>
            ${attribute}
        </#list>
    </#if>
    <#if isRange?? && isRange>
        :range-separator="'${rangeSeparator!}'"
        :start-placeholder="'${startPlaceholder!}'"
        :end-placeholder="'${endPlaceholder!}'"
    </#if>
    ></el-date-picker>
</#if>