<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif importName?? && importName != "">
  <#if queryAttr??>
    const ${importName!}Obj = {
    ${queryAttr}
    <#if orders??>
      ${orders}
    </#if>
    <#if dims?? && (dims?size>0) >
      dims:[
      <#list dims as dim>
        "${dim}"<#if dim_has_next>,</#if>
      </#list>
      ],
    </#if>
    <#if targets?? && (targets?size>0) >
       targets:[
          <#list targets as target>
            {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
          </#list>
       ]
    </#if>
    };
    <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
        const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
        if (queryConditions && queryConditions.length) {
            ${importName!}Obj.superQueryConditionDto = queryConditions;
        }
    </#if>
  <#else>
    const ${importName!}Obj = {
        <#if orders??>
          ${orders}
        </#if>
        <#if dims?? && (dims?size>0) >
          dims:[
            <#list dims as dim>
              "${dim}"<#if dim_has_next>,</#if>
            </#list>
          ],
        </#if>
        <#if targets?? && (targets?size>0) >
            targets:[
                <#list targets as target>
                  {"columnName":"${target['columnName']!}","agg":"${target['agg']!}","asAlias":"${target['asAlias']!}"}<#if target_has_next>,</#if>
                </#list>
            ]
        </#if>
    };
  </#if>
    <#-- 绑定的是新的数据集模型 -->
    <#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
      if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
      <#-- 声明变量 -->
      <#assign subDimValue = "">
      <#assign metricsValue = "">
      <#assign rightBarValue = "">
      <#assign dimValue = "">

      <#-- 遍历 targets 并提取第一个匹配项 -->
      <#list targets as target>
        <#if target.names == "SubDim" && subDimValue == "">
          <#assign subDimValue = target.asAlias!>
        </#if>
        <#if target.names == "Metrics" && metricsValue == "">
          <#assign metricsValue = target.asAlias!>
        </#if>
        <#if target.names == "BarDim" && rightBarValue == "">
          <#assign rightBarValue = target.asAlias!>
        </#if>
        <#if (target.names != "SubDim" && target.names != "Metrics" && target.names != "BarDim") && dimValue == "">
          <#assign dimValue = target.asAlias!>
        </#if>
      </#list>
      const legendNames = [
        <#list targets as target>
          <#if target.asAlias == "${subDimValue}">
            "${target.legendName!target.asAlias}"<#break>
          </#if>
        </#list>,

        <#list targets as target>
          <#if target.asAlias == "${rightBarValue}">
            "${target.legendName!target.asAlias}"<#break>
          </#if>
        </#list>
      ];
      const dataBaseData = res.data.data.map((item) => {
      const subDim = item["${subDimValue}"] || item["${subDimValue?lower_case}"] ||item["${subDimValue?upper_case}"];
      const metrics = item["${metricsValue}"] || item["${metricsValue?lower_case}"] ||item["${metricsValue?upper_case}"];
      return {
        ...item,
        dimValueArr: subDim.split(',').map(str => str.trim()),
        metricsValueArr: metrics.split(',').map(str => Number(str.trim()))
        }
      });
      self.${instanceKey!}PropsData.legendData = [...new Set(
        dataBaseData.flatMap(item => {
          const subDimsStr = item["${subDimValue}"] || item["${subDimValue?lower_case}"] || item["${subDimValue?upper_case}"];
          if (!subDimsStr) return [];
          return subDimsStr.split(',').map(sub => sub.trim()).filter(sub => sub !== '');
        })
        )];
      self.${instanceKey!}PropsData.rightBaryAxisData = dataBaseData.map((item) => item["${rightBarValue}"] || item["${rightBarValue?lower_case}"] || item["${rightBarValue?upper_case}"]);
      self.${instanceKey!}PropsData.xAxisData = dataBaseData.map((item) => item["${dimValue}"] || item["${dimValue?lower_case}"] || item["${dimValue?upper_case}"]);
      self.${instanceKey!}PropsData.yAxisData =  self.${instanceKey!}PropsData.legendData.map(subDim => {
        return dataBaseData.map(item => {
          const index = item.dimValueArr.indexOf(subDim);
          return index !== -1 ? item.metricsValueArr[index] : 0;
        });
      });
      self.${instanceKey!}PropsData.legendList = legendNames;
       self.${instanceKey!}OptionData = {
         xAxisData:self.${instanceKey!}PropsData.xAxisData,
         yAxisData: self.${instanceKey!}PropsData.yAxisData,
         rightBaryAxisData: self.${instanceKey!}PropsData.rightBaryAxisData,
         legendData: self.${instanceKey!}PropsData.legendData,
         legendList: self.${instanceKey!}PropsData.legendList,
       }

      } else {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
      }
    }).catch(function() {
      HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    })
    <#else>
  ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
      const dataBaseArray = res.data.data;
      const xAxisData = [...new Set(dataBaseArray.map(item => item.${xAxisCols!}))];
      const legendData = [...new Set(dataBaseArray.map(item => item.${legendCols!}))];
      const yAxisData = legendData.map(l => {
        return xAxisData.map(x => {
            const items = dataBaseArray.filter(
                item => item.${legendCols!} === l && item.${xAxisCols!} === x
            );
            return items.reduce((sum, item) => sum + parseInt(item.${seriesCols!} || 0, 10), 0);
        });
      })
      const rightBaryAxisData = xAxisData.map(x => {
            const items = dataBaseArray.filter(item => item.${xAxisCols!} === x
        );
        return items.reduce((sum, item) => sum + parseInt( item.${rightBarSeriesCols!} || 0, 10), 0)
      })
      const legendList = [
        <#list listLegend as item>"${item}"<#if item_has_next>,</#if></#list>
      ];
      ${curPropsData!}.xAxisData = xAxisData;
      ${curPropsData!}.yAxisData = yAxisData;
      ${curPropsData!}.rightBaryAxisData = rightBaryAxisData;
      ${curPropsData!}.legendData = legendData;
      ${curPropsData!}.legendList = legendList;
      self.${instanceKey!}OptionData = {
          yAxisData: self.${instanceKey!}PropsData.yAxisData,
          xAxisData: self.${instanceKey!}PropsData.xAxisData,
          legendData: self.${instanceKey!}PropsData.legendData,
          legendList: self.${instanceKey!}PropsData.legendList,
          rightBaryAxisData: self.${instanceKey!}PropsData.rightBaryAxisData,
      };
      self.$nextTick(() => {
      self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.addLegendselectchanged && self.$refs.${instanceKey!}Ref.addLegendselectchanged();
      });
    } else {
      HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
    }
  }).catch(function() {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  })
  </#if>
<#elseif isDataSetType??>
<#-- START +++++++++++++++++++++++++++++++++ 请求数据集数据接口 +++++++++++++++++++++++++++++++ -->
  const modelFields = {
  dataModelId: '${dataModelId!}',
  dim: [
  <#list dims! as item>
    {
    field: '${item.field!}',
    fieldAlias: '${item.fieldAlias!}'
    },
  </#list>
  ],
  metrics: [
  <#list metrics! as item>
    {
    field: '${item.field!}',
    fieldAlias: '${item.fieldAlias!}',
    function: '${item.function!}',
    rename: '${item.rename!}'
    },
  </#list>
  ]
  };
  const dataSetSort = [
  <#list dataSetSort! as item>
    {
    column: '${item.column!}',
    asc: ${item.asc?string("true", "false")}
    }
  </#list>
  ];
  const superQuery = [
  ${DataSetQueryCondition!}
  ];
  const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
  const legendData = modelFields.metrics.map((item) => item.rename || item.field);
  const dataModelProperty = dataSetResolve.resolveDataSetChartProperty(modelFields, dataSetSort, dataSetQuery);
  chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
  if (res && res.code === 10000 && res.data) {
  const dimArr = modelFields.dim.map((item) => <#noparse>`${item.fieldAlias}Dim`</#noparse>);
  const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
  self.${instanceKey!}OptionData.xAxisData = res.data.data.map((item) => item[dimArr[0]]);
  self.${instanceKey!}OptionData.yAxisData = metricsArr.map((metric) => res.data.data.map((item) => item[metric]));
  self.${instanceKey!}OptionData.legendData = legendData.map((item) => <#noparse>`[${item}]`</#noparse>);
  }
  }).catch(function () {
  HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
  });
<#else>
<#-- 没有设置数据模型时-->
if (self.${instanceKey!}OptionData.yAxisData.length === 0 && self.${instanceKey!}OptionData.xAxisData.length === 0 && self.${instanceKey!}OptionData.legendData.length === 0) {
<#if isDefaultValue?? && isDefaultValue == false>
  self.${instanceKey!}OptionData.xAxisData = ['[名称1]', '[名称2]', '[名称3]', '[名称4]', '[名称5]'];
  self.${instanceKey!}OptionData.yAxisData = [[125, 95, 115, 79, 113], [105, 78, 92, 68, 101], [120, 93, 103, 75, 100]];
  self.${instanceKey!}OptionData.legendData = ['[图例1]', '[图例2]', '[图例3]'];
  self.${instanceKey!}OptionData.rightBaryAxisData = [234, 123, 142, 367, 890];
  self.${instanceKey!}OptionData.legendList = ['左侧堆积', '右侧进度'];
</#if>
  }
  self.$nextTick(() => {
  self.$refs.${instanceKey!}Ref && self.$refs.${instanceKey!}Ref.addLegendselectchanged && self.$refs.${instanceKey!}Ref.addLegendselectchanged();
  });
</#if>
