<#--如果图表存在引用和取值-->
<#if isQuoteOrGetValue??>
<#elseif (importName?? && importName != "" && dbdHaveMethod?? && dbdHaveMethod) || (isNewDataSet?? && isNewDataSet)>
    <#if queryAttr??>
        const ${importName!}Obj = {
        ${queryAttr}
        <#if orders??>
        ${orders}
        </#if>
        dims:[
           <#list dims! as dim>
               "${dim['convertName']!}"<#if dim_has_next>,</#if>
           </#list>
        ],
        targets:[
            <#list metrics! as metric>
                {"columnName":"${metric['convertName']!}","agg":"${metric['function']!}","asAlias":"${metric['asAlias']!}"},
            </#list>
        ]
        };
        <#if isNewDataSet?? && isNewDataSet && isDataSetSearch>
            const queryConditions = self.${instanceKey}GetQueryConditions(${importName!}Obj);
            if (queryConditions && queryConditions.length) {
                ${importName!}Obj.superQueryConditionDto = queryConditions;
            }
        </#if>
    <#else>
    const ${importName!}Obj = {
        <#if orders??>
            ${orders}
        </#if>
           dims:[
              <#list dims! as dim>
                  "${dim['convertName']!}"<#if dim_has_next>,</#if>
              </#list>
           ],
           targets:[
               <#list metrics! as metric>
                   {"columnName":"${metric['convertName']!}","agg":"${metric['function']!}","asAlias":"${metrics['asAlias']!}"},
               </#list>
           ]
    };
    </#if>
    <#-- 绑定的是新的数据集模型 -->
    <#if isNewDataSet?? && isNewDataSet>
    ${importName!}['${importMethod!}'](${importName!}Obj).then(res => {
        if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
          const dataBaseArray = res.data.data;
          const metrics = [
              <#list metrics! as item>
                {
                  field: '${item.field!}',
                  fieldAlias: '${item.convertName!}',
                  rename: '${item.legendName!}',
                  dataType: '${item.dataType!}',
                  function: '${item.function!}',
                },
              </#list>
          ];
          const sortedMetrics = metrics.sort((a, b) => {
            const order = ['left', 'mid', 'right'];
            return order.indexOf(a.dataType) - order.indexOf(b.dataType);
            });
          const metricsArr = metrics.map((item) => <#noparse>`${item.fieldAlias}${item.function}Metrics`</#noparse>);
          const sortedLegendData = sortedMetrics.map((item) => `[${'$'}{item.rename || item.field}]`);
          const sortedSeriesData = metricsArr.map((metric) => dataBaseArray.map((item) => item[metric] || item[metric.toLowerCase()] || item[metric.toUpperCase()]));
         const sortedMetricsDataType = [];
            if (sortedMetrics.length < 3) {
              sortedMetrics.forEach((item) => {
                sortedMetricsDataType.push(item.dataType);
              });
            }
            if (sortedMetricsDataType.length > 0) {
              if (sortedMetricsDataType.indexOf('left') === -1) {
                sortedLegendData.unshift('');
                sortedSeriesData.unshift('');
              }
              if (sortedMetricsDataType.indexOf('mid') === -1) {
                sortedLegendData.splice(1, 0, '');
                sortedSeriesData.splice(1, 0, '');
              }
              if (sortedMetricsDataType.indexOf('right') === -1) {
                sortedLegendData.push('');
                sortedSeriesData.push('');
              }
            }
          ${optionData!} = {
          xAxisData: sortedLegendData,
          seriesData: sortedSeriesData
          }
        } else {
          HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
        }
      }).catch(function() {
        HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
      })
    <#else>
<#--&lt;#&ndash;开始基础数据&ndash;&gt;-->
    ${importName!}.${importMethod!}(${importName!}Obj).then(res => {
    if ((res.code === 200 || res.code === 10000) && res.data && res.data.data) {
    ${optionData!}.xAxisData = [];
    ${optionData!}.seriesData = [];
<#--为开始基础数据赋值查询出来的数据-->
    res.data.data.forEach((item, index) => {
    if (index < 3) {
    ${optionData!}.xAxisData.push(item.${axisCols!});
    ${optionData!}.seriesData.push(item.${seriesCols!});
    }
    });
    }else{
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestFailed', fallbackStr: '数据请求失败'}), 'error');
    }
    }).catch(function() {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    })
    </#if>
<#--    没有设置数据模型时-->
<#elseif isDataSetType??>
    const modelFields = {
    dataModelId: '${dataModelId!}',
    dim: [
    <#list dims! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}'
        },
    </#list>
    ],
    metrics: [
    <#list metrics! as item>
        {
        field: '${item.field!}',
        fieldAlias: '${item.fieldAlias!}',
        function: '${item.function!}',
        rename: '${item.rename!}',
        dataType: '${item.dataType!}'
        },
    </#list>
    ]
    };
    const dataSetSort = [
    <#list dataSetSort! as item>
        {
        column: '${item.column!}',
        asc: ${item.asc?string("true", "false")}
        }
    </#list>
    ];
    const superQuery = [
    ${DataSetQueryCondition!}
    ];
    const dataSetQuery = dataSetResolve.changeDataSetQuery(superQuery);
    const dataModelProperty = dataSetResolve.resolveDataSetChartProperty(modelFields, dataSetSort, dataSetQuery);
    chartApi.getChartDataSetViews(dataModelProperty).then((res) => {
    if (res && res.code === 10000 && res.data) {
    const sortedMetrics = modelFields.metrics.sort((a, b) => {
    const order = ['left', 'mid', 'right'];
    return order.indexOf(a.dataType) - order.indexOf(b.dataType);
    });
    const metricsArr = modelFields.metrics.map((item) => <#noparse>`${item.fieldAlias}Metrics`</#noparse>);
    const sortedLegendData = sortedMetrics.map((item) => <#noparse>`[${item.rename || item.field}]`</#noparse>);
    const sortedSeriesData = metricsArr.map((metric) => res.data.data.map((item) => item[metric]));
    ${optionData!} = {
    xAxisData: sortedLegendData,
    seriesData: sortedSeriesData
    }
    }
    }).catch(function () {
    HussarRouter.showMsg(self, self.hussar_t({key: 'vfg.dataRequestAbnormal', fallbackStr: '数据请求异常'}), 'error');
    });
<#else>
    <#if isDefaultValue?? && isDefaultValue == false>
        if(${optionData!}.xAxisData.length === 0 && ${optionData!}.seriesData.length === 0){
        ${optionData!} = {
        xAxisData: ['[仪表盘一名称]', '[仪表盘二名称]', '[仪表盘三名称]'],
        seriesData: [15, 80, 20]
        }
        }
    </#if>
</#if>