/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.echarts.visitor.provide;

import com.jxdinfo.hussar.formdesign.base.common.constant.CodePrefix;
import com.jxdinfo.hussar.formdesign.base.common.constant.CodeSuffix;
import com.jxdinfo.hussar.formdesign.base.common.utils.ComponentDataUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.EventParamConfig;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ValueVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.echarts.JXDHTreeChart.value")
@Scope(value="prototype")
public class HTreeChartValueProvide
implements ValueVisitor<LcdpComponent, Ctx> {
    private LcdpComponent lcdpComponent;
    private Map<String, Object> params;
    private Ctx ctx;

    public void visit(LcdpComponent lcdpComponent, Ctx ctx, Map<String, Object> params) {
        this.lcdpComponent = lcdpComponent;
        this.params = params;
        this.ctx = ctx;
    }

    public String setValue(List<String> dataItems) {
        return this.getThisPrefix() + this.lcdpComponent.getInstanceKey() + CodeSuffix._DATA.getType();
    }

    public Map<String, String> getComponentColMapping() {
        return new HashMap<String, String>(16);
    }

    public List<ComponentData> getClearValue(List<String> dataItems) throws LcdpException {
        return Collections.emptyList();
    }

    public ComponentData getEventParam(EventParamConfig eventParamConfig) throws LcdpException {
        return null;
    }

    private String getThisPrefix() {
        String thisPrefix = CodePrefix._THIS.getType();
        if (ToolUtil.isNotEmpty(this.params) && ToolUtil.isNotEmpty((Object)this.params.get(CodePrefix.SELF.getType()))) {
            thisPrefix = CodePrefix._SELF.getType();
        }
        return thisPrefix;
    }

    public String getDefaultValue() {
        return "[]";
    }

    public ComponentData getDataItemValue(List<String> dataItems) throws LcdpException {
        ComponentData data = new ComponentData();
        if (ToolUtil.isNotEmpty(dataItems) && dataItems.size() == 2) {
            data.setDataType(ComponentData.DataTypeEnum.ARRAY_PRIMARY);
            data.setDataItemSource(ComponentData.DataItemSourceEnum.READONLY);
            String field = dataItems.get(1);
            String optionData = CodePrefix._SELF.getType() + this.lcdpComponent.getInstanceKey() + CodeSuffix._OPTION_DATA.getType();
            data.setRenderValue("function() {\n let result = [];\nfor(let i = 0,optionLen = " + optionData + ".length;i < optionLen;i++){\nresult.push(" + optionData + "[i]." + field + ");\n}\nreturn result;\n}()");
        } else {
            data.setDataType(ComponentData.DataTypeEnum.TREE_OBJECT);
            ArrayList<String> currDataItem = new ArrayList<String>();
            currDataItem.add("data");
            data.setRenderValue(ComponentDataUtil.getComponentDataRender((LcdpComponent)this.lcdpComponent, (Ctx)this.ctx, (String)CodeSuffix._OPTION_DATA.getType(), currDataItem));
        }
        return data;
    }

    public ComponentData getDefaultValueByDataItem(List<String> list) throws LcdpException {
        return null;
    }

    public ComponentData getDataSourceByDataItem(List<String> list) throws LcdpException {
        return null;
    }
}

