/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.echarts.element;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventPreHandler;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.factory.StyleFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClassAdapter;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ClazzFactory;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.VoidVisitor;
import com.jxdinfo.hussar.formdesign.echarts.visitor.element.HDigitalCardVoidVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class HDigitalCard
extends LcdpComponent {
    @PostConstruct
    public void register() {
        String name = "com.jxdinfo.echarts.JXDHDigitalCard";
        ClazzFactory.register((String)name, (String)((Object)((Object)this)).getClass().getName());
        StyleFactory.addComponentClassName((String)name, (String)".jxd_ins_hDigitalCard");
    }

    public VoidVisitor<LcdpComponent, Ctx> visitor() {
        return new HDigitalCardVoidVisitor();
    }

    public Map<String, String> styleTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("borderTop", "${prefix} {border-top:${val} !important;}");
        map.put("borderRight", "${prefix} {border-right:${val} !important;}");
        map.put("borderBottom", "${prefix} {border-bottom:${val} !important;}");
        map.put("borderLeft", "${prefix} {border-left:${val} !important;}");
        map.put("borderTopColor", "${prefix} {border-top-color:${val} !important;}");
        map.put("borderRightColor", "${prefix} {border-right-color:${val} !important;}");
        map.put("borderBottomColor", "${prefix} {border-bottom-color:${val} !important;}");
        map.put("borderLeftColor", "${prefix} {border-left-color:${val} !important;}");
        map.put("borderRadius", "${prefix} {border-radius:${val};}");
        map.put("boxShadow", "${prefix} {box-shadow:${val};}");
        map.put("backgroundColor", "${prefix} {background-color:${val};}");
        map.put("backgroundImage", "${prefix} {background-image:${val};}");
        map.put("backgroundPosition", "${prefix} {background-position:${val};}");
        map.put("backgroundSize", "${prefix} {background-size:${val};}");
        map.put("backgroundRepeat", "${prefix} {background-repeat:${val};}");
        map.put("numberBackgroundColor", "${prefix} .__h_digital_card-number-box{background-color:${val};}");
        map.put("numberBackgroundImage", "${prefix} .__h_digital_card-number-box{background-image:${val};}");
        map.put("numberBackgroundPosition", "${prefix} .__h_digital_card-number-box{background-position:${val};}");
        map.put("numberBackgroundSize", "${prefix} .__h_digital_card-number-box{background-size:${val};}");
        map.put("numberBackgroundRepeat", "${prefix} .__h_digital_card-number-box{background-repeat:${val};}");
        map.put("fontFamily", "${prefix} .__h_digital_card-number-box{font-family:${val};}");
        map.put("fontSize", "${prefix} .__h_digital_card-number-box{font-size:${val};}");
        map.put("color", "${prefix} .__h_digital_card-number-box{color:${val};}");
        map.put("fontWeight", "${prefix} .__h_digital_card-number-box{font-weight:${val};}");
        map.put("splitFontFamily", "${prefix} .__h_digital_card-split-box{font-family:${val};}");
        map.put("splitFontSize", "${prefix} .__h_digital_card-split-box{font-size:${val};}");
        map.put("splitColor", "${prefix} .__h_digital_card-split-box{color:${val};}");
        map.put("splitFontWeight", "${prefix} .__h_digital_card-split-box{font-weight:${val};}");
        map.put("cardBoxWidth", "${prefix} {width:${val};}");
        return map;
    }

    public Map<String, String> propsTemplate() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isBorderNew", "dynamicStyleTemplate");
        map.put("isBorderRadiusNew", "dynamicStyleTemplate");
        map.put("isShadowNew", "dynamicStyleTemplate");
        return map;
    }

    public static Function<Object, Object> dynamicStyleTemplate(String key) {
        HashMap<String, Function<Object, Object>> map = new HashMap<String, Function<Object, Object>>();
        map.put("isBorderNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border: none !important}";
            }
            return "";
        });
        map.put("isBorderRadiusNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {border-radius: unset}";
            }
            return "";
        });
        map.put("isShadowNew", value -> {
            if (!((Boolean)value).booleanValue()) {
                return "${prefix} {box-shadow: none}";
            }
            return "";
        });
        return (Function)map.get(key);
    }

    public static HDigitalCard newComponent(JSONObject jsonObject) {
        HDigitalCard digitalCard = (HDigitalCard)((Object)ClassAdapter.jsonObjectToBean((JSONObject)jsonObject, (String)HDigitalCard.class.getName()));
        EventPreHandler.dealDisabled((LcdpComponent)digitalCard);
        Object backgroundImg = digitalCard.getInnerStyles().get("backgroundImageBack");
        digitalCard.getInnerStyles().remove("backgroundImageBack");
        if (ToolUtil.isNotEmpty(backgroundImg)) {
            digitalCard.getInnerStyles().put("backgroundImage", backgroundImg);
        }
        if (ToolUtil.isNotEmpty((Object)digitalCard.getWidth())) {
            digitalCard.getInnerStyles().put("cardBoxWidth", digitalCard.getWidth().toString() + "px");
        }
        Object numberBackgroundImage = digitalCard.getInnerStyles().get("numberBackgroundImageBack");
        digitalCard.getInnerStyles().remove("numberBackgroundImage");
        if (ToolUtil.isNotEmpty((Object)((Object)digitalCard))) {
            digitalCard.getInnerStyles().put("numberBackgroundImage", numberBackgroundImage);
        }
        return digitalCard;
    }
}

